/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.TickListServer;
import org.slf4j.Logger;

public class WorldServer
extends World
implements GeneratorAccessSeed {
    public static final BlockPosition END_SPAWN_POINT = new BlockPosition(100, 50, 0);
    public static final IntProvider RAIN_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider RAIN_DURATION = UniformInt.of(12000, 24000);
    private static final IntProvider THUNDER_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider THUNDER_DURATION = UniformInt.of(3600, 15600);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EMPTY_TIME_NO_TICK = 300;
    private static final int MAX_SCHEDULED_TICKS_PER_TICK = 65536;
    final List<EntityPlayer> players = Lists.newArrayList();
    private final ChunkProviderServer chunkSource;
    private final MinecraftServer server;
    public final IWorldDataServer serverLevelData;
    private int lastSpawnChunkRadius;
    final EntityTickList entityTickList = new EntityTickList();
    public final PersistentEntitySectionManager<Entity> entityManager;
    private final GameEventDispatcher gameEventDispatcher;
    public boolean noSave;
    private final SleepStatus sleepStatus;
    private int emptyTime;
    private final PortalTravelAgent portalForcer;
    private final TickListServer<Block> blockTicks = new TickListServer(this::isPositionTickingWithEntitiesLoaded, this.getProfilerSupplier());
    private final TickListServer<FluidType> fluidTicks = new TickListServer(this::isPositionTickingWithEntitiesLoaded, this.getProfilerSupplier());
    private final PathTypeCache pathTypesByPosCache = new PathTypeCache();
    final Set<EntityInsentient> navigatingMobs = new ObjectOpenHashSet();
    volatile boolean isUpdatingNavigations;
    protected final PersistentRaid raids;
    private final ObjectLinkedOpenHashSet<BlockActionData> blockEvents = new ObjectLinkedOpenHashSet();
    private final List<BlockActionData> blockEventsToReschedule = new ArrayList<BlockActionData>(64);
    private boolean handlingTick;
    private final List<MobSpawner> customSpawners;
    @Nullable
    private EnderDragonBattle dragonFight;
    final Int2ObjectMap<EntityComplexPart> dragonParts = new Int2ObjectOpenHashMap();
    private final StructureManager structureManager;
    private final StructureCheck structureCheck;
    private final boolean tickTime;
    private final RandomSequences randomSequences;

    public WorldServer(MinecraftServer var0, Executor var1, Convertable.ConversionSession var2, IWorldDataServer var3, ResourceKey<World> var4, WorldDimension var5, WorldLoadListener var6, boolean var7, long var8, List<MobSpawner> var10, boolean var11, @Nullable RandomSequences var12) {
        super(var3, var4, var0.registryAccess(), var5.type(), var0::getProfiler, false, var7, var8, var0.getMaxChainedNeighborUpdates());
        this.tickTime = var11;
        this.server = var0;
        this.customSpawners = var10;
        this.serverLevelData = var3;
        ChunkGenerator var13 = var5.generator();
        boolean var14 = var0.forceSynchronousWrites();
        DataFixer var15 = var0.getFixerUpper();
        EntityStorage var16 = new EntityStorage(new SimpleRegionStorage(new RegionStorageInfo(var2.getLevelId(), var4, "entities"), var2.getDimensionPath(var4).resolve("entities"), var15, var14, DataFixTypes.ENTITY_CHUNK), this, var0);
        this.entityManager = new PersistentEntitySectionManager<Entity>(Entity.class, new a(), var16);
        this.chunkSource = new ChunkProviderServer(this, var2, var15, var0.getStructureManager(), var1, var13, var0.getPlayerList().getViewDistance(), var0.getPlayerList().getSimulationDistance(), var14, var6, this.entityManager::updateChunkStatus, () -> var0.overworld().getDataStorage());
        this.chunkSource.getGeneratorState().ensureStructuresGenerated();
        this.portalForcer = new PortalTravelAgent(this);
        this.updateSkyBrightness();
        this.prepareWeather();
        this.getWorldBorder().setAbsoluteMaxSize(var0.getAbsoluteMaxWorldSize());
        this.raids = this.getDataStorage().computeIfAbsent(PersistentRaid.factory(this), PersistentRaid.getFileId(this.dimensionTypeRegistration()));
        if (!var0.isSingleplayer()) {
            var3.setGameType(var0.getDefaultGameType());
        }
        long var17 = var0.getWorldData().worldGenOptions().seed();
        this.structureCheck = new StructureCheck(this.chunkSource.chunkScanner(), this.registryAccess(), var0.getStructureManager(), var4, var13, this.chunkSource.randomState(), this, var13.getBiomeSource(), var17, var15);
        this.structureManager = new StructureManager(this, var0.getWorldData().worldGenOptions(), this.structureCheck);
        this.dragonFight = this.dimension() == World.END && this.dimensionTypeRegistration().is(BuiltinDimensionTypes.END) ? new EnderDragonBattle(this, var17, var0.getWorldData().endDragonFightData()) : null;
        this.sleepStatus = new SleepStatus();
        this.gameEventDispatcher = new GameEventDispatcher(this);
        this.randomSequences = Objects.requireNonNullElseGet(var12, () -> this.getDataStorage().computeIfAbsent(RandomSequences.factory(var17), "random_sequences"));
    }

    @Deprecated
    @VisibleForTesting
    public void setDragonFight(@Nullable EnderDragonBattle var0) {
        this.dragonFight = var0;
    }

    public void setWeatherParameters(int var0, int var1, boolean var2, boolean var3) {
        this.serverLevelData.setClearWeatherTime(var0);
        this.serverLevelData.setRainTime(var1);
        this.serverLevelData.setThunderTime(var1);
        this.serverLevelData.setRaining(var2);
        this.serverLevelData.setThundering(var3);
    }

    @Override
    public Holder<BiomeBase> getUncachedNoiseBiome(int var0, int var1, int var2) {
        return this.getChunkSource().getGenerator().getBiomeSource().getNoiseBiome(var0, var1, var2, this.getChunkSource().randomState().sampler());
    }

    public StructureManager structureManager() {
        return this.structureManager;
    }

    public void tick(BooleanSupplier var0) {
        boolean var5;
        long var52;
        int var4;
        GameProfilerFiller var1 = this.getProfiler();
        this.handlingTick = true;
        TickRateManager var22 = this.tickRateManager();
        boolean var3 = var22.runsNormally();
        if (var3) {
            var1.push("world border");
            this.getWorldBorder().tick();
            var1.popPush("weather");
            this.advanceWeatherCycle();
        }
        if (this.sleepStatus.areEnoughSleeping(var4 = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE)) && this.sleepStatus.areEnoughDeepSleeping(var4, this.players)) {
            if (this.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                var52 = this.levelData.getDayTime() + 24000L;
                this.setDayTime(var52 - var52 % 24000L);
            }
            this.wakeUpAllPlayers();
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE) && this.isRaining()) {
                this.resetWeatherCycle();
            }
        }
        this.updateSkyBrightness();
        if (var3) {
            this.tickTime();
        }
        var1.popPush("tickPending");
        if (!this.isDebug() && var3) {
            var52 = this.getGameTime();
            var1.push("blockTicks");
            this.blockTicks.tick(var52, 65536, this::tickBlock);
            var1.popPush("fluidTicks");
            this.fluidTicks.tick(var52, 65536, this::tickFluid);
            var1.pop();
        }
        var1.popPush("raid");
        if (var3) {
            this.raids.tick();
        }
        var1.popPush("chunkSource");
        this.getChunkSource().tick(var0, true);
        var1.popPush("blockEvents");
        if (var3) {
            this.runBlockEvents();
        }
        this.handlingTick = false;
        var1.pop();
        boolean bl = var5 = !this.players.isEmpty() || !this.getForcedChunks().isEmpty();
        if (var5) {
            this.resetEmptyTime();
        }
        if (var5 || this.emptyTime++ < 300) {
            var1.push("entities");
            if (this.dragonFight != null && var3) {
                var1.push("dragonFight");
                this.dragonFight.tick();
                var1.pop();
            }
            this.entityTickList.forEach(var2 -> {
                if (var2.isRemoved()) {
                    return;
                }
                if (this.shouldDiscardEntity((Entity)var2)) {
                    var2.discard();
                    return;
                }
                if (var22.isEntityFrozen((Entity)var2)) {
                    return;
                }
                var1.push("checkDespawn");
                var2.checkDespawn();
                var1.pop();
                if (!this.chunkSource.chunkMap.getDistanceManager().inEntityTickingRange(var2.chunkPosition().toLong())) {
                    return;
                }
                Entity var3 = var2.getVehicle();
                if (var3 != null) {
                    if (var3.isRemoved() || !var3.hasPassenger((Entity)var2)) {
                        var2.stopRiding();
                    } else {
                        return;
                    }
                }
                var1.push("tick");
                this.guardEntityTick(this::tickNonPassenger, var2);
                var1.pop();
            });
            var1.pop();
            this.tickBlockEntities();
        }
        var1.push("entityManagement");
        this.entityManager.tick();
        var1.pop();
    }

    @Override
    public boolean shouldTickBlocksAt(long var0) {
        return this.chunkSource.chunkMap.getDistanceManager().inBlockTickingRange(var0);
    }

    protected void tickTime() {
        if (!this.tickTime) {
            return;
        }
        long var0 = this.levelData.getGameTime() + 1L;
        this.serverLevelData.setGameTime(var0);
        this.serverLevelData.getScheduledEvents().tick(this.server, var0);
        if (this.levelData.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
            this.setDayTime(this.levelData.getDayTime() + 1L);
        }
    }

    public void setDayTime(long var0) {
        this.serverLevelData.setDayTime(var0);
    }

    public void tickCustomSpawners(boolean var0, boolean var1) {
        for (MobSpawner var3 : this.customSpawners) {
            var3.tick(this, var0, var1);
        }
    }

    private boolean shouldDiscardEntity(Entity var0) {
        if (!this.server.isSpawningAnimals() && (var0 instanceof EntityAnimal || var0 instanceof EntityWaterAnimal)) {
            return true;
        }
        return !this.server.areNpcsEnabled() && var0 instanceof NPC;
    }

    private void wakeUpAllPlayers() {
        this.sleepStatus.removeAllSleepers();
        this.players.stream().filter(EntityLiving::isSleeping).collect(Collectors.toList()).forEach(var0 -> var0.stopSleepInBed(false, false));
    }

    public void tickChunk(Chunk var0, int var1) {
        BlockPosition var7;
        ChunkCoordIntPair var2 = var0.getPos();
        boolean var3 = this.isRaining();
        int var4 = var2.getMinBlockX();
        int var5 = var2.getMinBlockZ();
        GameProfilerFiller var6 = this.getProfiler();
        var6.push("thunder");
        if (var3 && this.isThundering() && this.random.nextInt(100000) == 0 && this.isRainingAt(var7 = this.findLightningTargetAround(this.getBlockRandomPos(var4, 0, var5, 15)))) {
            Entity var10;
            boolean var9;
            DifficultyDamageScaler var8 = this.getCurrentDifficultyAt(var7);
            boolean bl = var9 = this.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.random.nextDouble() < (double)var8.getEffectiveDifficulty() * 0.01 && !this.getBlockState(var7.below()).is(Blocks.LIGHTNING_ROD);
            if (var9 && (var10 = EntityTypes.SKELETON_HORSE.create(this)) != null) {
                ((EntityHorseSkeleton)var10).setTrap(true);
                ((EntityAgeable)var10).setAge(0);
                var10.setPos(var7.getX(), var7.getY(), var7.getZ());
                this.addFreshEntity(var10);
            }
            if ((var10 = EntityTypes.LIGHTNING_BOLT.create(this)) != null) {
                var10.moveTo(Vec3D.atBottomCenterOf(var7));
                ((EntityLightning)var10).setVisualOnly(var9);
                this.addFreshEntity(var10);
            }
        }
        var6.popPush("iceandsnow");
        for (int var72 = 0; var72 < var1; ++var72) {
            if (this.random.nextInt(48) != 0) continue;
            this.tickPrecipitation(this.getBlockRandomPos(var4, 0, var5, 15));
        }
        var6.popPush("tickBlocks");
        if (var1 > 0) {
            ChunkSection[] var73 = var0.getSections();
            for (int var8 = 0; var8 < var73.length; ++var8) {
                ChunkSection var9 = var73[var8];
                if (!var9.isRandomlyTicking()) continue;
                int var10 = var0.getSectionYFromSectionIndex(var8);
                int var11 = SectionPosition.sectionToBlockCoord(var10);
                for (int var12 = 0; var12 < var1; ++var12) {
                    Fluid var15;
                    BlockPosition var13 = this.getBlockRandomPos(var4, var11, var5, 15);
                    var6.push("randomTick");
                    IBlockData var14 = var9.getBlockState(var13.getX() - var4, var13.getY() - var11, var13.getZ() - var5);
                    if (var14.isRandomlyTicking()) {
                        var14.randomTick(this, var13, this.random);
                    }
                    if ((var15 = var14.getFluidState()).isRandomlyTicking()) {
                        var15.randomTick(this, var13, this.random);
                    }
                    var6.pop();
                }
            }
        }
        var6.pop();
    }

    @VisibleForTesting
    public void tickPrecipitation(BlockPosition var0) {
        BlockPosition var1 = this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, var0);
        BlockPosition var2 = var1.below();
        BiomeBase var3 = this.getBiome(var1).value();
        if (var3.shouldFreeze(this, var2)) {
            this.setBlockAndUpdate(var2, Blocks.ICE.defaultBlockState());
        }
        if (this.isRaining()) {
            Object var5;
            int var4 = this.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
            if (var4 > 0 && var3.shouldSnow(this, var1)) {
                var5 = this.getBlockState(var1);
                if (((BlockBase.BlockData)var5).is(Blocks.SNOW)) {
                    int var6 = ((IBlockDataHolder)var5).getValue(BlockSnow.LAYERS);
                    if (var6 < Math.min(var4, 8)) {
                        IBlockData var7 = (IBlockData)((IBlockDataHolder)var5).setValue(BlockSnow.LAYERS, var6 + 1);
                        Block.pushEntitiesUp((IBlockData)var5, var7, this, var1);
                        this.setBlockAndUpdate(var1, var7);
                    }
                } else {
                    this.setBlockAndUpdate(var1, Blocks.SNOW.defaultBlockState());
                }
            }
            if ((var5 = var3.getPrecipitationAt(var2)) != BiomeBase.Precipitation.NONE) {
                IBlockData var6 = this.getBlockState(var2);
                var6.getBlock().handlePrecipitation(var6, this, var2, (BiomeBase.Precipitation)var5);
            }
        }
    }

    private Optional<BlockPosition> findLightningRod(BlockPosition var02) {
        Optional<BlockPosition> var1 = this.getPoiManager().findClosest(var0 -> var0.is(PoiTypes.LIGHTNING_ROD), var0 -> var0.getY() == this.getHeight(HeightMap.Type.WORLD_SURFACE, var0.getX(), var0.getZ()) - 1, var02, 128, VillagePlace.Occupancy.ANY);
        return var1.map(var0 -> var0.above(1));
    }

    protected BlockPosition findLightningTargetAround(BlockPosition var02) {
        BlockPosition var1 = this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, var02);
        Optional<BlockPosition> var2 = this.findLightningRod(var1);
        if (var2.isPresent()) {
            return var2.get();
        }
        AxisAlignedBB var3 = AxisAlignedBB.encapsulatingFullBlocks(var1, new BlockPosition(var1.atY(this.getMaxBuildHeight()))).inflate(3.0);
        List<EntityLiving> var4 = this.getEntitiesOfClass(EntityLiving.class, var3, var0 -> var0 != null && var0.isAlive() && this.canSeeSky(var0.blockPosition()));
        if (!var4.isEmpty()) {
            return var4.get(this.random.nextInt(var4.size())).blockPosition();
        }
        if (var1.getY() == this.getMinBuildHeight() - 1) {
            var1 = var1.above(2);
        }
        return var1;
    }

    public boolean isHandlingTick() {
        return this.handlingTick;
    }

    public boolean canSleepThroughNights() {
        return this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE) <= 100;
    }

    private void announceSleepStatus() {
        if (!this.canSleepThroughNights()) {
            return;
        }
        if (this.getServer().isSingleplayer() && !this.getServer().isPublished()) {
            return;
        }
        int var0 = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE);
        IChatMutableComponent var1 = this.sleepStatus.areEnoughSleeping(var0) ? IChatBaseComponent.translatable("sleep.skipping_night") : IChatBaseComponent.translatable("sleep.players_sleeping", this.sleepStatus.amountSleeping(), this.sleepStatus.sleepersNeeded(var0));
        for (EntityPlayer var3 : this.players) {
            var3.displayClientMessage(var1, true);
        }
    }

    public void updateSleepingPlayerList() {
        if (!this.players.isEmpty() && this.sleepStatus.update(this.players)) {
            this.announceSleepStatus();
        }
    }

    @Override
    public ScoreboardServer getScoreboard() {
        return this.server.getScoreboard();
    }

    private void advanceWeatherCycle() {
        boolean var0 = this.isRaining();
        if (this.dimensionType().hasSkyLight()) {
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) {
                int var1 = this.serverLevelData.getClearWeatherTime();
                int var2 = this.serverLevelData.getThunderTime();
                int var3 = this.serverLevelData.getRainTime();
                boolean var4 = this.levelData.isThundering();
                boolean var5 = this.levelData.isRaining();
                if (var1 > 0) {
                    --var1;
                    var2 = var4 ? 0 : 1;
                    var3 = var5 ? 0 : 1;
                    var4 = false;
                    var5 = false;
                } else {
                    if (var2 > 0) {
                        if (--var2 == 0) {
                            var4 = !var4;
                        }
                    } else {
                        var2 = var4 ? THUNDER_DURATION.sample(this.random) : THUNDER_DELAY.sample(this.random);
                    }
                    if (var3 > 0) {
                        if (--var3 == 0) {
                            var5 = !var5;
                        }
                    } else {
                        var3 = var5 ? RAIN_DURATION.sample(this.random) : RAIN_DELAY.sample(this.random);
                    }
                }
                this.serverLevelData.setThunderTime(var2);
                this.serverLevelData.setRainTime(var3);
                this.serverLevelData.setClearWeatherTime(var1);
                this.serverLevelData.setThundering(var4);
                this.serverLevelData.setRaining(var5);
            }
            this.oThunderLevel = this.thunderLevel;
            this.thunderLevel = this.levelData.isThundering() ? (this.thunderLevel += 0.01f) : (this.thunderLevel -= 0.01f);
            this.thunderLevel = MathHelper.clamp(this.thunderLevel, 0.0f, 1.0f);
            this.oRainLevel = this.rainLevel;
            this.rainLevel = this.levelData.isRaining() ? (this.rainLevel += 0.01f) : (this.rainLevel -= 0.01f);
            this.rainLevel = MathHelper.clamp(this.rainLevel, 0.0f, 1.0f);
        }
        if (this.oRainLevel != this.rainLevel) {
            this.server.getPlayerList().broadcastAll(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.RAIN_LEVEL_CHANGE, this.rainLevel), this.dimension());
        }
        if (this.oThunderLevel != this.thunderLevel) {
            this.server.getPlayerList().broadcastAll(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.THUNDER_LEVEL_CHANGE, this.thunderLevel), this.dimension());
        }
        if (var0 != this.isRaining()) {
            if (var0) {
                this.server.getPlayerList().broadcastAll(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.STOP_RAINING, 0.0f));
            } else {
                this.server.getPlayerList().broadcastAll(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.START_RAINING, 0.0f));
            }
            this.server.getPlayerList().broadcastAll(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.RAIN_LEVEL_CHANGE, this.rainLevel));
            this.server.getPlayerList().broadcastAll(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.THUNDER_LEVEL_CHANGE, this.thunderLevel));
        }
    }

    @VisibleForTesting
    public void resetWeatherCycle() {
        this.serverLevelData.setRainTime(0);
        this.serverLevelData.setRaining(false);
        this.serverLevelData.setThunderTime(0);
        this.serverLevelData.setThundering(false);
    }

    public void resetEmptyTime() {
        this.emptyTime = 0;
    }

    private void tickFluid(BlockPosition var0, FluidType var1) {
        Fluid var2 = this.getFluidState(var0);
        if (var2.is(var1)) {
            var2.tick(this, var0);
        }
    }

    private void tickBlock(BlockPosition var0, Block var1) {
        IBlockData var2 = this.getBlockState(var0);
        if (var2.is(var1)) {
            var2.tick(this, var0, this.random);
        }
    }

    public void tickNonPassenger(Entity var0) {
        var0.setOldPosAndRot();
        GameProfilerFiller var1 = this.getProfiler();
        ++var0.tickCount;
        this.getProfiler().push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(var0.getType()).toString());
        var1.incrementCounter("tickNonPassenger");
        var0.tick();
        this.getProfiler().pop();
        for (Entity var3 : var0.getPassengers()) {
            this.tickPassenger(var0, var3);
        }
    }

    private void tickPassenger(Entity var0, Entity var1) {
        if (var1.isRemoved() || var1.getVehicle() != var0) {
            var1.stopRiding();
            return;
        }
        if (!(var1 instanceof EntityHuman) && !this.entityTickList.contains(var1)) {
            return;
        }
        var1.setOldPosAndRot();
        ++var1.tickCount;
        GameProfilerFiller var2 = this.getProfiler();
        var2.push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(var1.getType()).toString());
        var2.incrementCounter("tickPassenger");
        var1.rideTick();
        var2.pop();
        for (Entity var4 : var1.getPassengers()) {
            this.tickPassenger(var1, var4);
        }
    }

    @Override
    public boolean mayInteract(EntityHuman var0, BlockPosition var1) {
        return !this.server.isUnderSpawnProtection(this, var1, var0) && this.getWorldBorder().isWithinBounds(var1);
    }

    public void save(@Nullable IProgressUpdate var0, boolean var1, boolean var2) {
        ChunkProviderServer var3 = this.getChunkSource();
        if (var2) {
            return;
        }
        if (var0 != null) {
            var0.progressStartNoAbort(IChatBaseComponent.translatable("menu.savingLevel"));
        }
        this.saveLevelData();
        if (var0 != null) {
            var0.progressStage(IChatBaseComponent.translatable("menu.savingChunks"));
        }
        var3.save(var1);
        if (var1) {
            this.entityManager.saveAll();
        } else {
            this.entityManager.autoSave();
        }
    }

    private void saveLevelData() {
        if (this.dragonFight != null) {
            this.server.getWorldData().setEndDragonFightData(this.dragonFight.saveData());
        }
        this.getChunkSource().getDataStorage().save();
    }

    public <T extends Entity> List<? extends T> getEntities(EntityTypeTest<Entity, T> var0, Predicate<? super T> var1) {
        ArrayList var2 = Lists.newArrayList();
        this.getEntities(var0, var1, var2);
        return var2;
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> var0, Predicate<? super T> var1, List<? super T> var2) {
        this.getEntities(var0, var1, var2, Integer.MAX_VALUE);
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> var0, Predicate<? super T> var1, List<? super T> var2, int var32) {
        this.getEntities().get(var0, var3 -> {
            if (var1.test(var3)) {
                var2.add((Object)var3);
                if (var2.size() >= var32) {
                    return AbortableIterationConsumer.a.ABORT;
                }
            }
            return AbortableIterationConsumer.a.CONTINUE;
        });
    }

    public List<? extends EntityEnderDragon> getDragons() {
        return this.getEntities(EntityTypes.ENDER_DRAGON, EntityLiving::isAlive);
    }

    public List<EntityPlayer> getPlayers(Predicate<? super EntityPlayer> var0) {
        return this.getPlayers(var0, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> getPlayers(Predicate<? super EntityPlayer> var0, int var1) {
        ArrayList var2 = Lists.newArrayList();
        for (EntityPlayer var4 : this.players) {
            if (!var0.test(var4)) continue;
            var2.add(var4);
            if (var2.size() < var1) continue;
            return var2;
        }
        return var2;
    }

    @Nullable
    public EntityPlayer getRandomPlayer() {
        List<EntityPlayer> var0 = this.getPlayers(EntityLiving::isAlive);
        if (var0.isEmpty()) {
            return null;
        }
        return var0.get(this.random.nextInt(var0.size()));
    }

    @Override
    public boolean addFreshEntity(Entity var0) {
        return this.addEntity(var0);
    }

    public boolean addWithUUID(Entity var0) {
        return this.addEntity(var0);
    }

    public void addDuringTeleport(Entity var0) {
        this.addEntity(var0);
    }

    public void addDuringCommandTeleport(EntityPlayer var0) {
        this.addPlayer(var0);
    }

    public void addDuringPortalTeleport(EntityPlayer var0) {
        this.addPlayer(var0);
    }

    public void addNewPlayer(EntityPlayer var0) {
        this.addPlayer(var0);
    }

    public void addRespawnedPlayer(EntityPlayer var0) {
        this.addPlayer(var0);
    }

    private void addPlayer(EntityPlayer var0) {
        Entity var1 = this.getEntities().get(var0.getUUID());
        if (var1 != null) {
            LOGGER.warn("Force-added player with duplicate UUID {}", (Object)var0.getUUID());
            var1.unRide();
            this.removePlayerImmediately((EntityPlayer)var1, Entity.RemovalReason.DISCARDED);
        }
        this.entityManager.addNewEntity(var0);
    }

    private boolean addEntity(Entity var0) {
        if (var0.isRemoved()) {
            LOGGER.warn("Tried to add entity {} but it was marked as removed already", (Object)EntityTypes.getKey(var0.getType()));
            return false;
        }
        return this.entityManager.addNewEntity(var0);
    }

    public boolean tryAddFreshEntityWithPassengers(Entity var0) {
        if (var0.getSelfAndPassengers().map(Entity::getUUID).anyMatch(this.entityManager::isLoaded)) {
            return false;
        }
        this.addFreshEntityWithPassengers(var0);
        return true;
    }

    public void unload(Chunk var0) {
        var0.clearAllBlockEntities();
        var0.unregisterTickContainerFromLevel(this);
    }

    public void removePlayerImmediately(EntityPlayer var0, Entity.RemovalReason var1) {
        var0.remove(var1);
    }

    @Override
    public void destroyBlockProgress(int var0, BlockPosition var1, int var2) {
        for (EntityPlayer var4 : this.server.getPlayerList().getPlayers()) {
            double var9;
            double var7;
            double var5;
            if (var4 == null || var4.level() != this || var4.getId() == var0 || !((var5 = (double)var1.getX() - var4.getX()) * var5 + (var7 = (double)var1.getY() - var4.getY()) * var7 + (var9 = (double)var1.getZ() - var4.getZ()) * var9 < 1024.0)) continue;
            var4.connection.send(new PacketPlayOutBlockBreakAnimation(var0, var1, var2));
        }
    }

    @Override
    public void playSeededSound(@Nullable EntityHuman var0, double var1, double var3, double var5, Holder<SoundEffect> var7, SoundCategory var8, float var9, float var10, long var11) {
        this.server.getPlayerList().broadcast(var0, var1, var3, var5, var7.value().getRange(var9), this.dimension(), new PacketPlayOutNamedSoundEffect(var7, var8, var1, var3, var5, var9, var10, var11));
    }

    @Override
    public void playSeededSound(@Nullable EntityHuman var0, Entity var1, Holder<SoundEffect> var2, SoundCategory var3, float var4, float var5, long var6) {
        this.server.getPlayerList().broadcast(var0, var1.getX(), var1.getY(), var1.getZ(), var2.value().getRange(var4), this.dimension(), new PacketPlayOutEntitySound(var2, var3, var1, var4, var5, var6));
    }

    @Override
    public void globalLevelEvent(int var0, BlockPosition var1, int var2) {
        if (this.getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS)) {
            this.server.getPlayerList().broadcastAll(new PacketPlayOutWorldEvent(var0, var1, var2, true));
        } else {
            this.levelEvent(null, var0, var1, var2);
        }
    }

    @Override
    public void levelEvent(@Nullable EntityHuman var0, int var1, BlockPosition var2, int var3) {
        this.server.getPlayerList().broadcast(var0, var2.getX(), var2.getY(), var2.getZ(), 64.0, this.dimension(), new PacketPlayOutWorldEvent(var1, var2, var3, false));
    }

    public int getLogicalHeight() {
        return this.dimensionType().logicalHeight();
    }

    @Override
    public void gameEvent(Holder<GameEvent> var0, Vec3D var1, GameEvent.a var2) {
        this.gameEventDispatcher.post(var0, var1, var2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBlockUpdated(BlockPosition var0, IBlockData var1, IBlockData var2, int var3) {
        Object var4;
        if (this.isUpdatingNavigations) {
            var4 = "recursive call to sendBlockUpdated";
            SystemUtils.logAndPauseIfInIde("recursive call to sendBlockUpdated", new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.getChunkSource().blockChanged(var0);
        this.pathTypesByPosCache.invalidate(var0);
        var4 = var1.getCollisionShape(this, var0);
        VoxelShape var5 = var2.getCollisionShape(this, var0);
        if (!VoxelShapes.joinIsNotEmpty((VoxelShape)var4, var5, OperatorBoolean.NOT_SAME)) {
            return;
        }
        ObjectArrayList var6 = new ObjectArrayList();
        for (EntityInsentient entityInsentient : this.navigatingMobs) {
            NavigationAbstract var9 = entityInsentient.getNavigation();
            if (!var9.shouldRecomputePath(var0)) continue;
            var6.add(var9);
        }
        try {
            this.isUpdatingNavigations = true;
            for (NavigationAbstract navigationAbstract : var6) {
                navigationAbstract.recomputePath();
            }
        }
        finally {
            this.isUpdatingNavigations = false;
        }
    }

    @Override
    public void updateNeighborsAt(BlockPosition var0, Block var1) {
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(var0, var1, null);
    }

    @Override
    public void updateNeighborsAtExceptFromFacing(BlockPosition var0, Block var1, EnumDirection var2) {
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(var0, var1, var2);
    }

    @Override
    public void neighborChanged(BlockPosition var0, Block var1, BlockPosition var2) {
        this.neighborUpdater.neighborChanged(var0, var1, var2);
    }

    @Override
    public void neighborChanged(IBlockData var0, BlockPosition var1, Block var2, BlockPosition var3, boolean var4) {
        this.neighborUpdater.neighborChanged(var0, var1, var2, var3, var4);
    }

    @Override
    public void broadcastEntityEvent(Entity var0, byte var1) {
        this.getChunkSource().broadcastAndSend(var0, new PacketPlayOutEntityStatus(var0, var1));
    }

    @Override
    public void broadcastDamageEvent(Entity var0, DamageSource var1) {
        this.getChunkSource().broadcastAndSend(var0, new ClientboundDamageEventPacket(var0, var1));
    }

    @Override
    public ChunkProviderServer getChunkSource() {
        return this.chunkSource;
    }

    @Override
    public Explosion explode(@Nullable Entity var0, @Nullable DamageSource var1, @Nullable ExplosionDamageCalculator var2, double var3, double var5, double var7, float var9, boolean var10, World.a var11, ParticleParam var12, ParticleParam var13, Holder<SoundEffect> var14) {
        Explosion var15 = this.explode(var0, var1, var2, var3, var5, var7, var9, var10, var11, false, var12, var13, var14);
        if (!var15.interactsWithBlocks()) {
            var15.clearToBlow();
        }
        for (EntityPlayer var17 : this.players) {
            if (!(var17.distanceToSqr(var3, var5, var7) < 4096.0)) continue;
            var17.connection.send(new PacketPlayOutExplosion(var3, var5, var7, var9, var15.getToBlow(), var15.getHitPlayers().get(var17), var15.getBlockInteraction(), var15.getSmallExplosionParticles(), var15.getLargeExplosionParticles(), var15.getExplosionSound()));
        }
        return var15;
    }

    @Override
    public void blockEvent(BlockPosition var0, Block var1, int var2, int var3) {
        this.blockEvents.add((Object)new BlockActionData(var0, var1, var2, var3));
    }

    private void runBlockEvents() {
        this.blockEventsToReschedule.clear();
        while (!this.blockEvents.isEmpty()) {
            BlockActionData var0 = (BlockActionData)this.blockEvents.removeFirst();
            if (this.shouldTickBlocksAt(var0.pos())) {
                if (!this.doBlockEvent(var0)) continue;
                this.server.getPlayerList().broadcast(null, var0.pos().getX(), var0.pos().getY(), var0.pos().getZ(), 64.0, this.dimension(), new PacketPlayOutBlockAction(var0.pos(), var0.block(), var0.paramA(), var0.paramB()));
                continue;
            }
            this.blockEventsToReschedule.add(var0);
        }
        this.blockEvents.addAll(this.blockEventsToReschedule);
    }

    private boolean doBlockEvent(BlockActionData var0) {
        IBlockData var1 = this.getBlockState(var0.pos());
        if (var1.is(var0.block())) {
            return var1.triggerEvent(this, var0.pos(), var0.paramA(), var0.paramB());
        }
        return false;
    }

    public TickListServer<Block> getBlockTicks() {
        return this.blockTicks;
    }

    public TickListServer<FluidType> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    @Nonnull
    public MinecraftServer getServer() {
        return this.server;
    }

    public PortalTravelAgent getPortalForcer() {
        return this.portalForcer;
    }

    public StructureTemplateManager getStructureManager() {
        return this.server.getStructureManager();
    }

    public <T extends ParticleParam> int sendParticles(T var0, double var1, double var3, double var5, int var7, double var8, double var10, double var12, double var14) {
        PacketPlayOutWorldParticles var16 = new PacketPlayOutWorldParticles(var0, false, var1, var3, var5, (float)var8, (float)var10, (float)var12, (float)var14, var7);
        int var17 = 0;
        for (int var18 = 0; var18 < this.players.size(); ++var18) {
            EntityPlayer var19 = this.players.get(var18);
            if (!this.sendParticles(var19, false, var1, var3, var5, var16)) continue;
            ++var17;
        }
        return var17;
    }

    public <T extends ParticleParam> boolean sendParticles(EntityPlayer var0, T var1, boolean var2, double var3, double var5, double var7, int var9, double var10, double var12, double var14, double var16) {
        PacketPlayOutWorldParticles var18 = new PacketPlayOutWorldParticles(var1, var2, var3, var5, var7, (float)var10, (float)var12, (float)var14, (float)var16, var9);
        return this.sendParticles(var0, var2, var3, var5, var7, var18);
    }

    private boolean sendParticles(EntityPlayer var0, boolean var1, double var2, double var4, double var6, Packet<?> var8) {
        if (var0.level() != this) {
            return false;
        }
        BlockPosition var9 = var0.blockPosition();
        if (var9.closerToCenterThan(new Vec3D(var2, var4, var6), var1 ? 512.0 : 32.0)) {
            var0.connection.send(var8);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity getEntity(int var0) {
        return this.getEntities().get(var0);
    }

    @Deprecated
    @Nullable
    public Entity getEntityOrPart(int var0) {
        Entity var1 = this.getEntities().get(var0);
        if (var1 != null) {
            return var1;
        }
        return (Entity)this.dragonParts.get(var0);
    }

    @Nullable
    public Entity getEntity(UUID var0) {
        return this.getEntities().get(var0);
    }

    @Nullable
    public BlockPosition findNearestMapStructure(TagKey<Structure> var0, BlockPosition var1, int var2, boolean var3) {
        if (!this.server.getWorldData().worldGenOptions().generateStructures()) {
            return null;
        }
        Optional<HolderSet.Named<Structure>> var4 = this.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(var0);
        if (var4.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> var5 = this.getChunkSource().getGenerator().findNearestMapStructure(this, (HolderSet<Structure>)var4.get(), var1, var2, var3);
        return var5 != null ? (BlockPosition)var5.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> findClosestBiome3d(Predicate<Holder<BiomeBase>> var0, BlockPosition var1, int var2, int var3, int var4) {
        return this.getChunkSource().getGenerator().getBiomeSource().findClosestBiome3d(var1, var2, var3, var4, var0, this.getChunkSource().randomState().sampler(), this);
    }

    @Override
    public CraftingManager getRecipeManager() {
        return this.server.getRecipeManager();
    }

    @Override
    public TickRateManager tickRateManager() {
        return this.server.tickRateManager();
    }

    @Override
    public boolean noSave() {
        return this.noSave;
    }

    public WorldPersistentData getDataStorage() {
        return this.getChunkSource().getDataStorage();
    }

    @Override
    @Nullable
    public WorldMap getMapData(MapId var0) {
        return this.getServer().overworld().getDataStorage().get(WorldMap.factory(), var0.key());
    }

    @Override
    public void setMapData(MapId var0, WorldMap var1) {
        this.getServer().overworld().getDataStorage().set(var0.key(), var1);
    }

    @Override
    public MapId getFreeMapId() {
        return this.getServer().overworld().getDataStorage().computeIfAbsent(PersistentIdCounts.factory(), "idcounts").getFreeAuxValueForMap();
    }

    public void setDefaultSpawnPos(BlockPosition var0, float var1) {
        int var4;
        BlockPosition var2 = this.levelData.getSpawnPos();
        float var3 = this.levelData.getSpawnAngle();
        if (!var2.equals(var0) || var3 != var1) {
            this.levelData.setSpawn(var0, var1);
            this.getServer().getPlayerList().broadcastAll(new PacketPlayOutSpawnPosition(var0, var1));
        }
        if (this.lastSpawnChunkRadius > 1) {
            this.getChunkSource().removeRegionTicket(TicketType.START, new ChunkCoordIntPair(var2), this.lastSpawnChunkRadius, Unit.INSTANCE);
        }
        if ((var4 = this.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS) + 1) > 1) {
            this.getChunkSource().addRegionTicket(TicketType.START, new ChunkCoordIntPair(var0), var4, Unit.INSTANCE);
        }
        this.lastSpawnChunkRadius = var4;
    }

    public LongSet getForcedChunks() {
        ForcedChunk var0 = this.getDataStorage().get(ForcedChunk.factory(), "chunks");
        return var0 != null ? LongSets.unmodifiable((LongSet)var0.getChunks()) : LongSets.EMPTY_SET;
    }

    public boolean setChunkForced(int var0, int var1, boolean var2) {
        boolean var7;
        ForcedChunk var3 = this.getDataStorage().computeIfAbsent(ForcedChunk.factory(), "chunks");
        ChunkCoordIntPair var4 = new ChunkCoordIntPair(var0, var1);
        long var5 = var4.toLong();
        if (var2) {
            var7 = var3.getChunks().add(var5);
            if (var7) {
                this.getChunk(var0, var1);
            }
        } else {
            var7 = var3.getChunks().remove(var5);
        }
        var3.setDirty(var7);
        if (var7) {
            this.getChunkSource().updateChunkForced(var4, var2);
        }
        return var7;
    }

    public List<EntityPlayer> players() {
        return this.players;
    }

    @Override
    public void onBlockStateChange(BlockPosition var0, IBlockData var12, IBlockData var2) {
        Optional<Holder<VillagePlaceType>> var4;
        Optional<Holder<VillagePlaceType>> var3 = PoiTypes.forState(var12);
        if (Objects.equals(var3, var4 = PoiTypes.forState(var2))) {
            return;
        }
        BlockPosition var5 = var0.immutable();
        var3.ifPresent(var1 -> this.getServer().execute(() -> {
            this.getPoiManager().remove(var5);
            PacketDebug.sendPoiRemovedPacket(this, var5);
        }));
        var4.ifPresent(var1 -> this.getServer().execute(() -> {
            this.getPoiManager().add(var5, (Holder<VillagePlaceType>)var1);
            PacketDebug.sendPoiAddedPacket(this, var5);
        }));
    }

    public VillagePlace getPoiManager() {
        return this.getChunkSource().getPoiManager();
    }

    public boolean isVillage(BlockPosition var0) {
        return this.isCloseToVillage(var0, 1);
    }

    public boolean isVillage(SectionPosition var0) {
        return this.isVillage(var0.center());
    }

    public boolean isCloseToVillage(BlockPosition var0, int var1) {
        if (var1 > 6) {
            return false;
        }
        return this.sectionsToVillage(SectionPosition.of(var0)) <= var1;
    }

    public int sectionsToVillage(SectionPosition var0) {
        return this.getPoiManager().sectionsToVillage(var0);
    }

    public PersistentRaid getRaids() {
        return this.raids;
    }

    @Nullable
    public Raid getRaidAt(BlockPosition var0) {
        return this.raids.getNearbyRaid(var0, 9216);
    }

    public boolean isRaided(BlockPosition var0) {
        return this.getRaidAt(var0) != null;
    }

    public void onReputationEvent(ReputationEvent var0, Entity var1, ReputationHandler var2) {
        var2.onReputationEventFrom(var0, var1);
    }

    public void saveDebugReport(Path var0) throws IOException {
        Object var52;
        Object var3;
        PlayerChunkMap var1 = this.getChunkSource().chunkMap;
        try (Object var2 = Files.newBufferedWriter(var0.resolve("stats.txt"), new OpenOption[0]);){
            ((Writer)var2).write(String.format(Locale.ROOT, "spawning_chunks: %d\n", var1.getDistanceManager().getNaturalSpawnChunkCount()));
            var3 = this.getChunkSource().getLastSpawnState();
            if (var3 != null) {
                for (Object var52 : ((SpawnerCreature.d)var3).getMobCategoryCounts().object2IntEntrySet()) {
                    ((Writer)var2).write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)var52.getKey()).getName(), var52.getIntValue()));
                }
            }
            ((Writer)var2).write(String.format(Locale.ROOT, "entities: %s\n", this.entityManager.gatherStats()));
            ((Writer)var2).write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.blockEntityTickers.size()));
            ((Writer)var2).write(String.format(Locale.ROOT, "block_ticks: %d\n", ((TickListServer)this.getBlockTicks()).count()));
            ((Writer)var2).write(String.format(Locale.ROOT, "fluid_ticks: %d\n", ((TickListServer)this.getFluidTicks()).count()));
            ((Writer)var2).write("distance_manager: " + var1.getDistanceManager().getDebugStatus() + "\n");
            ((Writer)var2).write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.getChunkSource().getPendingTasksCount()));
        }
        var2 = new CrashReport("Level dump", new Exception("dummy"));
        this.fillReportDetails((CrashReport)var2);
        var3 = Files.newBufferedWriter(var0.resolve("example_crash.txt"), new OpenOption[0]);
        try {
            ((Writer)var3).write(((CrashReport)var2).getFriendlyReport());
        }
        finally {
            if (var3 != null) {
                ((Writer)var3).close();
            }
        }
        var3 = var0.resolve("chunks.csv");
        try (Object var4 = Files.newBufferedWriter((Path)var3, new OpenOption[0]);){
            var1.dumpChunks((Writer)var4);
        }
        var4 = var0.resolve("entity_chunks.csv");
        var52 = Files.newBufferedWriter((Path)var4, new OpenOption[0]);
        try {
            this.entityManager.dumpSections((Writer)var52);
        }
        finally {
            if (var52 != null) {
                ((Writer)var52).close();
            }
        }
        var52 = var0.resolve("entities.csv");
        try (Object var6 = Files.newBufferedWriter((Path)var52, new OpenOption[0]);){
            WorldServer.dumpEntities((Writer)var6, this.getEntities().getAll());
        }
        var6 = var0.resolve("block_entities.csv");
        try (BufferedWriter var7 = Files.newBufferedWriter((Path)var6, new OpenOption[0]);){
            this.dumpBlockEntityTickers(var7);
        }
    }

    private static void dumpEntities(Writer var0, Iterable<Entity> var1) throws IOException {
        CSVWriter var2 = CSVWriter.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("uuid").addColumn("type").addColumn("alive").addColumn("display_name").addColumn("custom_name").build(var0);
        for (Entity var4 : var1) {
            IChatBaseComponent var5 = var4.getCustomName();
            IChatBaseComponent var6 = var4.getDisplayName();
            var2.writeRow(var4.getX(), var4.getY(), var4.getZ(), var4.getUUID(), BuiltInRegistries.ENTITY_TYPE.getKey(var4.getType()), var4.isAlive(), var6.getString(), var5 != null ? var5.getString() : null);
        }
    }

    private void dumpBlockEntityTickers(Writer var0) throws IOException {
        CSVWriter var1 = CSVWriter.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("type").build(var0);
        for (TickingBlockEntity var3 : this.blockEntityTickers) {
            BlockPosition var4 = var3.getPos();
            var1.writeRow(var4.getX(), var4.getY(), var4.getZ(), var3.getType());
        }
    }

    @VisibleForTesting
    public void clearBlockEvents(StructureBoundingBox var0) {
        this.blockEvents.removeIf(var1 -> var0.isInside(var1.pos()));
    }

    @Override
    public void blockUpdated(BlockPosition var0, Block var1) {
        if (!this.isDebug()) {
            this.updateNeighborsAt(var0, var1);
        }
    }

    @Override
    public float getShade(EnumDirection var0, boolean var1) {
        return 1.0f;
    }

    public Iterable<Entity> getAllEntities() {
        return this.getEntities().getAll();
    }

    public String toString() {
        return "ServerLevel[" + this.serverLevelData.getLevelName() + "]";
    }

    public boolean isFlat() {
        return this.server.getWorldData().isFlatWorld();
    }

    @Override
    public long getSeed() {
        return this.server.getWorldData().worldGenOptions().seed();
    }

    @Nullable
    public EnderDragonBattle getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public WorldServer getLevel() {
        return this;
    }

    @VisibleForTesting
    public String getWatchdogStats() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.players.size(), this.entityManager.gatherStats(), WorldServer.getTypeCount(this.entityManager.getEntityGetter().getAll(), var0 -> BuiltInRegistries.ENTITY_TYPE.getKey(var0.getType()).toString()), this.blockEntityTickers.size(), WorldServer.getTypeCount(this.blockEntityTickers, TickingBlockEntity::getType), ((TickListServer)this.getBlockTicks()).count(), ((TickListServer)this.getFluidTicks()).count(), this.gatherChunkSourceStats());
    }

    private static <T> String getTypeCount(Iterable<T> var02, Function<T, String> var1) {
        try {
            Object2IntOpenHashMap var2 = new Object2IntOpenHashMap();
            for (T var4 : var02) {
                String var5 = var1.apply(var4);
                var2.addTo((Object)var5, 1);
            }
            return var2.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(var0 -> (String)var0.getKey() + ":" + var0.getIntValue()).collect(Collectors.joining(","));
        }
        catch (Exception var2) {
            return "";
        }
    }

    public static void makeObsidianPlatform(WorldServer var0) {
        BlockPosition var12 = END_SPAWN_POINT;
        int var2 = var12.getX();
        int var3 = var12.getY() - 2;
        int var4 = var12.getZ();
        BlockPosition.betweenClosed(var2 - 2, var3 + 1, var4 - 2, var2 + 2, var3 + 3, var4 + 2).forEach(var1 -> var0.setBlockAndUpdate((BlockPosition)var1, Blocks.AIR.defaultBlockState()));
        BlockPosition.betweenClosed(var2 - 2, var3, var4 - 2, var2 + 2, var3, var4 + 2).forEach(var1 -> var0.setBlockAndUpdate((BlockPosition)var1, Blocks.OBSIDIAN.defaultBlockState()));
    }

    @Override
    public LevelEntityGetter<Entity> getEntities() {
        return this.entityManager.getEntityGetter();
    }

    public void addLegacyChunkEntities(Stream<Entity> var0) {
        this.entityManager.addLegacyChunkEntities(var0);
    }

    public void addWorldGenChunkEntities(Stream<Entity> var0) {
        this.entityManager.addWorldGenChunkEntities(var0);
    }

    public void startTickingChunk(Chunk var0) {
        var0.unpackTicks(this.getLevelData().getGameTime());
    }

    public void onStructureStartsAvailable(IChunkAccess var0) {
        this.server.execute(() -> this.structureCheck.onStructureLoad(var0.getPos(), var0.getAllStarts()));
    }

    public PathTypeCache getPathTypeCache() {
        return this.pathTypesByPosCache;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.entityManager.close();
    }

    @Override
    public String gatherChunkSourceStats() {
        return "Chunks[S] W: " + this.chunkSource.gatherStats() + " E: " + this.entityManager.gatherStats();
    }

    public boolean areEntitiesLoaded(long var0) {
        return this.entityManager.areEntitiesLoaded(var0);
    }

    private boolean isPositionTickingWithEntitiesLoaded(long var0) {
        return this.areEntitiesLoaded(var0) && this.chunkSource.isPositionTicking(var0);
    }

    public boolean isPositionEntityTicking(BlockPosition var0) {
        return this.entityManager.canPositionTick(var0) && this.chunkSource.chunkMap.getDistanceManager().inEntityTickingRange(ChunkCoordIntPair.asLong(var0));
    }

    public boolean isNaturalSpawningAllowed(BlockPosition var0) {
        return this.entityManager.canPositionTick(var0);
    }

    public boolean isNaturalSpawningAllowed(ChunkCoordIntPair var0) {
        return this.entityManager.canPositionTick(var0);
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.server.getWorldData().enabledFeatures();
    }

    @Override
    public PotionBrewer potionBrewing() {
        return this.server.potionBrewing();
    }

    public RandomSource getRandomSequence(MinecraftKey var0) {
        return this.randomSequences.get(var0);
    }

    public RandomSequences getRandomSequences() {
        return this.randomSequences;
    }

    @Override
    public CrashReportSystemDetails fillReportDetails(CrashReport var0) {
        CrashReportSystemDetails var1 = super.fillReportDetails(var0);
        var1.setDetail("Loaded entity count", () -> String.valueOf(this.entityManager.count()));
        return var1;
    }

    @Override
    public /* synthetic */ Scoreboard getScoreboard() {
        return this.getScoreboard();
    }

    @Override
    public /* synthetic */ IChunkProvider getChunkSource() {
        return this.getChunkSource();
    }

    public /* synthetic */ LevelTickAccess getFluidTicks() {
        return this.getFluidTicks();
    }

    public /* synthetic */ LevelTickAccess getBlockTicks() {
        return this.getBlockTicks();
    }

    final class a
    implements LevelCallback<Entity> {
        a() {
        }

        @Override
        public void onCreated(Entity var0) {
        }

        @Override
        public void onDestroyed(Entity var0) {
            WorldServer.this.getScoreboard().entityRemoved(var0);
        }

        @Override
        public void onTickingStart(Entity var0) {
            WorldServer.this.entityTickList.add(var0);
        }

        @Override
        public void onTickingEnd(Entity var0) {
            WorldServer.this.entityTickList.remove(var0);
        }

        @Override
        public void onTrackingStart(Entity var0) {
            EntityLiving var1;
            WorldServer.this.getChunkSource().addEntity(var0);
            if (var0 instanceof EntityPlayer) {
                var1 = (EntityPlayer)var0;
                WorldServer.this.players.add((EntityPlayer)var1);
                WorldServer.this.updateSleepingPlayerList();
            }
            if (var0 instanceof EntityInsentient) {
                var1 = (EntityInsentient)var0;
                if (WorldServer.this.isUpdatingNavigations) {
                    String var2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.logAndPauseIfInIde("onTrackingStart called during navigation iteration", new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.navigatingMobs.add((EntityInsentient)var1);
            }
            if (var0 instanceof EntityEnderDragon) {
                var1 = (EntityEnderDragon)var0;
                for (EntityComplexPart var5 : ((EntityEnderDragon)var1).getSubEntities()) {
                    WorldServer.this.dragonParts.put(var5.getId(), (Object)var5);
                }
            }
            var0.updateDynamicGameEventListener(DynamicGameEventListener::add);
        }

        @Override
        public void onTrackingEnd(Entity var0) {
            EntityLiving var1;
            WorldServer.this.getChunkSource().removeEntity(var0);
            if (var0 instanceof EntityPlayer) {
                var1 = (EntityPlayer)var0;
                WorldServer.this.players.remove(var1);
                WorldServer.this.updateSleepingPlayerList();
            }
            if (var0 instanceof EntityInsentient) {
                var1 = (EntityInsentient)var0;
                if (WorldServer.this.isUpdatingNavigations) {
                    String var2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.logAndPauseIfInIde("onTrackingStart called during navigation iteration", new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.navigatingMobs.remove(var1);
            }
            if (var0 instanceof EntityEnderDragon) {
                var1 = (EntityEnderDragon)var0;
                for (EntityComplexPart var5 : ((EntityEnderDragon)var1).getSubEntities()) {
                    WorldServer.this.dragonParts.remove(var5.getId());
                }
            }
            var0.updateDynamicGameEventListener(DynamicGameEventListener::remove);
        }

        @Override
        public void onSectionChange(Entity var0) {
            var0.updateDynamicGameEventListener(DynamicGameEventListener::move);
        }

        @Override
        public /* synthetic */ void onSectionChange(Object object) {
            this.onSectionChange((Entity)object);
        }

        @Override
        public /* synthetic */ void onTrackingEnd(Object object) {
            this.onTrackingEnd((Entity)object);
        }

        @Override
        public /* synthetic */ void onTrackingStart(Object object) {
            this.onTrackingStart((Entity)object);
        }

        @Override
        public /* synthetic */ void onTickingStart(Object object) {
            this.onTickingStart((Entity)object);
        }

        @Override
        public /* synthetic */ void onDestroyed(Object object) {
            this.onDestroyed((Entity)object);
        }

        @Override
        public /* synthetic */ void onCreated(Object object) {
            this.onCreated((Entity)object);
        }
    }
}

