/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Unit;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class ResetChunksCommand {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("resetchunks").requires(var0 -> var0.hasPermission(2))).executes(var0 -> ResetChunksCommand.resetChunks((CommandListenerWrapper)var0.getSource(), 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("range", IntegerArgumentType.integer((int)0, (int)5)).executes(var0 -> ResetChunksCommand.resetChunks((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"range"), true))).then(net.minecraft.commands.CommandDispatcher.argument("skipOldChunks", BoolArgumentType.bool()).executes(var0 -> ResetChunksCommand.resetChunks((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"range"), BoolArgumentType.getBool((CommandContext)var0, (String)"skipOldChunks"))))));
    }

    private static int resetChunks(CommandListenerWrapper var0, int var1, boolean var2) {
        Object var20;
        Object var19;
        WorldServer var3 = var0.getLevel();
        ChunkProviderServer var4 = var3.getChunkSource();
        var4.chunkMap.debugReloadGenerator();
        Vec3D var5 = var0.getPosition();
        ChunkCoordIntPair var6 = new ChunkCoordIntPair(BlockPosition.containing(var5));
        int var7 = var6.z - var1;
        int var8 = var6.z + var1;
        int var9 = var6.x - var1;
        int var10 = var6.x + var1;
        for (int var11 = var7; var11 <= var8; ++var11) {
            for (int var12 = var9; var12 <= var10; ++var12) {
                ChunkCoordIntPair var13 = new ChunkCoordIntPair(var12, var11);
                Chunk var14 = var4.getChunk(var12, var11, false);
                if (var14 == null || var2 && var14.isOldNoiseGeneration()) continue;
                for (BlockPosition blockPosition : BlockPosition.betweenClosed(var13.getMinBlockX(), var3.getMinBuildHeight(), var13.getMinBlockZ(), var13.getMaxBlockX(), var3.getMaxBuildHeight() - 1, var13.getMaxBlockZ())) {
                    var3.setBlock(blockPosition, Blocks.AIR.defaultBlockState(), 16);
                }
            }
        }
        ThreadedMailbox<Runnable> var11 = ThreadedMailbox.create(SystemUtils.backgroundExecutor(), "worldgen-resetchunks");
        long var12 = System.currentTimeMillis();
        int var14 = (var1 * 2 + 1) * (var1 * 2 + 1);
        for (ChunkStatus chunkStatus : ImmutableList.of((Object)ChunkStatus.BIOMES, (Object)ChunkStatus.NOISE, (Object)ChunkStatus.SURFACE, (Object)ChunkStatus.CARVERS, (Object)ChunkStatus.FEATURES, (Object)ChunkStatus.INITIALIZE_LIGHT)) {
            long var17 = System.currentTimeMillis();
            var19 = CompletableFuture.supplyAsync(() -> Unit.INSTANCE, var11::tell);
            var20 = new WorldGenContext(var3, var4.getGenerator(), var3.getStructureManager(), var4.getLightEngine());
            for (int var21 = var6.z - var1; var21 <= var6.z + var1; ++var21) {
                for (int var22 = var6.x - var1; var22 <= var6.x + var1; ++var22) {
                    ChunkCoordIntPair var23 = new ChunkCoordIntPair(var22, var21);
                    Chunk var24 = var4.getChunk(var22, var21, false);
                    if (var24 == null || var2 && var24.isOldNoiseGeneration()) continue;
                    ArrayList var25 = Lists.newArrayList();
                    int var26 = Math.max(1, chunkStatus.getRange());
                    for (int var27 = var23.z - var26; var27 <= var23.z + var26; ++var27) {
                        for (int var28 = var23.x - var26; var28 <= var23.x + var26; ++var28) {
                            IChunkAccess var29 = var4.getChunk(var28, var27, chunkStatus.getParent(), true);
                            IChunkAccess var30 = var29 instanceof ProtoChunkExtension ? new ProtoChunkExtension(((ProtoChunkExtension)var29).getWrapped(), true) : (var29 instanceof Chunk ? new ProtoChunkExtension((Chunk)var29, true) : var29);
                            var25.add(var30);
                        }
                    }
                    var19 = ((CompletableFuture)var19).thenComposeAsync(arg_0 -> ResetChunksCommand.a(chunkStatus, (WorldGenContext)var20, var11, var25, arg_0), var11::tell);
                }
            }
            var0.getServer().managedBlock(((CompletableFuture)var19)::isDone);
            LOGGER.debug(String.valueOf(chunkStatus) + " took " + (System.currentTimeMillis() - var17) + " ms");
        }
        long var15 = System.currentTimeMillis();
        for (int var17 = var6.z - var1; var17 <= var6.z + var1; ++var17) {
            for (int var18 = var6.x - var1; var18 <= var6.x + var1; ++var18) {
                var19 = new ChunkCoordIntPair(var18, var17);
                var20 = var4.getChunk(var18, var17, false);
                if (var20 == null || var2 && ((IChunkAccess)var20).isOldNoiseGeneration()) continue;
                for (BlockPosition var22 : BlockPosition.betweenClosed(((ChunkCoordIntPair)var19).getMinBlockX(), var3.getMinBuildHeight(), ((ChunkCoordIntPair)var19).getMinBlockZ(), ((ChunkCoordIntPair)var19).getMaxBlockX(), var3.getMaxBuildHeight() - 1, ((ChunkCoordIntPair)var19).getMaxBlockZ())) {
                    var4.blockChanged(var22);
                }
            }
        }
        LOGGER.debug("blockChanged took " + (System.currentTimeMillis() - var15) + " ms");
        long var17 = System.currentTimeMillis() - var12;
        var0.sendSuccess(() -> IChatBaseComponent.literal(String.format(Locale.ROOT, "%d chunks have been reset. This took %d ms for %d chunks, or %02f ms per chunk", var14, var17, var14, Float.valueOf((float)var17 / (float)var14))), true);
        return 1;
    }

    private static /* synthetic */ CompletionStage a(ChunkStatus var02, WorldGenContext var12, ThreadedMailbox var2, List var3, Unit var4) {
        return var02.generate(var12, var2::tell, var0 -> {
            throw new UnsupportedOperationException("Not creating full chunks here");
        }, var3).thenApply(var1 -> {
            if (var02 == ChunkStatus.NOISE) {
                HeightMap.primeHeightmaps(var1, ChunkStatus.POST_FEATURES);
            }
            return Unit.INSTANCE;
        });
    }
}

