/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.world.level.timers.CustomFunctionCallback;
import net.minecraft.world.level.timers.CustomFunctionCallbackTag;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;

public class CommandSchedule {
    private static final SimpleCommandExceptionType ERROR_SAME_TICK = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.schedule.same_tick"));
    private static final DynamicCommandExceptionType ERROR_CANT_REMOVE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.schedule.cleared.failure", var0));
    private static final SuggestionProvider<CommandListenerWrapper> SUGGEST_SCHEDULE = (var0, var1) -> ICompletionProvider.suggest(((CommandListenerWrapper)var0.getSource()).getServer().getWorldData().overworldData().getScheduledEvents().getEventsIds(), var1);

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("schedule").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("function").then(net.minecraft.commands.CommandDispatcher.argument("function", ArgumentTag.functions()).suggests(CommandFunction.SUGGEST_FUNCTION).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("time", ArgumentTime.time()).executes(var0 -> CommandSchedule.schedule((CommandListenerWrapper)var0.getSource(), ArgumentTag.getFunctionOrTag((CommandContext<CommandListenerWrapper>)var0, "function"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"time"), true))).then(net.minecraft.commands.CommandDispatcher.literal("append").executes(var0 -> CommandSchedule.schedule((CommandListenerWrapper)var0.getSource(), ArgumentTag.getFunctionOrTag((CommandContext<CommandListenerWrapper>)var0, "function"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"time"), false)))).then(net.minecraft.commands.CommandDispatcher.literal("replace").executes(var0 -> CommandSchedule.schedule((CommandListenerWrapper)var0.getSource(), ArgumentTag.getFunctionOrTag((CommandContext<CommandListenerWrapper>)var0, "function"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"time"), true))))))).then(net.minecraft.commands.CommandDispatcher.literal("clear").then(net.minecraft.commands.CommandDispatcher.argument("function", StringArgumentType.greedyString()).suggests(SUGGEST_SCHEDULE).executes(var0 -> CommandSchedule.remove((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"function"))))));
    }

    private static int schedule(CommandListenerWrapper var0, Pair<MinecraftKey, Either<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>, Collection<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>>>> var1, int var2, boolean var3) throws CommandSyntaxException {
        if (var2 == 0) {
            throw ERROR_SAME_TICK.create();
        }
        long var4 = var0.getLevel().getGameTime() + (long)var2;
        MinecraftKey var6 = (MinecraftKey)var1.getFirst();
        CustomFunctionCallbackTimerQueue<MinecraftServer> var72 = var0.getServer().getWorldData().overworldData().getScheduledEvents();
        ((Either)var1.getSecond()).ifLeft(var7 -> {
            String var8 = var6.toString();
            if (var3) {
                var72.remove(var8);
            }
            var72.schedule(var8, var4, new CustomFunctionCallback(var6));
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.schedule.created.function", IChatBaseComponent.translationArg(var6), var2, var4), true);
        }).ifRight(var7 -> {
            String var8 = "#" + String.valueOf(var6);
            if (var3) {
                var72.remove(var8);
            }
            var72.schedule(var8, var4, new CustomFunctionCallbackTag(var6));
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.schedule.created.tag", IChatBaseComponent.translationArg(var6), var2, var4), true);
        });
        return Math.floorMod(var4, Integer.MAX_VALUE);
    }

    private static int remove(CommandListenerWrapper var0, String var1) throws CommandSyntaxException {
        int var2 = var0.getServer().getWorldData().overworldData().getScheduledEvents().remove(var1);
        if (var2 == 0) {
            throw ERROR_CANT_REMOVE.create((Object)var1);
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.schedule.cleared.success", var2, var1), true);
        return var2;
    }
}

