/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;

public class CommandAdvancement {
    private static final DynamicCommandExceptionType ERROR_NO_ACTION_PERFORMED = new DynamicCommandExceptionType(var0 -> (IChatBaseComponent)var0);
    private static final Dynamic2CommandExceptionType ERROR_CRITERION_NOT_FOUND = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatable("commands.advancement.criterionNotFound", var0, var1));
    private static final SuggestionProvider<CommandListenerWrapper> SUGGEST_ADVANCEMENTS = (var0, var1) -> {
        Collection<AdvancementHolder> var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getAdvancements().getAllAdvancements();
        return ICompletionProvider.suggestResource(var2.stream().map(AdvancementHolder::id), var1);
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("advancement").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("grant").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(net.minecraft.commands.CommandDispatcher.literal("only").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, CommandAdvancement.getAdvancements((CommandContext<CommandListenerWrapper>)var0, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.ONLY)))).then(net.minecraft.commands.CommandDispatcher.argument("criterion", StringArgumentType.greedyString()).suggests((var0, var1) -> ICompletionProvider.suggest(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement").value().criteria().keySet(), var1)).executes(var0 -> CommandAdvancement.performCriterion((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), StringArgumentType.getString((CommandContext)var0, (String)"criterion"))))))).then(net.minecraft.commands.CommandDispatcher.literal("from").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, CommandAdvancement.getAdvancements((CommandContext<CommandListenerWrapper>)var0, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.FROM)))))).then(net.minecraft.commands.CommandDispatcher.literal("until").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, CommandAdvancement.getAdvancements((CommandContext<CommandListenerWrapper>)var0, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.UNTIL)))))).then(net.minecraft.commands.CommandDispatcher.literal("through").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, CommandAdvancement.getAdvancements((CommandContext<CommandListenerWrapper>)var0, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.THROUGH)))))).then(net.minecraft.commands.CommandDispatcher.literal("everything").executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, ((CommandListenerWrapper)var0.getSource()).getServer().getAdvancements().getAllAdvancements())))))).then(net.minecraft.commands.CommandDispatcher.literal("revoke").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(net.minecraft.commands.CommandDispatcher.literal("only").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, CommandAdvancement.getAdvancements((CommandContext<CommandListenerWrapper>)var0, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.ONLY)))).then(net.minecraft.commands.CommandDispatcher.argument("criterion", StringArgumentType.greedyString()).suggests((var0, var1) -> ICompletionProvider.suggest(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement").value().criteria().keySet(), var1)).executes(var0 -> CommandAdvancement.performCriterion((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), StringArgumentType.getString((CommandContext)var0, (String)"criterion"))))))).then(net.minecraft.commands.CommandDispatcher.literal("from").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, CommandAdvancement.getAdvancements((CommandContext<CommandListenerWrapper>)var0, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.FROM)))))).then(net.minecraft.commands.CommandDispatcher.literal("until").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, CommandAdvancement.getAdvancements((CommandContext<CommandListenerWrapper>)var0, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.UNTIL)))))).then(net.minecraft.commands.CommandDispatcher.literal("through").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, CommandAdvancement.getAdvancements((CommandContext<CommandListenerWrapper>)var0, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.THROUGH)))))).then(net.minecraft.commands.CommandDispatcher.literal("everything").executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, ((CommandListenerWrapper)var0.getSource()).getServer().getAdvancements().getAllAdvancements()))))));
    }

    private static int perform(CommandListenerWrapper var0, Collection<EntityPlayer> var1, Action var2, Collection<AdvancementHolder> var3) throws CommandSyntaxException {
        int var4 = 0;
        for (EntityPlayer var6 : var1) {
            var4 += var2.perform(var6, var3);
        }
        if (var4 == 0) {
            if (var3.size() == 1) {
                if (var1.size() == 1) {
                    throw ERROR_NO_ACTION_PERFORMED.create((Object)IChatBaseComponent.translatable(var2.getKey() + ".one.to.one.failure", Advancement.name(var3.iterator().next()), var1.iterator().next().getDisplayName()));
                }
                throw ERROR_NO_ACTION_PERFORMED.create((Object)IChatBaseComponent.translatable(var2.getKey() + ".one.to.many.failure", Advancement.name(var3.iterator().next()), var1.size()));
            }
            if (var1.size() == 1) {
                throw ERROR_NO_ACTION_PERFORMED.create((Object)IChatBaseComponent.translatable(var2.getKey() + ".many.to.one.failure", var3.size(), var1.iterator().next().getDisplayName()));
            }
            throw ERROR_NO_ACTION_PERFORMED.create((Object)IChatBaseComponent.translatable(var2.getKey() + ".many.to.many.failure", var3.size(), var1.size()));
        }
        if (var3.size() == 1) {
            if (var1.size() == 1) {
                var0.sendSuccess(() -> IChatBaseComponent.translatable(var2.getKey() + ".one.to.one.success", Advancement.name((AdvancementHolder)var3.iterator().next()), ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
            } else {
                var0.sendSuccess(() -> IChatBaseComponent.translatable(var2.getKey() + ".one.to.many.success", Advancement.name((AdvancementHolder)var3.iterator().next()), var1.size()), true);
            }
        } else if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable(var2.getKey() + ".many.to.one.success", var3.size(), ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable(var2.getKey() + ".many.to.many.success", var3.size(), var1.size()), true);
        }
        return var4;
    }

    private static int performCriterion(CommandListenerWrapper var0, Collection<EntityPlayer> var1, Action var2, AdvancementHolder var3, String var4) throws CommandSyntaxException {
        int var5 = 0;
        Advancement var6 = var3.value();
        if (!var6.criteria().containsKey(var4)) {
            throw ERROR_CRITERION_NOT_FOUND.create((Object)Advancement.name(var3), (Object)var4);
        }
        for (EntityPlayer var8 : var1) {
            if (!var2.performCriterion(var8, var3, var4)) continue;
            ++var5;
        }
        if (var5 == 0) {
            if (var1.size() == 1) {
                throw ERROR_NO_ACTION_PERFORMED.create((Object)IChatBaseComponent.translatable(var2.getKey() + ".criterion.to.one.failure", var4, Advancement.name(var3), var1.iterator().next().getDisplayName()));
            }
            throw ERROR_NO_ACTION_PERFORMED.create((Object)IChatBaseComponent.translatable(var2.getKey() + ".criterion.to.many.failure", var4, Advancement.name(var3), var1.size()));
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable(var2.getKey() + ".criterion.to.one.success", var4, Advancement.name(var3), ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable(var2.getKey() + ".criterion.to.many.success", var4, Advancement.name(var3), var1.size()), true);
        }
        return var5;
    }

    private static List<AdvancementHolder> getAdvancements(CommandContext<CommandListenerWrapper> var0, AdvancementHolder var1, Filter var2) {
        AdvancementTree var3 = ((CommandListenerWrapper)var0.getSource()).getServer().getAdvancements().tree();
        AdvancementNode var4 = var3.get(var1);
        if (var4 == null) {
            return List.of(var1);
        }
        ArrayList<AdvancementHolder> var5 = new ArrayList<AdvancementHolder>();
        if (var2.parents) {
            for (AdvancementNode var6 = var4.parent(); var6 != null; var6 = var6.parent()) {
                var5.add(var6.holder());
            }
        }
        var5.add(var1);
        if (var2.children) {
            CommandAdvancement.addChildren(var4, var5);
        }
        return var5;
    }

    private static void addChildren(AdvancementNode var0, List<AdvancementHolder> var1) {
        for (AdvancementNode var3 : var0.children()) {
            var1.add(var3.holder());
            CommandAdvancement.addChildren(var3, var1);
        }
    }

    static abstract sealed class Action
    extends Enum<Action> {
        public static final /* enum */ Action GRANT = new Action("grant"){

            @Override
            protected boolean perform(EntityPlayer var0, AdvancementHolder var1) {
                AdvancementProgress var2 = var0.getAdvancements().getOrStartProgress(var1);
                if (var2.isDone()) {
                    return false;
                }
                for (String var4 : var2.getRemainingCriteria()) {
                    var0.getAdvancements().award(var1, var4);
                }
                return true;
            }

            @Override
            protected boolean performCriterion(EntityPlayer var0, AdvancementHolder var1, String var2) {
                return var0.getAdvancements().award(var1, var2);
            }
        };
        public static final /* enum */ Action REVOKE = new Action("revoke"){

            @Override
            protected boolean perform(EntityPlayer var0, AdvancementHolder var1) {
                AdvancementProgress var2 = var0.getAdvancements().getOrStartProgress(var1);
                if (!var2.hasProgress()) {
                    return false;
                }
                for (String var4 : var2.getCompletedCriteria()) {
                    var0.getAdvancements().revoke(var1, var4);
                }
                return true;
            }

            @Override
            protected boolean performCriterion(EntityPlayer var0, AdvancementHolder var1, String var2) {
                return var0.getAdvancements().revoke(var1, var2);
            }
        };
        private final String key;
        private static final /* synthetic */ Action[] d;

        public static Action[] values() {
            return (Action[])d.clone();
        }

        public static Action valueOf(String var0) {
            return Enum.valueOf(Action.class, var0);
        }

        Action(String var2) {
            this.key = "commands.advancement." + var2;
        }

        public int perform(EntityPlayer var0, Iterable<AdvancementHolder> var1) {
            int var2 = 0;
            for (AdvancementHolder var4 : var1) {
                if (!this.perform(var0, var4)) continue;
                ++var2;
            }
            return var2;
        }

        protected abstract boolean perform(EntityPlayer var1, AdvancementHolder var2);

        protected abstract boolean performCriterion(EntityPlayer var1, AdvancementHolder var2, String var3);

        protected String getKey() {
            return this.key;
        }

        private static /* synthetic */ Action[] b() {
            return new Action[]{GRANT, REVOKE};
        }

        static {
            d = Action.b();
        }
    }

    static final class Filter
    extends Enum<Filter> {
        public static final /* enum */ Filter ONLY = new Filter(false, false);
        public static final /* enum */ Filter THROUGH = new Filter(true, true);
        public static final /* enum */ Filter FROM = new Filter(false, true);
        public static final /* enum */ Filter UNTIL = new Filter(true, false);
        public static final /* enum */ Filter EVERYTHING = new Filter(true, true);
        final boolean parents;
        final boolean children;
        private static final /* synthetic */ Filter[] h;

        public static Filter[] values() {
            return (Filter[])h.clone();
        }

        public static Filter valueOf(String var0) {
            return Enum.valueOf(Filter.class, var0);
        }

        private Filter(boolean var2, boolean var3) {
            this.parents = var2;
            this.children = var3;
        }

        private static /* synthetic */ Filter[] a() {
            return new Filter[]{ONLY, THROUGH, FROM, UNTIL, EVERYTHING};
        }

        static {
            h = Filter.a();
        }
    }
}

