/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vector3f;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.util.RegistryID;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import org.joml.Quaternionf;

public class DataWatcherRegistry {
    private static final RegistryID<DataWatcherSerializer<?>> SERIALIZERS = RegistryID.create(16);
    public static final DataWatcherSerializer<Byte> BYTE = DataWatcherSerializer.forValueType(ByteBufCodecs.BYTE);
    public static final DataWatcherSerializer<Integer> INT = DataWatcherSerializer.forValueType(ByteBufCodecs.VAR_INT);
    public static final DataWatcherSerializer<Long> LONG = DataWatcherSerializer.forValueType(ByteBufCodecs.VAR_LONG);
    public static final DataWatcherSerializer<Float> FLOAT = DataWatcherSerializer.forValueType(ByteBufCodecs.FLOAT);
    public static final DataWatcherSerializer<String> STRING = DataWatcherSerializer.forValueType(ByteBufCodecs.STRING_UTF8);
    public static final DataWatcherSerializer<IChatBaseComponent> COMPONENT = DataWatcherSerializer.forValueType(ComponentSerialization.TRUSTED_STREAM_CODEC);
    public static final DataWatcherSerializer<Optional<IChatBaseComponent>> OPTIONAL_COMPONENT = DataWatcherSerializer.forValueType(ComponentSerialization.TRUSTED_OPTIONAL_STREAM_CODEC);
    public static final DataWatcherSerializer<ItemStack> ITEM_STACK = new DataWatcherSerializer<ItemStack>(){

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, ItemStack> codec() {
            return ItemStack.OPTIONAL_STREAM_CODEC;
        }

        @Override
        public ItemStack copy(ItemStack var0) {
            return var0.copy();
        }

        @Override
        public /* synthetic */ Object copy(Object object) {
            return this.copy((ItemStack)object);
        }
    };
    public static final DataWatcherSerializer<IBlockData> BLOCK_STATE = DataWatcherSerializer.forValueType(ByteBufCodecs.idMapper(Block.BLOCK_STATE_REGISTRY));
    private static final StreamCodec<ByteBuf, Optional<IBlockData>> OPTIONAL_BLOCK_STATE_CODEC = new StreamCodec<ByteBuf, Optional<IBlockData>>(){

        @Override
        public void encode(ByteBuf var0, Optional<IBlockData> var1) {
            if (var1.isPresent()) {
                VarInt.write(var0, Block.getId(var1.get()));
            } else {
                VarInt.write(var0, 0);
            }
        }

        @Override
        public Optional<IBlockData> decode(ByteBuf var0) {
            int var1 = VarInt.read(var0);
            if (var1 == 0) {
                return Optional.empty();
            }
            return Optional.of(Block.stateById(var1));
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (Optional)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final DataWatcherSerializer<Optional<IBlockData>> OPTIONAL_BLOCK_STATE = DataWatcherSerializer.forValueType(OPTIONAL_BLOCK_STATE_CODEC);
    public static final DataWatcherSerializer<Boolean> BOOLEAN = DataWatcherSerializer.forValueType(ByteBufCodecs.BOOL);
    public static final DataWatcherSerializer<ParticleParam> PARTICLE = DataWatcherSerializer.forValueType(Particles.STREAM_CODEC);
    public static final DataWatcherSerializer<List<ParticleParam>> PARTICLES = DataWatcherSerializer.forValueType(Particles.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DataWatcherSerializer<Vector3f> ROTATIONS = DataWatcherSerializer.forValueType(Vector3f.STREAM_CODEC);
    public static final DataWatcherSerializer<BlockPosition> BLOCK_POS = DataWatcherSerializer.forValueType(BlockPosition.STREAM_CODEC);
    public static final DataWatcherSerializer<Optional<BlockPosition>> OPTIONAL_BLOCK_POS = DataWatcherSerializer.forValueType(BlockPosition.STREAM_CODEC.apply(ByteBufCodecs::optional));
    public static final DataWatcherSerializer<EnumDirection> DIRECTION = DataWatcherSerializer.forValueType(EnumDirection.STREAM_CODEC);
    public static final DataWatcherSerializer<Optional<UUID>> OPTIONAL_UUID = DataWatcherSerializer.forValueType(UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional));
    public static final DataWatcherSerializer<Optional<GlobalPos>> OPTIONAL_GLOBAL_POS = DataWatcherSerializer.forValueType(GlobalPos.STREAM_CODEC.apply(ByteBufCodecs::optional));
    public static final DataWatcherSerializer<NBTTagCompound> COMPOUND_TAG = new DataWatcherSerializer<NBTTagCompound>(){

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, NBTTagCompound> codec() {
            return ByteBufCodecs.TRUSTED_COMPOUND_TAG;
        }

        @Override
        public NBTTagCompound copy(NBTTagCompound var0) {
            return var0.copy();
        }

        @Override
        public /* synthetic */ Object copy(Object object) {
            return this.copy((NBTTagCompound)object);
        }
    };
    public static final DataWatcherSerializer<VillagerData> VILLAGER_DATA = DataWatcherSerializer.forValueType(VillagerData.STREAM_CODEC);
    private static final StreamCodec<ByteBuf, OptionalInt> OPTIONAL_UNSIGNED_INT_CODEC = new StreamCodec<ByteBuf, OptionalInt>(){

        @Override
        public OptionalInt decode(ByteBuf var0) {
            int var1 = VarInt.read(var0);
            return var1 == 0 ? OptionalInt.empty() : OptionalInt.of(var1 - 1);
        }

        @Override
        public void encode(ByteBuf var0, OptionalInt var1) {
            VarInt.write(var0, var1.orElse(-1) + 1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (OptionalInt)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final DataWatcherSerializer<OptionalInt> OPTIONAL_UNSIGNED_INT = DataWatcherSerializer.forValueType(OPTIONAL_UNSIGNED_INT_CODEC);
    public static final DataWatcherSerializer<EntityPose> POSE = DataWatcherSerializer.forValueType(EntityPose.STREAM_CODEC);
    public static final DataWatcherSerializer<Holder<CatVariant>> CAT_VARIANT = DataWatcherSerializer.forValueType(ByteBufCodecs.holderRegistry(Registries.CAT_VARIANT));
    public static final DataWatcherSerializer<Holder<WolfVariant>> WOLF_VARIANT = DataWatcherSerializer.forValueType(ByteBufCodecs.holderRegistry(Registries.WOLF_VARIANT));
    public static final DataWatcherSerializer<Holder<FrogVariant>> FROG_VARIANT = DataWatcherSerializer.forValueType(ByteBufCodecs.holderRegistry(Registries.FROG_VARIANT));
    public static final DataWatcherSerializer<Holder<PaintingVariant>> PAINTING_VARIANT = DataWatcherSerializer.forValueType(ByteBufCodecs.holderRegistry(Registries.PAINTING_VARIANT));
    public static final DataWatcherSerializer<Armadillo.a> ARMADILLO_STATE = DataWatcherSerializer.forValueType(Armadillo.a.STREAM_CODEC);
    public static final DataWatcherSerializer<Sniffer.State> SNIFFER_STATE = DataWatcherSerializer.forValueType(Sniffer.State.STREAM_CODEC);
    public static final DataWatcherSerializer<org.joml.Vector3f> VECTOR3 = DataWatcherSerializer.forValueType(ByteBufCodecs.VECTOR3F);
    public static final DataWatcherSerializer<Quaternionf> QUATERNION = DataWatcherSerializer.forValueType(ByteBufCodecs.QUATERNIONF);

    public static void registerSerializer(DataWatcherSerializer<?> var0) {
        SERIALIZERS.add(var0);
    }

    @Nullable
    public static DataWatcherSerializer<?> getSerializer(int var0) {
        return SERIALIZERS.byId(var0);
    }

    public static int getSerializedId(DataWatcherSerializer<?> var0) {
        return SERIALIZERS.getId(var0);
    }

    private DataWatcherRegistry() {
    }

    static {
        DataWatcherRegistry.registerSerializer(BYTE);
        DataWatcherRegistry.registerSerializer(INT);
        DataWatcherRegistry.registerSerializer(LONG);
        DataWatcherRegistry.registerSerializer(FLOAT);
        DataWatcherRegistry.registerSerializer(STRING);
        DataWatcherRegistry.registerSerializer(COMPONENT);
        DataWatcherRegistry.registerSerializer(OPTIONAL_COMPONENT);
        DataWatcherRegistry.registerSerializer(ITEM_STACK);
        DataWatcherRegistry.registerSerializer(BOOLEAN);
        DataWatcherRegistry.registerSerializer(ROTATIONS);
        DataWatcherRegistry.registerSerializer(BLOCK_POS);
        DataWatcherRegistry.registerSerializer(OPTIONAL_BLOCK_POS);
        DataWatcherRegistry.registerSerializer(DIRECTION);
        DataWatcherRegistry.registerSerializer(OPTIONAL_UUID);
        DataWatcherRegistry.registerSerializer(BLOCK_STATE);
        DataWatcherRegistry.registerSerializer(OPTIONAL_BLOCK_STATE);
        DataWatcherRegistry.registerSerializer(COMPOUND_TAG);
        DataWatcherRegistry.registerSerializer(PARTICLE);
        DataWatcherRegistry.registerSerializer(PARTICLES);
        DataWatcherRegistry.registerSerializer(VILLAGER_DATA);
        DataWatcherRegistry.registerSerializer(OPTIONAL_UNSIGNED_INT);
        DataWatcherRegistry.registerSerializer(POSE);
        DataWatcherRegistry.registerSerializer(CAT_VARIANT);
        DataWatcherRegistry.registerSerializer(WOLF_VARIANT);
        DataWatcherRegistry.registerSerializer(FROG_VARIANT);
        DataWatcherRegistry.registerSerializer(OPTIONAL_GLOBAL_POS);
        DataWatcherRegistry.registerSerializer(PAINTING_VARIANT);
        DataWatcherRegistry.registerSerializer(SNIFFER_STATE);
        DataWatcherRegistry.registerSerializer(ARMADILLO_STATE);
        DataWatcherRegistry.registerSerializer(VECTOR3);
        DataWatcherRegistry.registerSerializer(QUATERNION);
    }
}

