/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class PacketPlayOutUpdateAttributes
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutUpdateAttributes> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, PacketPlayOutUpdateAttributes::getEntityId, AttributeSnapshot.STREAM_CODEC.apply(ByteBufCodecs.list()), PacketPlayOutUpdateAttributes::getValues, PacketPlayOutUpdateAttributes::new);
    private final int entityId;
    private final List<AttributeSnapshot> attributes;

    public PacketPlayOutUpdateAttributes(int var0, Collection<AttributeModifiable> var1) {
        this.entityId = var0;
        this.attributes = Lists.newArrayList();
        for (AttributeModifiable var3 : var1) {
            this.attributes.add(new AttributeSnapshot(var3.getAttribute(), var3.getBaseValue(), var3.getModifiers()));
        }
    }

    private PacketPlayOutUpdateAttributes(int var0, List<AttributeSnapshot> var1) {
        this.entityId = var0;
        this.attributes = var1;
    }

    @Override
    public PacketType<PacketPlayOutUpdateAttributes> type() {
        return GamePacketTypes.CLIENTBOUND_UPDATE_ATTRIBUTES;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleUpdateAttributes(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public List<AttributeSnapshot> getValues() {
        return this.attributes;
    }

    public record AttributeSnapshot(Holder<AttributeBase> attribute, double base, Collection<AttributeModifier> modifiers) {
        public static final StreamCodec<ByteBuf, AttributeModifier> MODIFIER_STREAM_CODEC = StreamCodec.composite(UUIDUtil.STREAM_CODEC, AttributeModifier::id, ByteBufCodecs.DOUBLE, AttributeModifier::amount, AttributeModifier.Operation.STREAM_CODEC, AttributeModifier::operation, (var0, var1, var2) -> new AttributeModifier((UUID)var0, "Unknown synced attribute modifier", (double)var1, (AttributeModifier.Operation)var2));
        public static final StreamCodec<RegistryFriendlyByteBuf, AttributeSnapshot> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.ATTRIBUTE), AttributeSnapshot::attribute, ByteBufCodecs.DOUBLE, AttributeSnapshot::base, MODIFIER_STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new)), AttributeSnapshot::modifiers, AttributeSnapshot::new);
    }
}

