/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutExplosion
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutExplosion> STREAM_CODEC = Packet.codec(PacketPlayOutExplosion::write, PacketPlayOutExplosion::new);
    private final double x;
    private final double y;
    private final double z;
    private final float power;
    private final List<BlockPosition> toBlow;
    private final float knockbackX;
    private final float knockbackY;
    private final float knockbackZ;
    private final ParticleParam smallExplosionParticles;
    private final ParticleParam largeExplosionParticles;
    private final Explosion.Effect blockInteraction;
    private final Holder<SoundEffect> explosionSound;

    public PacketPlayOutExplosion(double var0, double var2, double var4, float var6, List<BlockPosition> var7, @Nullable Vec3D var8, Explosion.Effect var9, ParticleParam var10, ParticleParam var11, Holder<SoundEffect> var12) {
        this.x = var0;
        this.y = var2;
        this.z = var4;
        this.power = var6;
        this.toBlow = Lists.newArrayList(var7);
        this.explosionSound = var12;
        if (var8 != null) {
            this.knockbackX = (float)var8.x;
            this.knockbackY = (float)var8.y;
            this.knockbackZ = (float)var8.z;
        } else {
            this.knockbackX = 0.0f;
            this.knockbackY = 0.0f;
            this.knockbackZ = 0.0f;
        }
        this.blockInteraction = var9;
        this.smallExplosionParticles = var10;
        this.largeExplosionParticles = var11;
    }

    private PacketPlayOutExplosion(RegistryFriendlyByteBuf var0) {
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.power = var0.readFloat();
        int var1 = MathHelper.floor(this.x);
        int var2 = MathHelper.floor(this.y);
        int var32 = MathHelper.floor(this.z);
        this.toBlow = var0.readList(var3 -> {
            int var4 = var3.readByte() + var1;
            int var5 = var3.readByte() + var2;
            int var6 = var3.readByte() + var32;
            return new BlockPosition(var4, var5, var6);
        });
        this.knockbackX = var0.readFloat();
        this.knockbackY = var0.readFloat();
        this.knockbackZ = var0.readFloat();
        this.blockInteraction = var0.readEnum(Explosion.Effect.class);
        this.smallExplosionParticles = (ParticleParam)Particles.STREAM_CODEC.decode(var0);
        this.largeExplosionParticles = (ParticleParam)Particles.STREAM_CODEC.decode(var0);
        this.explosionSound = (Holder)SoundEffect.STREAM_CODEC.decode(var0);
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeFloat(this.power);
        int var1 = MathHelper.floor(this.x);
        int var2 = MathHelper.floor(this.y);
        int var32 = MathHelper.floor(this.z);
        var0.writeCollection(this.toBlow, (var3, var4) -> {
            int var5 = var4.getX() - var1;
            int var6 = var4.getY() - var2;
            int var7 = var4.getZ() - var32;
            var3.writeByte(var5);
            var3.writeByte(var6);
            var3.writeByte(var7);
        });
        var0.writeFloat(this.knockbackX);
        var0.writeFloat(this.knockbackY);
        var0.writeFloat(this.knockbackZ);
        var0.writeEnum(this.blockInteraction);
        Particles.STREAM_CODEC.encode(var0, this.smallExplosionParticles);
        Particles.STREAM_CODEC.encode(var0, this.largeExplosionParticles);
        SoundEffect.STREAM_CODEC.encode(var0, this.explosionSound);
    }

    @Override
    public PacketType<PacketPlayOutExplosion> type() {
        return GamePacketTypes.CLIENTBOUND_EXPLODE;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleExplosion(this);
    }

    public float getKnockbackX() {
        return this.knockbackX;
    }

    public float getKnockbackY() {
        return this.knockbackY;
    }

    public float getKnockbackZ() {
        return this.knockbackZ;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPower() {
        return this.power;
    }

    public List<BlockPosition> getToBlow() {
        return this.toBlow;
    }

    public Explosion.Effect getBlockInteraction() {
        return this.blockInteraction;
    }

    public ParticleParam getSmallExplosionParticles() {
        return this.smallExplosionParticles;
    }

    public ParticleParam getLargeExplosionParticles() {
        return this.largeExplosionParticles;
    }

    public Holder<SoundEffect> getExplosionSound() {
        return this.explosionSound;
    }
}

