/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.EnumGamemode;

public class ClientboundPlayerInfoUpdatePacket
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundPlayerInfoUpdatePacket> STREAM_CODEC = Packet.codec(ClientboundPlayerInfoUpdatePacket::write, ClientboundPlayerInfoUpdatePacket::new);
    private final EnumSet<a> actions;
    private final List<b> entries;

    public ClientboundPlayerInfoUpdatePacket(EnumSet<a> var0, Collection<EntityPlayer> var1) {
        this.actions = var0;
        this.entries = var1.stream().map(b::new).toList();
    }

    public ClientboundPlayerInfoUpdatePacket(a var0, EntityPlayer var1) {
        this.actions = EnumSet.of(var0);
        this.entries = List.of(new b(var1));
    }

    public static ClientboundPlayerInfoUpdatePacket createPlayerInitializing(Collection<EntityPlayer> var0) {
        EnumSet<a[]> var1 = EnumSet.of(a.ADD_PLAYER, new a[]{a.INITIALIZE_CHAT, a.UPDATE_GAME_MODE, a.UPDATE_LISTED, a.UPDATE_LATENCY, a.UPDATE_DISPLAY_NAME});
        return new ClientboundPlayerInfoUpdatePacket(var1, var0);
    }

    private ClientboundPlayerInfoUpdatePacket(RegistryFriendlyByteBuf var02) {
        this.actions = var02.readEnumSet(a.class);
        this.entries = var02.readList(var0 -> {
            c var1 = new c(var0.readUUID());
            for (a var3 : this.actions) {
                var3.reader.read(var1, (RegistryFriendlyByteBuf)((Object)var0));
            }
            return var1.build();
        });
    }

    private void write(RegistryFriendlyByteBuf var02) {
        var02.writeEnumSet(this.actions, a.class);
        var02.writeCollection(this.entries, (var0, var1) -> {
            var0.writeUUID(var1.profileId());
            for (a var3 : this.actions) {
                var3.writer.write((RegistryFriendlyByteBuf)((Object)var0), (b)var1);
            }
        });
    }

    @Override
    public PacketType<ClientboundPlayerInfoUpdatePacket> type() {
        return GamePacketTypes.CLIENTBOUND_PLAYER_INFO_UPDATE;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handlePlayerInfoUpdate(this);
    }

    public EnumSet<a> actions() {
        return this.actions;
    }

    public List<b> entries() {
        return this.entries;
    }

    public List<b> newEntries() {
        return this.actions.contains((Object)a.ADD_PLAYER) ? this.entries : List.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actions", this.actions).add("entries", this.entries).toString();
    }

    public static final class b
    extends Record {
        private final UUID profileId;
        @Nullable
        private final GameProfile profile;
        private final boolean listed;
        private final int latency;
        private final EnumGamemode gameMode;
        @Nullable
        private final IChatBaseComponent displayName;
        @Nullable
        final RemoteChatSession.a chatSession;

        b(EntityPlayer var0) {
            this(var0.getUUID(), var0.getGameProfile(), true, var0.connection.latency(), var0.gameMode.getGameModeForPlayer(), var0.getTabListDisplayName(), Optionull.map(var0.getChatSession(), RemoteChatSession::asData));
        }

        public b(UUID var0, @Nullable GameProfile var1, boolean var2, int var3, EnumGamemode var4, @Nullable IChatBaseComponent var5, @Nullable RemoteChatSession.a var6) {
            this.profileId = var0;
            this.profile = var1;
            this.listed = var2;
            this.latency = var3;
            this.gameMode = var4;
            this.displayName = var5;
            this.chatSession = var6;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "profileId;profile;listed;latency;gameMode;displayName;chatSession", "profileId", "profile", "listed", "latency", "gameMode", "displayName", "chatSession"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "profileId;profile;listed;latency;gameMode;displayName;chatSession", "profileId", "profile", "listed", "latency", "gameMode", "displayName", "chatSession"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "profileId;profile;listed;latency;gameMode;displayName;chatSession", "profileId", "profile", "listed", "latency", "gameMode", "displayName", "chatSession"}, this, var0);
        }

        public UUID profileId() {
            return this.profileId;
        }

        @Nullable
        public GameProfile profile() {
            return this.profile;
        }

        public boolean listed() {
            return this.listed;
        }

        public int latency() {
            return this.latency;
        }

        public EnumGamemode gameMode() {
            return this.gameMode;
        }

        @Nullable
        public IChatBaseComponent displayName() {
            return this.displayName;
        }

        @Nullable
        public RemoteChatSession.a chatSession() {
            return this.chatSession;
        }
    }

    public static final class net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a
    extends Enum<net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a> {
        public static final /* enum */ net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a ADD_PLAYER = new net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a((var0, var1) -> {
            GameProfile var2 = new GameProfile(var0.profileId, var1.readUtf(16));
            var2.getProperties().putAll((Multimap)ByteBufCodecs.GAME_PROFILE_PROPERTIES.decode(var1));
            var0.profile = var2;
        }, (var0, var1) -> {
            GameProfile var2 = Objects.requireNonNull(var1.profile());
            var0.writeUtf(var2.getName(), 16);
            ByteBufCodecs.GAME_PROFILE_PROPERTIES.encode(var0, var2.getProperties());
        });
        public static final /* enum */ net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a INITIALIZE_CHAT = new net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a((var0, var1) -> {
            var0.chatSession = var1.readNullable(RemoteChatSession.a::read);
        }, (var0, var1) -> var0.writeNullable(var1.chatSession, RemoteChatSession.a::write));
        public static final /* enum */ net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a UPDATE_GAME_MODE = new net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a((var0, var1) -> {
            var0.gameMode = EnumGamemode.byId(var1.readVarInt());
        }, (var0, var1) -> var0.writeVarInt(var1.gameMode().getId()));
        public static final /* enum */ net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a UPDATE_LISTED = new net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a((var0, var1) -> {
            var0.listed = var1.readBoolean();
        }, (var0, var1) -> var0.writeBoolean(var1.listed()));
        public static final /* enum */ net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a UPDATE_LATENCY = new net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a((var0, var1) -> {
            var0.latency = var1.readVarInt();
        }, (var0, var1) -> var0.writeVarInt(var1.latency()));
        public static final /* enum */ net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a UPDATE_DISPLAY_NAME = new net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a((var0, var1) -> {
            var0.displayName = PacketDataSerializer.readNullable(var1, ComponentSerialization.TRUSTED_STREAM_CODEC);
        }, (var0, var1) -> PacketDataSerializer.writeNullable(var0, var1.displayName(), ComponentSerialization.TRUSTED_STREAM_CODEC));
        final a reader;
        final b writer;
        private static final /* synthetic */ net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a[] i;

        public static net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a[] values() {
            return (net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a[])i.clone();
        }

        public static net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a valueOf(String var0) {
            return Enum.valueOf(net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a.class, var0);
        }

        private net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a(a var2, b var3) {
            this.reader = var2;
            this.writer = var3;
        }

        private static /* synthetic */ net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a[] a() {
            return new net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a[]{ADD_PLAYER, INITIALIZE_CHAT, UPDATE_GAME_MODE, UPDATE_LISTED, UPDATE_LATENCY, UPDATE_DISPLAY_NAME};
        }

        static {
            i = net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$a.a();
        }

        public static interface a {
            public void read(c var1, RegistryFriendlyByteBuf var2);
        }

        public static interface b {
            public void write(RegistryFriendlyByteBuf var1, net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$b var2);
        }
    }

    static class c {
        final UUID profileId;
        @Nullable
        GameProfile profile;
        boolean listed;
        int latency;
        EnumGamemode gameMode = EnumGamemode.DEFAULT_MODE;
        @Nullable
        IChatBaseComponent displayName;
        @Nullable
        RemoteChatSession.a chatSession;

        c(UUID var0) {
            this.profileId = var0;
        }

        b build() {
            return new b(this.profileId, this.profile, this.listed, this.latency, this.gameMode, this.displayName, this.chatSession);
        }
    }
}

