/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.StreamTagVisitor;

public interface NBTTagType<T extends NBTBase> {
    public T load(DataInput var1, NBTReadLimiter var2) throws IOException;

    public StreamTagVisitor.b parse(DataInput var1, StreamTagVisitor var2, NBTReadLimiter var3) throws IOException;

    default public void parseRoot(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
        switch (var1.visitRootEntry(this)) {
            case CONTINUE: {
                this.parse(var0, var1, var2);
                break;
            }
            case HALT: {
                break;
            }
            case BREAK: {
                this.skip(var0, var2);
            }
        }
    }

    public void skip(DataInput var1, int var2, NBTReadLimiter var3) throws IOException;

    public void skip(DataInput var1, NBTReadLimiter var2) throws IOException;

    default public boolean isValue() {
        return false;
    }

    public String getName();

    public String getPrettyName();

    public static NBTTagType<NBTTagEnd> createInvalid(final int var0) {
        return new NBTTagType<NBTTagEnd>(){

            private IOException createException() {
                return new IOException("Invalid tag id: " + var0);
            }

            @Override
            public NBTTagEnd load(DataInput var02, NBTReadLimiter var1) throws IOException {
                throw this.createException();
            }

            @Override
            public StreamTagVisitor.b parse(DataInput var02, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
                throw this.createException();
            }

            @Override
            public void skip(DataInput var02, int var1, NBTReadLimiter var2) throws IOException {
                throw this.createException();
            }

            @Override
            public void skip(DataInput var02, NBTReadLimiter var1) throws IOException {
                throw this.createException();
            }

            @Override
            public String getName() {
                return "INVALID[" + var0 + "]";
            }

            @Override
            public String getPrettyName() {
                return "UNKNOWN_" + var0;
            }

            @Override
            public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
                return this.load(dataInput, nBTReadLimiter);
            }
        };
    }

    public static interface b<T extends NBTBase>
    extends NBTTagType<T> {
        @Override
        default public void skip(DataInput var0, int var1, NBTReadLimiter var2) throws IOException {
            for (int var3 = 0; var3 < var1; ++var3) {
                this.skip(var0, var2);
            }
        }
    }

    public static interface a<T extends NBTBase>
    extends NBTTagType<T> {
        @Override
        default public void skip(DataInput var0, NBTReadLimiter var1) throws IOException {
            var0.skipBytes(this.size());
        }

        @Override
        default public void skip(DataInput var0, int var1, NBTReadLimiter var2) throws IOException {
            var0.skipBytes(this.size() * var1);
        }

        public int size();
    }
}

