/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.world.phys.AxisAlignedBB;

public class StructureGridSpawner
implements GameTestHarnessRunner.c {
    private static final int SPACE_BETWEEN_COLUMNS = 5;
    private static final int SPACE_BETWEEN_ROWS = 6;
    private final int testsPerRow;
    private int currentRowCount;
    private AxisAlignedBB rowBounds;
    private final BlockPosition.MutableBlockPosition nextTestNorthWestCorner;
    private final BlockPosition firstTestNorthWestCorner;

    public StructureGridSpawner(BlockPosition var0, int var1) {
        this.testsPerRow = var1;
        this.nextTestNorthWestCorner = var0.mutable();
        this.rowBounds = new AxisAlignedBB(this.nextTestNorthWestCorner);
        this.firstTestNorthWestCorner = var0;
    }

    @Override
    public Optional<GameTestHarnessInfo> spawnStructure(GameTestHarnessInfo var0) {
        BlockPosition var1 = new BlockPosition(this.nextTestNorthWestCorner);
        var0.setNorthWestCorner(var1);
        var0.prepareTestStructure();
        AxisAlignedBB var2 = GameTestHarnessStructures.getStructureBounds(var0.getStructureBlockEntity());
        this.rowBounds = this.rowBounds.minmax(var2);
        this.nextTestNorthWestCorner.move((int)var2.getXsize() + 5, 0, 0);
        if (++this.currentRowCount >= this.testsPerRow) {
            this.currentRowCount = 0;
            this.nextTestNorthWestCorner.move(0, 0, (int)this.rowBounds.getZsize() + 6);
            this.nextTestNorthWestCorner.setX(this.firstTestNorthWestCorner.getX());
            this.rowBounds = new AxisAlignedBB(this.nextTestNorthWestCorner);
        }
        return Optional.of(var0);
    }
}

