/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestHarnessListener {
    private int attempts = 0;
    private int successes = 0;

    @Override
    public void testStructureLoaded(GameTestHarnessInfo var0) {
        ReportGameListener.spawnBeacon(var0, Blocks.LIGHT_GRAY_STAINED_GLASS);
        ++this.attempts;
    }

    private void handleRetry(GameTestHarnessInfo var0, GameTestHarnessRunner var1, boolean var2) {
        RetryOptions var3 = var0.retryOptions();
        Object var4 = String.format("[Run: %4d, Ok: %4d, Fail: %4d", this.attempts, this.successes, this.attempts - this.successes);
        if (!var3.unlimitedTries()) {
            var4 = (String)var4 + String.format(", Left: %4d", var3.numberOfTries() - this.attempts);
        }
        var4 = (String)var4 + "]";
        String var5 = var0.getTestName() + " " + (var2 ? "passed" : "failed") + "! " + var0.getRunTime() + "ms";
        String var6 = String.format("%-53s%s", var4, var5);
        if (var2) {
            ReportGameListener.reportPassed(var0, var6);
        } else {
            ReportGameListener.say(var0.getLevel(), EnumChatFormat.RED, var6);
        }
        if (var3.hasTriesLeft(this.attempts, this.successes)) {
            var1.rerunTest(var0);
        }
    }

    @Override
    public void testPassed(GameTestHarnessInfo var0, GameTestHarnessRunner var1) {
        ++this.successes;
        if (var0.retryOptions().hasRetries()) {
            this.handleRetry(var0, var1, true);
            return;
        }
        if (!var0.isFlaky()) {
            ReportGameListener.reportPassed(var0, var0.getTestName() + " passed! (" + var0.getRunTime() + "ms)");
            return;
        }
        if (this.successes >= var0.requiredSuccesses()) {
            ReportGameListener.reportPassed(var0, String.valueOf(var0) + " passed " + this.successes + " times of " + this.attempts + " attempts.");
        } else {
            ReportGameListener.say(var0.getLevel(), EnumChatFormat.GREEN, "Flaky test " + String.valueOf(var0) + " succeeded, attempt: " + this.attempts + " successes: " + this.successes);
            var1.rerunTest(var0);
        }
    }

    @Override
    public void testFailed(GameTestHarnessInfo var0, GameTestHarnessRunner var1) {
        if (!var0.isFlaky()) {
            ReportGameListener.reportFailure(var0, var0.getError());
            if (var0.retryOptions().hasRetries()) {
                this.handleRetry(var0, var1, false);
            }
            return;
        }
        GameTestHarnessTestFunction var2 = var0.getTestFunction();
        String var3 = "Flaky test " + String.valueOf(var0) + " failed, attempt: " + this.attempts + "/" + var2.maxAttempts();
        if (var2.requiredSuccesses() > 1) {
            var3 = var3 + ", successes: " + this.successes + " (" + var2.requiredSuccesses() + " required)";
        }
        ReportGameListener.say(var0.getLevel(), EnumChatFormat.YELLOW, var3);
        if (var0.maxAttempts() - this.attempts + this.successes >= var0.requiredSuccesses()) {
            var1.rerunTest(var0);
        } else {
            ReportGameListener.reportFailure(var0, new ExhaustedAttemptsException(this.attempts, this.successes, var0));
        }
    }

    @Override
    public void testAddedForRerun(GameTestHarnessInfo var0, GameTestHarnessInfo var1, GameTestHarnessRunner var2) {
        var1.addListener(this);
    }

    public static void reportPassed(GameTestHarnessInfo var0, String var1) {
        ReportGameListener.spawnBeacon(var0, Blocks.LIME_STAINED_GLASS);
        ReportGameListener.visualizePassedTest(var0, var1);
    }

    private static void visualizePassedTest(GameTestHarnessInfo var0, String var1) {
        ReportGameListener.say(var0.getLevel(), EnumChatFormat.GREEN, var1);
        GlobalTestReporter.onTestSuccess(var0);
    }

    protected static void reportFailure(GameTestHarnessInfo var0, Throwable var1) {
        ReportGameListener.spawnBeacon(var0, var0.isRequired() ? Blocks.RED_STAINED_GLASS : Blocks.ORANGE_STAINED_GLASS);
        ReportGameListener.spawnLectern(var0, SystemUtils.describeError(var1));
        ReportGameListener.visualizeFailedTest(var0, var1);
    }

    protected static void visualizeFailedTest(GameTestHarnessInfo var0, Throwable var1) {
        String var2 = var1.getMessage() + (String)(var1.getCause() == null ? "" : " cause: " + SystemUtils.describeError(var1.getCause()));
        String var3 = (var0.isRequired() ? "" : "(optional) ") + var0.getTestName() + " failed! " + var2;
        ReportGameListener.say(var0.getLevel(), var0.isRequired() ? EnumChatFormat.RED : EnumChatFormat.YELLOW, var3);
        Throwable var4 = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)var1), (Object)var1);
        if (var4 instanceof GameTestHarnessAssertionPosition) {
            GameTestHarnessAssertionPosition var5 = (GameTestHarnessAssertionPosition)var4;
            ReportGameListener.showRedBox(var0.getLevel(), var5.getAbsolutePos(), var5.getMessageToShowAtBlock());
        }
        GlobalTestReporter.onTestFailed(var0);
    }

    protected static void spawnBeacon(GameTestHarnessInfo var0, Block var1) {
        WorldServer var2 = var0.getLevel();
        BlockPosition var3 = var0.getStructureBlockPos();
        BlockPosition var4 = new BlockPosition(-1, -2, -1);
        BlockPosition var5 = DefinedStructure.transform(var3.offset(var4), EnumBlockMirror.NONE, var0.getRotation(), var3);
        var2.setBlockAndUpdate(var5, Blocks.BEACON.defaultBlockState().rotate(var0.getRotation()));
        BlockPosition var6 = var5.offset(0, 1, 0);
        var2.setBlockAndUpdate(var6, var1.defaultBlockState());
        for (int var7 = -1; var7 <= 1; ++var7) {
            for (int var8 = -1; var8 <= 1; ++var8) {
                BlockPosition var9 = var5.offset(var7, -1, var8);
                var2.setBlockAndUpdate(var9, Blocks.IRON_BLOCK.defaultBlockState());
            }
        }
    }

    private static void spawnLectern(GameTestHarnessInfo var0, String var1) {
        WorldServer var2 = var0.getLevel();
        BlockPosition var3 = var0.getStructureBlockPos();
        BlockPosition var4 = new BlockPosition(-1, 0, -1);
        BlockPosition var5 = DefinedStructure.transform(var3.offset(var4), EnumBlockMirror.NONE, var0.getRotation(), var3);
        var2.setBlockAndUpdate(var5, Blocks.LECTERN.defaultBlockState().rotate(var0.getRotation()));
        IBlockData var6 = var2.getBlockState(var5);
        ItemStack var7 = ReportGameListener.createBook(var0.getTestName(), var0.isRequired(), var1);
        BlockLectern.tryPlaceBook(null, var2, var5, var6, var7);
    }

    private static ItemStack createBook(String var0, boolean var12, String var2) {
        StringBuffer var3 = new StringBuffer();
        Arrays.stream(var0.split("\\.")).forEach(var1 -> var3.append((String)var1).append('\n'));
        if (!var12) {
            var3.append("(optional)\n");
        }
        var3.append("-------------------\n");
        ItemStack var4 = new ItemStack(Items.WRITABLE_BOOK);
        var4.set(DataComponents.WRITABLE_BOOK_CONTENT, new WritableBookContent(List.of(Filterable.passThrough(String.valueOf(var3) + var2))));
        return var4;
    }

    protected static void say(WorldServer var02, EnumChatFormat var1, String var22) {
        var02.getPlayers(var0 -> true).forEach(var2 -> var2.sendSystemMessage(IChatBaseComponent.literal(var22).withStyle(var1)));
    }

    private static void showRedBox(WorldServer var0, BlockPosition var1, String var2) {
        PacketDebug.sendGameTestAddMarker(var0, var1, var2, -2130771968, Integer.MAX_VALUE);
    }
}

