/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRegistry;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.server.level.WorldServer;

public class GameTestBatchFactory {
    private static final int MAX_TESTS_PER_BATCH = 50;

    public static Collection<GameTestHarnessBatch> fromTestFunction(Collection<GameTestHarnessTestFunction> var0, WorldServer var12) {
        Map<String, List<GameTestHarnessTestFunction>> var2 = var0.stream().collect(Collectors.groupingBy(GameTestHarnessTestFunction::batchName));
        return var2.entrySet().stream().flatMap(var1 -> {
            String var22 = (String)var1.getKey();
            List var32 = (List)var1.getValue();
            return Streams.mapWithIndex(Lists.partition((List)var32, (int)50).stream(), (var2, var3) -> GameTestBatchFactory.toGameTestBatch(var2.stream().map(var1 -> GameTestBatchFactory.toGameTestInfo(var1, 0, var12)).toList(), var22, var3));
        }).toList();
    }

    public static GameTestHarnessInfo toGameTestInfo(GameTestHarnessTestFunction var0, int var1, WorldServer var2) {
        return new GameTestHarnessInfo(var0, GameTestHarnessStructures.getRotationForRotationSteps(var1), var2, RetryOptions.noRetries());
    }

    public static GameTestHarnessRunner.b fromGameTestInfo() {
        return var02 -> {
            Map<String, List<GameTestHarnessInfo>> var1 = var02.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(var0 -> var0.getTestFunction().batchName()));
            return var1.entrySet().stream().flatMap(var0 -> {
                String var12 = (String)var0.getKey();
                List var22 = (List)var0.getValue();
                return Streams.mapWithIndex(Lists.partition((List)var22, (int)50).stream(), (var1, var2) -> GameTestBatchFactory.toGameTestBatch(List.copyOf(var1), var12, var2));
            }).toList();
        };
    }

    private static GameTestHarnessBatch toGameTestBatch(List<GameTestHarnessInfo> var0, String var1, long var2) {
        Consumer<WorldServer> var4 = GameTestHarnessRegistry.getBeforeBatchFunction(var1);
        Consumer<WorldServer> var5 = GameTestHarnessRegistry.getAfterBatchFunction(var1);
        return new GameTestHarnessBatch(var1 + ":" + var2, var0, var4, var5);
    }
}

