/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.features;

import net.minecraft.core.HolderSet;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenDecoratorFrequencyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandom2;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class AquaticFeatures {
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SEAGRASS_SHORT = FeatureUtils.createKey("seagrass_short");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SEAGRASS_SLIGHTLY_LESS_SHORT = FeatureUtils.createKey("seagrass_slightly_less_short");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SEAGRASS_MID = FeatureUtils.createKey("seagrass_mid");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SEAGRASS_TALL = FeatureUtils.createKey("seagrass_tall");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SEA_PICKLE = FeatureUtils.createKey("sea_pickle");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SEAGRASS_SIMPLE = FeatureUtils.createKey("seagrass_simple");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> KELP = FeatureUtils.createKey("kelp");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> WARM_OCEAN_VEGETATION = FeatureUtils.createKey("warm_ocean_vegetation");

    public static void bootstrap(BootstrapContext<WorldGenFeatureConfigured<?, ?>> var0) {
        FeatureUtils.register(var0, SEAGRASS_SHORT, WorldGenerator.SEAGRASS, new WorldGenFeatureConfigurationChance(0.3f));
        FeatureUtils.register(var0, SEAGRASS_SLIGHTLY_LESS_SHORT, WorldGenerator.SEAGRASS, new WorldGenFeatureConfigurationChance(0.4f));
        FeatureUtils.register(var0, SEAGRASS_MID, WorldGenerator.SEAGRASS, new WorldGenFeatureConfigurationChance(0.6f));
        FeatureUtils.register(var0, SEAGRASS_TALL, WorldGenerator.SEAGRASS, new WorldGenFeatureConfigurationChance(0.8f));
        FeatureUtils.register(var0, SEA_PICKLE, WorldGenerator.SEA_PICKLE, new WorldGenDecoratorFrequencyConfiguration(20));
        FeatureUtils.register(var0, SEAGRASS_SIMPLE, WorldGenerator.SIMPLE_BLOCK, new WorldGenFeatureBlockConfiguration(WorldGenFeatureStateProvider.simple(Blocks.SEAGRASS)));
        FeatureUtils.register(var0, KELP, WorldGenerator.KELP);
        FeatureUtils.register(var0, WARM_OCEAN_VEGETATION, WorldGenerator.SIMPLE_RANDOM_SELECTOR, new WorldGenFeatureRandom2(HolderSet.direct(PlacementUtils.inlinePlaced(WorldGenerator.CORAL_TREE, WorldGenFeatureConfiguration.NONE, new PlacementModifier[0]), PlacementUtils.inlinePlaced(WorldGenerator.CORAL_CLAW, WorldGenFeatureConfiguration.NONE, new PlacementModifier[0]), PlacementUtils.inlinePlaced(WorldGenerator.CORAL_MUSHROOM, WorldGenFeatureConfiguration.NONE, new PlacementModifier[0]))));
    }
}

