/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorPredicates;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestRandomBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTag;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestAxisAlignedLinear;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;

public class ProcessorLists {
    private static final ResourceKey<ProcessorList> EMPTY = ProcessorLists.createKey("empty");
    public static final ResourceKey<ProcessorList> ZOMBIE_PLAINS = ProcessorLists.createKey("zombie_plains");
    public static final ResourceKey<ProcessorList> ZOMBIE_SAVANNA = ProcessorLists.createKey("zombie_savanna");
    public static final ResourceKey<ProcessorList> ZOMBIE_SNOWY = ProcessorLists.createKey("zombie_snowy");
    public static final ResourceKey<ProcessorList> ZOMBIE_TAIGA = ProcessorLists.createKey("zombie_taiga");
    public static final ResourceKey<ProcessorList> ZOMBIE_DESERT = ProcessorLists.createKey("zombie_desert");
    public static final ResourceKey<ProcessorList> MOSSIFY_10_PERCENT = ProcessorLists.createKey("mossify_10_percent");
    public static final ResourceKey<ProcessorList> MOSSIFY_20_PERCENT = ProcessorLists.createKey("mossify_20_percent");
    public static final ResourceKey<ProcessorList> MOSSIFY_70_PERCENT = ProcessorLists.createKey("mossify_70_percent");
    public static final ResourceKey<ProcessorList> STREET_PLAINS = ProcessorLists.createKey("street_plains");
    public static final ResourceKey<ProcessorList> STREET_SAVANNA = ProcessorLists.createKey("street_savanna");
    public static final ResourceKey<ProcessorList> STREET_SNOWY_OR_TAIGA = ProcessorLists.createKey("street_snowy_or_taiga");
    public static final ResourceKey<ProcessorList> FARM_PLAINS = ProcessorLists.createKey("farm_plains");
    public static final ResourceKey<ProcessorList> FARM_SAVANNA = ProcessorLists.createKey("farm_savanna");
    public static final ResourceKey<ProcessorList> FARM_SNOWY = ProcessorLists.createKey("farm_snowy");
    public static final ResourceKey<ProcessorList> FARM_TAIGA = ProcessorLists.createKey("farm_taiga");
    public static final ResourceKey<ProcessorList> FARM_DESERT = ProcessorLists.createKey("farm_desert");
    public static final ResourceKey<ProcessorList> OUTPOST_ROT = ProcessorLists.createKey("outpost_rot");
    public static final ResourceKey<ProcessorList> BOTTOM_RAMPART = ProcessorLists.createKey("bottom_rampart");
    public static final ResourceKey<ProcessorList> TREASURE_ROOMS = ProcessorLists.createKey("treasure_rooms");
    public static final ResourceKey<ProcessorList> HOUSING = ProcessorLists.createKey("housing");
    public static final ResourceKey<ProcessorList> SIDE_WALL_DEGRADATION = ProcessorLists.createKey("side_wall_degradation");
    public static final ResourceKey<ProcessorList> STABLE_DEGRADATION = ProcessorLists.createKey("stable_degradation");
    public static final ResourceKey<ProcessorList> BASTION_GENERIC_DEGRADATION = ProcessorLists.createKey("bastion_generic_degradation");
    public static final ResourceKey<ProcessorList> RAMPART_DEGRADATION = ProcessorLists.createKey("rampart_degradation");
    public static final ResourceKey<ProcessorList> ENTRANCE_REPLACEMENT = ProcessorLists.createKey("entrance_replacement");
    public static final ResourceKey<ProcessorList> BRIDGE = ProcessorLists.createKey("bridge");
    public static final ResourceKey<ProcessorList> ROOF = ProcessorLists.createKey("roof");
    public static final ResourceKey<ProcessorList> HIGH_WALL = ProcessorLists.createKey("high_wall");
    public static final ResourceKey<ProcessorList> HIGH_RAMPART = ProcessorLists.createKey("high_rampart");
    public static final ResourceKey<ProcessorList> FOSSIL_ROT = ProcessorLists.createKey("fossil_rot");
    public static final ResourceKey<ProcessorList> FOSSIL_COAL = ProcessorLists.createKey("fossil_coal");
    public static final ResourceKey<ProcessorList> FOSSIL_DIAMONDS = ProcessorLists.createKey("fossil_diamonds");
    public static final ResourceKey<ProcessorList> ANCIENT_CITY_START_DEGRADATION = ProcessorLists.createKey("ancient_city_start_degradation");
    public static final ResourceKey<ProcessorList> ANCIENT_CITY_GENERIC_DEGRADATION = ProcessorLists.createKey("ancient_city_generic_degradation");
    public static final ResourceKey<ProcessorList> ANCIENT_CITY_WALLS_DEGRADATION = ProcessorLists.createKey("ancient_city_walls_degradation");
    public static final ResourceKey<ProcessorList> TRAIL_RUINS_HOUSES_ARCHAEOLOGY = ProcessorLists.createKey("trail_ruins_houses_archaeology");
    public static final ResourceKey<ProcessorList> TRAIL_RUINS_ROADS_ARCHAEOLOGY = ProcessorLists.createKey("trail_ruins_roads_archaeology");
    public static final ResourceKey<ProcessorList> TRAIL_RUINS_TOWER_TOP_ARCHAEOLOGY = ProcessorLists.createKey("trail_ruins_tower_top_archaeology");

    private static ResourceKey<ProcessorList> createKey(String var0) {
        return ResourceKey.create(Registries.PROCESSOR_LIST, new MinecraftKey(var0));
    }

    private static void register(BootstrapContext<ProcessorList> var0, ResourceKey<ProcessorList> var1, List<DefinedStructureProcessor> var2) {
        var0.register(var1, new ProcessorList(var2));
    }

    public static void bootstrap(BootstrapContext<ProcessorList> var0) {
        HolderGetter<Block> var1 = var0.lookup(Registries.BLOCK);
        DefinedStructureProcessorPredicates var2 = new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 0.01f), DefinedStructureTestTrue.INSTANCE, Blocks.GILDED_BLACKSTONE.defaultBlockState());
        DefinedStructureProcessorPredicates var3 = new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GILDED_BLACKSTONE, 0.5f), DefinedStructureTestTrue.INSTANCE, Blocks.BLACKSTONE.defaultBlockState());
        ProcessorLists.register(var0, EMPTY, (List<DefinedStructureProcessor>)ImmutableList.of());
        ProcessorLists.register(var0, ZOMBIE_PLAINS, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.8f), DefinedStructureTestTrue.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.DOORS), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.WALL_TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.07f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.MOSSY_COBBLESTONE, 0.07f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHITE_TERRACOTTA, 0.07f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.OAK_LOG, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.OAK_PLANKS, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.OAK_STAIRS, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.STRIPPED_OAK_LOG, 0.02f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GLASS_PANE, 0.5f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object[])new DefinedStructureProcessorPredicates[]{new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData)((IBlockData)Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData)((IBlockData)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData)((IBlockData)Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData)((IBlockData)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CARROTS.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.BEETROOTS.defaultBlockState())}))));
        ProcessorLists.register(var0, ZOMBIE_SAVANNA, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.DOORS), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.WALL_TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.ACACIA_PLANKS, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.ACACIA_STAIRS, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.ACACIA_LOG, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.ACACIA_WOOD, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.ORANGE_TERRACOTTA, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.YELLOW_TERRACOTTA, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.RED_TERRACOTTA, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GLASS_PANE, 0.5f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData)((IBlockData)Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData)((IBlockData)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), (Object[])new DefinedStructureProcessorPredicates[]{new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData)((IBlockData)Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData)((IBlockData)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.MELON_STEM.defaultBlockState())}))));
        ProcessorLists.register(var0, ZOMBIE_SNOWY, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.DOORS), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.WALL_TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.LANTERN), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SPRUCE_PLANKS, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SPRUCE_SLAB, 0.4f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.STRIPPED_SPRUCE_LOG, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.STRIPPED_SPRUCE_WOOD, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GLASS_PANE, 0.5f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData)((IBlockData)Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData)((IBlockData)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData)((IBlockData)Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData)((IBlockData)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.CARROTS.defaultBlockState()), (Object[])new DefinedStructureProcessorPredicates[]{new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.8f), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState())}))));
        ProcessorLists.register(var0, ZOMBIE_TAIGA, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.8f), DefinedStructureTestTrue.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.DOORS), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.WALL_TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.CAMPFIRE), DefinedStructureTestTrue.INSTANCE, (IBlockData)Blocks.CAMPFIRE.defaultBlockState().setValue(BlockCampfire.LIT, false)), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.08f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SPRUCE_LOG, 0.08f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GLASS_PANE, 0.5f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData)((IBlockData)Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData)((IBlockData)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlockState((IBlockData)((IBlockData)Blocks.GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), DefinedStructureTestTrue.INSTANCE, (IBlockData)((IBlockData)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true)), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.PUMPKIN_STEM.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState()), (Object[])new DefinedStructureProcessorPredicates[0]))));
        ProcessorLists.register(var0, ZOMBIE_DESERT, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.DOORS), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.WALL_TORCH), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SMOOTH_SANDSTONE, 0.08f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.CUT_SANDSTONE, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.TERRACOTTA, 0.08f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SMOOTH_SANDSTONE_STAIRS, 0.08f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SMOOTH_SANDSTONE_SLAB, 0.08f), DefinedStructureTestTrue.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.BEETROOTS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.MELON_STEM.defaultBlockState())))));
        ProcessorLists.register(var0, MOSSIFY_10_PERCENT, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState())))));
        ProcessorLists.register(var0, MOSSIFY_20_PERCENT, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState())))));
        ProcessorLists.register(var0, MOSSIFY_70_PERCENT, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.COBBLESTONE, 0.7f), DefinedStructureTestTrue.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState())))));
        ProcessorLists.register(var0, STREET_PLAINS, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT_PATH), new DefinedStructureTestBlock(Blocks.WATER), Blocks.OAK_PLANKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DIRT_PATH, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.GRASS_BLOCK.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.GRASS_BLOCK), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState())))));
        ProcessorLists.register(var0, STREET_SAVANNA, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT_PATH), new DefinedStructureTestBlock(Blocks.WATER), Blocks.ACACIA_PLANKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DIRT_PATH, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.GRASS_BLOCK.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.GRASS_BLOCK), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState())))));
        ProcessorLists.register(var0, STREET_SNOWY_OR_TAIGA, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT_PATH), new DefinedStructureTestBlock(Blocks.WATER), Blocks.SPRUCE_PLANKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT_PATH), new DefinedStructureTestBlock(Blocks.ICE), Blocks.SPRUCE_PLANKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DIRT_PATH, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.GRASS_BLOCK.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.GRASS_BLOCK), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.DIRT), new DefinedStructureTestBlock(Blocks.WATER), Blocks.WATER.defaultBlockState())))));
        ProcessorLists.register(var0, FARM_PLAINS, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CARROTS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.BEETROOTS.defaultBlockState())))));
        ProcessorLists.register(var0, FARM_SAVANNA, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.MELON_STEM.defaultBlockState())))));
        ProcessorLists.register(var0, FARM_SNOWY, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.CARROTS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.8f), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState())))));
        ProcessorLists.register(var0, FARM_TAIGA, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.PUMPKIN_STEM.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.POTATOES.defaultBlockState())))));
        ProcessorLists.register(var0, FARM_DESERT, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.BEETROOTS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.WHEAT, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.MELON_STEM.defaultBlockState())))));
        ProcessorLists.register(var0, OUTPOST_ROT, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRotation(0.05f)));
        ProcessorLists.register(var0, BOTTOM_RAMPART, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.MAGMA_BLOCK, 0.75f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS, 0.15f), DefinedStructureTestTrue.INSTANCE, Blocks.POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)var3, (Object)var2))));
        ProcessorLists.register(var0, TREASURE_ROOMS, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.35f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.CHISELED_POLISHED_BLACKSTONE, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)var3, (Object)var2))));
        ProcessorLists.register(var0, HOUSING, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 1.0E-4f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)var3, (Object)var2))));
        ProcessorLists.register(var0, SIDE_WALL_DEGRADATION, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.CHISELED_POLISHED_BLACKSTONE, 0.5f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GOLD_BLOCK, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)var3, (Object)var2))));
        ProcessorLists.register(var0, STABLE_DEGRADATION, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 1.0E-4f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)var3, (Object)var2))));
        ProcessorLists.register(var0, BASTION_GENERIC_DEGRADATION, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 1.0E-4f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GOLD_BLOCK, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)var3, (Object)var2))));
        ProcessorLists.register(var0, RAMPART_DEGRADATION, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.4f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 0.01f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 1.0E-4f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 1.0E-4f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GOLD_BLOCK, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)var3, (Object)var2))));
        ProcessorLists.register(var0, ENTRANCE_REPLACEMENT, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.CHISELED_POLISHED_BLACKSTONE, 0.5f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GOLD_BLOCK, 0.6f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)var3, (Object)var2))));
        ProcessorLists.register(var0, BRIDGE, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.BLACKSTONE, 1.0E-4f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState())))));
        ProcessorLists.register(var0, ROOF, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.15f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.BLACKSTONE.defaultBlockState())))));
        ProcessorLists.register(var0, HIGH_WALL, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.01f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.5f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.BLACKSTONE.defaultBlockState()), (Object)var3))));
        ProcessorLists.register(var0, HIGH_RAMPART, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GOLD_BLOCK, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(DefinedStructureTestTrue.INSTANCE, DefinedStructureTestTrue.INSTANCE, new PosRuleTestAxisAlignedLinear(0.0f, 0.05f, 0, 100, EnumDirection.EnumAxis.Y), Blocks.AIR.defaultBlockState()), (Object)var3))));
        ProcessorLists.register(var0, FOSSIL_ROT, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRotation(0.9f), (Object)new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register(var0, FOSSIL_COAL, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRotation(0.1f), (Object)new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register(var0, FOSSIL_DIAMONDS, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRotation(0.1f), (Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(Blocks.COAL_ORE), DefinedStructureTestTrue.INSTANCE, Blocks.DEEPSLATE_DIAMOND_ORE.defaultBlockState()))), (Object)new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register(var0, ANCIENT_CITY_START_DEGRADATION, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_BRICKS, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_TILES, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SOUL_LANTERN, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()))), (Object)new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register(var0, ANCIENT_CITY_GENERIC_DEGRADATION, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRotation(var1.getOrThrow(TagsBlock.ANCIENT_CITY_REPLACEABLE), 0.95f), (Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_BRICKS, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_TILES, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SOUL_LANTERN, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()))), (Object)new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register(var0, ANCIENT_CITY_WALLS_DEGRADATION, (List<DefinedStructureProcessor>)ImmutableList.of((Object)new DefinedStructureProcessorRotation(var1.getOrThrow(TagsBlock.ANCIENT_CITY_REPLACEABLE), 0.95f), (Object)new DefinedStructureProcessorRule((List<? extends DefinedStructureProcessorPredicates>)ImmutableList.of((Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_BRICKS, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_TILES, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.DEEPSLATE_TILE_SLAB, 0.3f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.SOUL_LANTERN, 0.05f), DefinedStructureTestTrue.INSTANCE, Blocks.AIR.defaultBlockState()))), (Object)new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register(var0, TRAIL_RUINS_HOUSES_ARCHAEOLOGY, List.of(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GRAVEL, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.DIRT.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GRAVEL, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.COARSE_DIRT.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.MUD_BRICKS, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.PACKED_MUD.defaultBlockState()))), ProcessorLists.trailsArchyLootProcessor(LootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, 6), ProcessorLists.trailsArchyLootProcessor(LootTables.TRAIL_RUINS_ARCHAEOLOGY_RARE, 3)));
        ProcessorLists.register(var0, TRAIL_RUINS_ROADS_ARCHAEOLOGY, List.of(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GRAVEL, 0.2f), DefinedStructureTestTrue.INSTANCE, Blocks.DIRT.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.GRAVEL, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.COARSE_DIRT.defaultBlockState()), new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(Blocks.MUD_BRICKS, 0.1f), DefinedStructureTestTrue.INSTANCE, Blocks.PACKED_MUD.defaultBlockState()))), ProcessorLists.trailsArchyLootProcessor(LootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, 2)));
        ProcessorLists.register(var0, TRAIL_RUINS_TOWER_TOP_ARCHAEOLOGY, List.of(ProcessorLists.trailsArchyLootProcessor(LootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, 2)));
    }

    private static CappedProcessor trailsArchyLootProcessor(ResourceKey<LootTable> var0, int var1) {
        return new CappedProcessor(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestTag(TagsBlock.TRAIL_RUINS_REPLACEABLE), DefinedStructureTestTrue.INSTANCE, PosRuleTestTrue.INSTANCE, Blocks.SUSPICIOUS_GRAVEL.defaultBlockState(), new AppendLoot(var0)))), ConstantInt.of(var1));
    }
}

