/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class Particles {
    public static final ParticleType ANGRY_VILLAGER = Particles.register("angry_villager", false);
    public static final Particle<ParticleParamBlock> BLOCK = Particles.register("block", false, ParticleParamBlock::codec, ParticleParamBlock::streamCodec);
    public static final Particle<ParticleParamBlock> BLOCK_MARKER = Particles.register("block_marker", true, ParticleParamBlock::codec, ParticleParamBlock::streamCodec);
    public static final ParticleType BUBBLE = Particles.register("bubble", false);
    public static final ParticleType CLOUD = Particles.register("cloud", false);
    public static final ParticleType CRIT = Particles.register("crit", false);
    public static final ParticleType DAMAGE_INDICATOR = Particles.register("damage_indicator", true);
    public static final ParticleType DRAGON_BREATH = Particles.register("dragon_breath", false);
    public static final ParticleType DRIPPING_LAVA = Particles.register("dripping_lava", false);
    public static final ParticleType FALLING_LAVA = Particles.register("falling_lava", false);
    public static final ParticleType LANDING_LAVA = Particles.register("landing_lava", false);
    public static final ParticleType DRIPPING_WATER = Particles.register("dripping_water", false);
    public static final ParticleType FALLING_WATER = Particles.register("falling_water", false);
    public static final Particle<ParticleParamRedstone> DUST = Particles.register("dust", false, var0 -> ParticleParamRedstone.CODEC, var0 -> ParticleParamRedstone.STREAM_CODEC);
    public static final Particle<DustColorTransitionOptions> DUST_COLOR_TRANSITION = Particles.register("dust_color_transition", false, var0 -> DustColorTransitionOptions.CODEC, var0 -> DustColorTransitionOptions.STREAM_CODEC);
    public static final ParticleType EFFECT = Particles.register("effect", false);
    public static final ParticleType ELDER_GUARDIAN = Particles.register("elder_guardian", true);
    public static final ParticleType ENCHANTED_HIT = Particles.register("enchanted_hit", false);
    public static final ParticleType ENCHANT = Particles.register("enchant", false);
    public static final ParticleType END_ROD = Particles.register("end_rod", false);
    public static final Particle<ColorParticleOption> ENTITY_EFFECT = Particles.register("entity_effect", false, ColorParticleOption::codec, ColorParticleOption::streamCodec);
    public static final ParticleType EXPLOSION_EMITTER = Particles.register("explosion_emitter", true);
    public static final ParticleType EXPLOSION = Particles.register("explosion", true);
    public static final ParticleType GUST = Particles.register("gust", true);
    public static final ParticleType SMALL_GUST = Particles.register("small_gust", false);
    public static final ParticleType GUST_EMITTER_LARGE = Particles.register("gust_emitter_large", true);
    public static final ParticleType GUST_EMITTER_SMALL = Particles.register("gust_emitter_small", true);
    public static final ParticleType SONIC_BOOM = Particles.register("sonic_boom", true);
    public static final Particle<ParticleParamBlock> FALLING_DUST = Particles.register("falling_dust", false, ParticleParamBlock::codec, ParticleParamBlock::streamCodec);
    public static final ParticleType FIREWORK = Particles.register("firework", false);
    public static final ParticleType FISHING = Particles.register("fishing", false);
    public static final ParticleType FLAME = Particles.register("flame", false);
    public static final ParticleType INFESTED = Particles.register("infested", false);
    public static final ParticleType CHERRY_LEAVES = Particles.register("cherry_leaves", false);
    public static final ParticleType SCULK_SOUL = Particles.register("sculk_soul", false);
    public static final Particle<SculkChargeParticleOptions> SCULK_CHARGE = Particles.register("sculk_charge", true, var0 -> SculkChargeParticleOptions.CODEC, var0 -> SculkChargeParticleOptions.STREAM_CODEC);
    public static final ParticleType SCULK_CHARGE_POP = Particles.register("sculk_charge_pop", true);
    public static final ParticleType SOUL_FIRE_FLAME = Particles.register("soul_fire_flame", false);
    public static final ParticleType SOUL = Particles.register("soul", false);
    public static final ParticleType FLASH = Particles.register("flash", false);
    public static final ParticleType HAPPY_VILLAGER = Particles.register("happy_villager", false);
    public static final ParticleType COMPOSTER = Particles.register("composter", false);
    public static final ParticleType HEART = Particles.register("heart", false);
    public static final ParticleType INSTANT_EFFECT = Particles.register("instant_effect", false);
    public static final Particle<ParticleParamItem> ITEM = Particles.register("item", false, ParticleParamItem::codec, ParticleParamItem::streamCodec);
    public static final Particle<VibrationParticleOption> VIBRATION = Particles.register("vibration", true, var0 -> VibrationParticleOption.CODEC, var0 -> VibrationParticleOption.STREAM_CODEC);
    public static final ParticleType ITEM_SLIME = Particles.register("item_slime", false);
    public static final ParticleType ITEM_COBWEB = Particles.register("item_cobweb", false);
    public static final ParticleType ITEM_SNOWBALL = Particles.register("item_snowball", false);
    public static final ParticleType LARGE_SMOKE = Particles.register("large_smoke", false);
    public static final ParticleType LAVA = Particles.register("lava", false);
    public static final ParticleType MYCELIUM = Particles.register("mycelium", false);
    public static final ParticleType NOTE = Particles.register("note", false);
    public static final ParticleType POOF = Particles.register("poof", true);
    public static final ParticleType PORTAL = Particles.register("portal", false);
    public static final ParticleType RAIN = Particles.register("rain", false);
    public static final ParticleType SMOKE = Particles.register("smoke", false);
    public static final ParticleType WHITE_SMOKE = Particles.register("white_smoke", false);
    public static final ParticleType SNEEZE = Particles.register("sneeze", false);
    public static final ParticleType SPIT = Particles.register("spit", true);
    public static final ParticleType SQUID_INK = Particles.register("squid_ink", true);
    public static final ParticleType SWEEP_ATTACK = Particles.register("sweep_attack", true);
    public static final ParticleType TOTEM_OF_UNDYING = Particles.register("totem_of_undying", false);
    public static final ParticleType UNDERWATER = Particles.register("underwater", false);
    public static final ParticleType SPLASH = Particles.register("splash", false);
    public static final ParticleType WITCH = Particles.register("witch", false);
    public static final ParticleType BUBBLE_POP = Particles.register("bubble_pop", false);
    public static final ParticleType CURRENT_DOWN = Particles.register("current_down", false);
    public static final ParticleType BUBBLE_COLUMN_UP = Particles.register("bubble_column_up", false);
    public static final ParticleType NAUTILUS = Particles.register("nautilus", false);
    public static final ParticleType DOLPHIN = Particles.register("dolphin", false);
    public static final ParticleType CAMPFIRE_COSY_SMOKE = Particles.register("campfire_cosy_smoke", true);
    public static final ParticleType CAMPFIRE_SIGNAL_SMOKE = Particles.register("campfire_signal_smoke", true);
    public static final ParticleType DRIPPING_HONEY = Particles.register("dripping_honey", false);
    public static final ParticleType FALLING_HONEY = Particles.register("falling_honey", false);
    public static final ParticleType LANDING_HONEY = Particles.register("landing_honey", false);
    public static final ParticleType FALLING_NECTAR = Particles.register("falling_nectar", false);
    public static final ParticleType FALLING_SPORE_BLOSSOM = Particles.register("falling_spore_blossom", false);
    public static final ParticleType ASH = Particles.register("ash", false);
    public static final ParticleType CRIMSON_SPORE = Particles.register("crimson_spore", false);
    public static final ParticleType WARPED_SPORE = Particles.register("warped_spore", false);
    public static final ParticleType SPORE_BLOSSOM_AIR = Particles.register("spore_blossom_air", false);
    public static final ParticleType DRIPPING_OBSIDIAN_TEAR = Particles.register("dripping_obsidian_tear", false);
    public static final ParticleType FALLING_OBSIDIAN_TEAR = Particles.register("falling_obsidian_tear", false);
    public static final ParticleType LANDING_OBSIDIAN_TEAR = Particles.register("landing_obsidian_tear", false);
    public static final ParticleType REVERSE_PORTAL = Particles.register("reverse_portal", false);
    public static final ParticleType WHITE_ASH = Particles.register("white_ash", false);
    public static final ParticleType SMALL_FLAME = Particles.register("small_flame", false);
    public static final ParticleType SNOWFLAKE = Particles.register("snowflake", false);
    public static final ParticleType DRIPPING_DRIPSTONE_LAVA = Particles.register("dripping_dripstone_lava", false);
    public static final ParticleType FALLING_DRIPSTONE_LAVA = Particles.register("falling_dripstone_lava", false);
    public static final ParticleType DRIPPING_DRIPSTONE_WATER = Particles.register("dripping_dripstone_water", false);
    public static final ParticleType FALLING_DRIPSTONE_WATER = Particles.register("falling_dripstone_water", false);
    public static final ParticleType GLOW_SQUID_INK = Particles.register("glow_squid_ink", true);
    public static final ParticleType GLOW = Particles.register("glow", true);
    public static final ParticleType WAX_ON = Particles.register("wax_on", true);
    public static final ParticleType WAX_OFF = Particles.register("wax_off", true);
    public static final ParticleType ELECTRIC_SPARK = Particles.register("electric_spark", true);
    public static final ParticleType SCRAPE = Particles.register("scrape", true);
    public static final Particle<ShriekParticleOption> SHRIEK = Particles.register("shriek", false, var0 -> ShriekParticleOption.CODEC, var0 -> ShriekParticleOption.STREAM_CODEC);
    public static final ParticleType EGG_CRACK = Particles.register("egg_crack", false);
    public static final ParticleType DUST_PLUME = Particles.register("dust_plume", false);
    public static final ParticleType TRIAL_SPAWNER_DETECTED_PLAYER = Particles.register("trial_spawner_detection", true);
    public static final ParticleType TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS = Particles.register("trial_spawner_detection_ominous", true);
    public static final ParticleType VAULT_CONNECTION = Particles.register("vault_connection", true);
    public static final Particle<ParticleParamBlock> DUST_PILLAR = Particles.register("dust_pillar", true, ParticleParamBlock::codec, ParticleParamBlock::streamCodec);
    public static final ParticleType OMINOUS_SPAWNING = Particles.register("ominous_spawning", true);
    public static final ParticleType RAID_OMEN = Particles.register("raid_omen", false);
    public static final ParticleType TRIAL_OMEN = Particles.register("trial_omen", false);
    public static final Codec<ParticleParam> CODEC = BuiltInRegistries.PARTICLE_TYPE.byNameCodec().dispatch("type", ParticleParam::getType, Particle::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, ParticleParam> STREAM_CODEC = ByteBufCodecs.registry(Registries.PARTICLE_TYPE).dispatch(ParticleParam::getType, Particle::streamCodec);

    private static ParticleType register(String var0, boolean var1) {
        return IRegistry.register(BuiltInRegistries.PARTICLE_TYPE, var0, new ParticleType(var1));
    }

    private static <T extends ParticleParam> Particle<T> register(String var0, boolean var1, final Function<Particle<T>, MapCodec<T>> var2, final Function<Particle<T>, StreamCodec<? super RegistryFriendlyByteBuf, T>> var3) {
        return IRegistry.register(BuiltInRegistries.PARTICLE_TYPE, var0, new Particle<T>(var1){

            @Override
            public MapCodec<T> codec() {
                return (MapCodec)var2.apply(this);
            }

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return (StreamCodec)var3.apply(this);
            }
        });
    }
}

