/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.AbstractIterator;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Immutable
public class BlockPosition
extends BaseBlockPosition {
    public static final Codec<BlockPosition> CODEC = Codec.INT_STREAM.comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 3).map(var0 -> new BlockPosition(var0[0], var0[1], var0[2])), var0 -> IntStream.of(var0.getX(), var0.getY(), var0.getZ())).stable();
    public static final StreamCodec<ByteBuf, BlockPosition> STREAM_CODEC = new StreamCodec<ByteBuf, BlockPosition>(){

        @Override
        public BlockPosition decode(ByteBuf var0) {
            return PacketDataSerializer.readBlockPos(var0);
        }

        @Override
        public void encode(ByteBuf var0, BlockPosition var1) {
            PacketDataSerializer.writeBlockPos(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (BlockPosition)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BlockPosition ZERO = new BlockPosition(0, 0, 0);
    private static final int PACKED_X_LENGTH;
    private static final int PACKED_Z_LENGTH;
    public static final int PACKED_Y_LENGTH;
    private static final long PACKED_X_MASK;
    private static final long PACKED_Y_MASK;
    private static final long PACKED_Z_MASK;
    private static final int Y_OFFSET = 0;
    private static final int Z_OFFSET;
    private static final int X_OFFSET;

    public BlockPosition(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    public BlockPosition(BaseBlockPosition var0) {
        this(var0.getX(), var0.getY(), var0.getZ());
    }

    public static long offset(long var0, EnumDirection var2) {
        return BlockPosition.offset(var0, var2.getStepX(), var2.getStepY(), var2.getStepZ());
    }

    public static long offset(long var0, int var2, int var3, int var4) {
        return BlockPosition.asLong(BlockPosition.getX(var0) + var2, BlockPosition.getY(var0) + var3, BlockPosition.getZ(var0) + var4);
    }

    public static int getX(long var0) {
        return (int)(var0 << 64 - X_OFFSET - PACKED_X_LENGTH >> 64 - PACKED_X_LENGTH);
    }

    public static int getY(long var0) {
        return (int)(var0 << 64 - PACKED_Y_LENGTH >> 64 - PACKED_Y_LENGTH);
    }

    public static int getZ(long var0) {
        return (int)(var0 << 64 - Z_OFFSET - PACKED_Z_LENGTH >> 64 - PACKED_Z_LENGTH);
    }

    public static BlockPosition of(long var0) {
        return new BlockPosition(BlockPosition.getX(var0), BlockPosition.getY(var0), BlockPosition.getZ(var0));
    }

    public static BlockPosition containing(double var0, double var2, double var4) {
        return new BlockPosition(MathHelper.floor(var0), MathHelper.floor(var2), MathHelper.floor(var4));
    }

    public static BlockPosition containing(IPosition var0) {
        return BlockPosition.containing(var0.x(), var0.y(), var0.z());
    }

    public static BlockPosition min(BlockPosition var0, BlockPosition var1) {
        return new BlockPosition(Math.min(var0.getX(), var1.getX()), Math.min(var0.getY(), var1.getY()), Math.min(var0.getZ(), var1.getZ()));
    }

    public static BlockPosition max(BlockPosition var0, BlockPosition var1) {
        return new BlockPosition(Math.max(var0.getX(), var1.getX()), Math.max(var0.getY(), var1.getY()), Math.max(var0.getZ(), var1.getZ()));
    }

    public long asLong() {
        return BlockPosition.asLong(this.getX(), this.getY(), this.getZ());
    }

    public static long asLong(int var0, int var1, int var2) {
        long var3 = 0L;
        var3 |= ((long)var0 & PACKED_X_MASK) << X_OFFSET;
        var3 |= ((long)var1 & PACKED_Y_MASK) << 0;
        return var3 |= ((long)var2 & PACKED_Z_MASK) << Z_OFFSET;
    }

    public static long getFlatIndex(long var0) {
        return var0 & 0xFFFFFFFFFFFFFFF0L;
    }

    @Override
    public BlockPosition offset(int var0, int var1, int var2) {
        if (var0 == 0 && var1 == 0 && var2 == 0) {
            return this;
        }
        return new BlockPosition(this.getX() + var0, this.getY() + var1, this.getZ() + var2);
    }

    public Vec3D getCenter() {
        return Vec3D.atCenterOf(this);
    }

    @Override
    public BlockPosition offset(BaseBlockPosition var0) {
        return this.offset(var0.getX(), var0.getY(), var0.getZ());
    }

    @Override
    public BlockPosition subtract(BaseBlockPosition var0) {
        return this.offset(-var0.getX(), -var0.getY(), -var0.getZ());
    }

    @Override
    public BlockPosition multiply(int var0) {
        if (var0 == 1) {
            return this;
        }
        if (var0 == 0) {
            return ZERO;
        }
        return new BlockPosition(this.getX() * var0, this.getY() * var0, this.getZ() * var0);
    }

    @Override
    public BlockPosition above() {
        return this.relative(EnumDirection.UP);
    }

    @Override
    public BlockPosition above(int var0) {
        return this.relative(EnumDirection.UP, var0);
    }

    @Override
    public BlockPosition below() {
        return this.relative(EnumDirection.DOWN);
    }

    @Override
    public BlockPosition below(int var0) {
        return this.relative(EnumDirection.DOWN, var0);
    }

    @Override
    public BlockPosition north() {
        return this.relative(EnumDirection.NORTH);
    }

    @Override
    public BlockPosition north(int var0) {
        return this.relative(EnumDirection.NORTH, var0);
    }

    @Override
    public BlockPosition south() {
        return this.relative(EnumDirection.SOUTH);
    }

    @Override
    public BlockPosition south(int var0) {
        return this.relative(EnumDirection.SOUTH, var0);
    }

    @Override
    public BlockPosition west() {
        return this.relative(EnumDirection.WEST);
    }

    @Override
    public BlockPosition west(int var0) {
        return this.relative(EnumDirection.WEST, var0);
    }

    @Override
    public BlockPosition east() {
        return this.relative(EnumDirection.EAST);
    }

    @Override
    public BlockPosition east(int var0) {
        return this.relative(EnumDirection.EAST, var0);
    }

    @Override
    public BlockPosition relative(EnumDirection var0) {
        return new BlockPosition(this.getX() + var0.getStepX(), this.getY() + var0.getStepY(), this.getZ() + var0.getStepZ());
    }

    @Override
    public BlockPosition relative(EnumDirection var0, int var1) {
        if (var1 == 0) {
            return this;
        }
        return new BlockPosition(this.getX() + var0.getStepX() * var1, this.getY() + var0.getStepY() * var1, this.getZ() + var0.getStepZ() * var1);
    }

    @Override
    public BlockPosition relative(EnumDirection.EnumAxis var0, int var1) {
        if (var1 == 0) {
            return this;
        }
        int var2 = var0 == EnumDirection.EnumAxis.X ? var1 : 0;
        int var3 = var0 == EnumDirection.EnumAxis.Y ? var1 : 0;
        int var4 = var0 == EnumDirection.EnumAxis.Z ? var1 : 0;
        return new BlockPosition(this.getX() + var2, this.getY() + var3, this.getZ() + var4);
    }

    public BlockPosition rotate(EnumBlockRotation var0) {
        switch (var0) {
            default: {
                return this;
            }
            case CLOCKWISE_90: {
                return new BlockPosition(-this.getZ(), this.getY(), this.getX());
            }
            case CLOCKWISE_180: {
                return new BlockPosition(-this.getX(), this.getY(), -this.getZ());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new BlockPosition(this.getZ(), this.getY(), -this.getX());
    }

    @Override
    public BlockPosition cross(BaseBlockPosition var0) {
        return new BlockPosition(this.getY() * var0.getZ() - this.getZ() * var0.getY(), this.getZ() * var0.getX() - this.getX() * var0.getZ(), this.getX() * var0.getY() - this.getY() * var0.getX());
    }

    public BlockPosition atY(int var0) {
        return new BlockPosition(this.getX(), var0, this.getZ());
    }

    public BlockPosition immutable() {
        return this;
    }

    public MutableBlockPosition mutable() {
        return new MutableBlockPosition(this.getX(), this.getY(), this.getZ());
    }

    public static Iterable<BlockPosition> randomInCube(RandomSource var0, int var1, BlockPosition var2, int var3) {
        return BlockPosition.randomBetweenClosed(var0, var1, var2.getX() - var3, var2.getY() - var3, var2.getZ() - var3, var2.getX() + var3, var2.getY() + var3, var2.getZ() + var3);
    }

    @Deprecated
    public static Stream<BlockPosition> squareOutSouthEast(BlockPosition var0) {
        return Stream.of(var0, var0.south(), var0.east(), var0.south().east());
    }

    public static Iterable<BlockPosition> randomBetweenClosed(final RandomSource var0, final int var1, final int var2, final int var3, final int var4, int var5, int var6, int var7) {
        final int var8 = var5 - var2 + 1;
        final int var9 = var6 - var3 + 1;
        final int var10 = var7 - var4 + 1;
        return () -> new AbstractIterator<BlockPosition>(){
            final MutableBlockPosition nextPos = new MutableBlockPosition();
            int counter = var1;

            protected BlockPosition computeNext() {
                if (this.counter <= 0) {
                    return (BlockPosition)this.endOfData();
                }
                MutableBlockPosition var02 = this.nextPos.set(var2 + var0.nextInt(var8), var3 + var0.nextInt(var9), var4 + var0.nextInt(var10));
                --this.counter;
                return var02;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Iterable<BlockPosition> withinManhattan(BlockPosition var0, final int var1, final int var2, final int var3) {
        final int var4 = var1 + var2 + var3;
        final int var5 = var0.getX();
        final int var6 = var0.getY();
        final int var7 = var0.getZ();
        return () -> new AbstractIterator<BlockPosition>(){
            private final MutableBlockPosition cursor = new MutableBlockPosition();
            private int currentDepth;
            private int maxX;
            private int maxY;
            private int x;
            private int y;
            private boolean zMirror;

            protected BlockPosition computeNext() {
                if (this.zMirror) {
                    this.zMirror = false;
                    this.cursor.setZ(var7 - (this.cursor.getZ() - var7));
                    return this.cursor;
                }
                MutableBlockPosition var0 = null;
                while (var0 == null) {
                    if (this.y > this.maxY) {
                        ++this.x;
                        if (this.x > this.maxX) {
                            ++this.currentDepth;
                            if (this.currentDepth > var4) {
                                return (BlockPosition)this.endOfData();
                            }
                            this.maxX = Math.min(var1, this.currentDepth);
                            this.x = -this.maxX;
                        }
                        this.maxY = Math.min(var2, this.currentDepth - Math.abs(this.x));
                        this.y = -this.maxY;
                    }
                    int var12 = this.x;
                    int var22 = this.y;
                    int var32 = this.currentDepth - Math.abs(var12) - Math.abs(var22);
                    if (var32 <= var3) {
                        this.zMirror = var32 != 0;
                        var0 = this.cursor.set(var5 + var12, var6 + var22, var7 + var32);
                    }
                    ++this.y;
                }
                return var0;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Optional<BlockPosition> findClosestMatch(BlockPosition var0, int var1, int var2, Predicate<BlockPosition> var3) {
        for (BlockPosition var5 : BlockPosition.withinManhattan(var0, var1, var2, var1)) {
            if (!var3.test(var5)) continue;
            return Optional.of(var5);
        }
        return Optional.empty();
    }

    public static Stream<BlockPosition> withinManhattanStream(BlockPosition var0, int var1, int var2, int var3) {
        return StreamSupport.stream(BlockPosition.withinManhattan(var0, var1, var2, var3).spliterator(), false);
    }

    public static Iterable<BlockPosition> betweenClosed(BlockPosition var0, BlockPosition var1) {
        return BlockPosition.betweenClosed(Math.min(var0.getX(), var1.getX()), Math.min(var0.getY(), var1.getY()), Math.min(var0.getZ(), var1.getZ()), Math.max(var0.getX(), var1.getX()), Math.max(var0.getY(), var1.getY()), Math.max(var0.getZ(), var1.getZ()));
    }

    public static Stream<BlockPosition> betweenClosedStream(BlockPosition var0, BlockPosition var1) {
        return StreamSupport.stream(BlockPosition.betweenClosed(var0, var1).spliterator(), false);
    }

    public static Stream<BlockPosition> betweenClosedStream(StructureBoundingBox var0) {
        return BlockPosition.betweenClosedStream(Math.min(var0.minX(), var0.maxX()), Math.min(var0.minY(), var0.maxY()), Math.min(var0.minZ(), var0.maxZ()), Math.max(var0.minX(), var0.maxX()), Math.max(var0.minY(), var0.maxY()), Math.max(var0.minZ(), var0.maxZ()));
    }

    public static Stream<BlockPosition> betweenClosedStream(AxisAlignedBB var0) {
        return BlockPosition.betweenClosedStream(MathHelper.floor(var0.minX), MathHelper.floor(var0.minY), MathHelper.floor(var0.minZ), MathHelper.floor(var0.maxX), MathHelper.floor(var0.maxY), MathHelper.floor(var0.maxZ));
    }

    public static Stream<BlockPosition> betweenClosedStream(int var0, int var1, int var2, int var3, int var4, int var5) {
        return StreamSupport.stream(BlockPosition.betweenClosed(var0, var1, var2, var3, var4, var5).spliterator(), false);
    }

    public static Iterable<BlockPosition> betweenClosed(final int var0, final int var1, final int var2, int var3, int var4, int var5) {
        final int var6 = var3 - var0 + 1;
        final int var7 = var4 - var1 + 1;
        int var8 = var5 - var2 + 1;
        final int var9 = var6 * var7 * var8;
        return () -> new AbstractIterator<BlockPosition>(){
            private final MutableBlockPosition cursor = new MutableBlockPosition();
            private int index;

            protected BlockPosition computeNext() {
                if (this.index == var9) {
                    return (BlockPosition)this.endOfData();
                }
                int var02 = this.index % var6;
                int var12 = this.index / var6;
                int var22 = var12 % var7;
                int var3 = var12 / var7;
                ++this.index;
                return this.cursor.set(var0 + var02, var1 + var22, var2 + var3);
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Iterable<MutableBlockPosition> spiralAround(final BlockPosition var0, final int var1, final EnumDirection var2, final EnumDirection var3) {
        Validate.validState((var2.getAxis() != var3.getAxis() ? 1 : 0) != 0, (String)"The two directions cannot be on the same axis", (Object[])new Object[0]);
        return () -> new AbstractIterator<MutableBlockPosition>(){
            private final EnumDirection[] directions;
            private final MutableBlockPosition cursor;
            private final int legs;
            private int leg;
            private int legSize;
            private int legIndex;
            private int lastX;
            private int lastY;
            private int lastZ;
            {
                this.directions = new EnumDirection[]{var2, var3, var2.getOpposite(), var3.getOpposite()};
                this.cursor = var0.mutable().move(var3);
                this.legs = 4 * var1;
                this.leg = -1;
                this.lastX = this.cursor.getX();
                this.lastY = this.cursor.getY();
                this.lastZ = this.cursor.getZ();
            }

            protected MutableBlockPosition computeNext() {
                this.cursor.set(this.lastX, this.lastY, this.lastZ).move(this.directions[(this.leg + 4) % 4]);
                this.lastX = this.cursor.getX();
                this.lastY = this.cursor.getY();
                this.lastZ = this.cursor.getZ();
                if (this.legIndex >= this.legSize) {
                    if (this.leg >= this.legs) {
                        return (MutableBlockPosition)this.endOfData();
                    }
                    ++this.leg;
                    this.legIndex = 0;
                    this.legSize = this.leg / 2 + 1;
                }
                ++this.legIndex;
                return this.cursor;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static int breadthFirstTraversal(BlockPosition var0, int var1, int var22, BiConsumer<BlockPosition, Consumer<BlockPosition>> var3, Predicate<BlockPosition> var4) {
        ArrayDeque<Pair> var5 = new ArrayDeque<Pair>();
        LongOpenHashSet var6 = new LongOpenHashSet();
        var5.add(Pair.of((Object)var0, (Object)0));
        int var7 = 0;
        while (!var5.isEmpty()) {
            Pair var8 = (Pair)var5.poll();
            BlockPosition var9 = (BlockPosition)var8.getLeft();
            int var10 = (Integer)var8.getRight();
            long var11 = var9.asLong();
            if (!var6.add(var11) || !var4.test(var9)) continue;
            if (++var7 >= var22) {
                return var7;
            }
            if (var10 >= var1) continue;
            var3.accept(var9, var2 -> var5.add(Pair.of((Object)var2, (Object)(var10 + 1))));
        }
        return var7;
    }

    @Override
    public /* synthetic */ BaseBlockPosition cross(BaseBlockPosition baseBlockPosition) {
        return this.cross(baseBlockPosition);
    }

    @Override
    public /* synthetic */ BaseBlockPosition relative(EnumDirection.EnumAxis enumAxis, int n2) {
        return this.relative(enumAxis, n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition relative(EnumDirection enumDirection, int n2) {
        return this.relative(enumDirection, n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition relative(EnumDirection enumDirection) {
        return this.relative(enumDirection);
    }

    @Override
    public /* synthetic */ BaseBlockPosition east(int n2) {
        return this.east(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition east() {
        return this.east();
    }

    @Override
    public /* synthetic */ BaseBlockPosition west(int n2) {
        return this.west(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition west() {
        return this.west();
    }

    @Override
    public /* synthetic */ BaseBlockPosition south(int n2) {
        return this.south(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition south() {
        return this.south();
    }

    @Override
    public /* synthetic */ BaseBlockPosition north(int n2) {
        return this.north(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition north() {
        return this.north();
    }

    @Override
    public /* synthetic */ BaseBlockPosition below(int n2) {
        return this.below(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition below() {
        return this.below();
    }

    @Override
    public /* synthetic */ BaseBlockPosition above(int n2) {
        return this.above(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition above() {
        return this.above();
    }

    @Override
    public /* synthetic */ BaseBlockPosition multiply(int n2) {
        return this.multiply(n2);
    }

    @Override
    public /* synthetic */ BaseBlockPosition subtract(BaseBlockPosition baseBlockPosition) {
        return this.subtract(baseBlockPosition);
    }

    @Override
    public /* synthetic */ BaseBlockPosition offset(BaseBlockPosition baseBlockPosition) {
        return this.offset(baseBlockPosition);
    }

    @Override
    public /* synthetic */ BaseBlockPosition offset(int n2, int n3, int n4) {
        return this.offset(n2, n3, n4);
    }

    static {
        PACKED_Z_LENGTH = PACKED_X_LENGTH = 1 + MathHelper.log2(MathHelper.smallestEncompassingPowerOfTwo(30000000));
        PACKED_Y_LENGTH = 64 - PACKED_X_LENGTH - PACKED_Z_LENGTH;
        PACKED_X_MASK = (1L << PACKED_X_LENGTH) - 1L;
        PACKED_Y_MASK = (1L << PACKED_Y_LENGTH) - 1L;
        PACKED_Z_MASK = (1L << PACKED_Z_LENGTH) - 1L;
        Z_OFFSET = PACKED_Y_LENGTH;
        X_OFFSET = PACKED_Y_LENGTH + PACKED_Z_LENGTH;
    }

    public static class MutableBlockPosition
    extends BlockPosition {
        public MutableBlockPosition() {
            this(0, 0, 0);
        }

        public MutableBlockPosition(int var0, int var1, int var2) {
            super(var0, var1, var2);
        }

        public MutableBlockPosition(double var0, double var2, double var4) {
            this(MathHelper.floor(var0), MathHelper.floor(var2), MathHelper.floor(var4));
        }

        @Override
        public BlockPosition offset(int var0, int var1, int var2) {
            return super.offset(var0, var1, var2).immutable();
        }

        @Override
        public BlockPosition multiply(int var0) {
            return super.multiply(var0).immutable();
        }

        @Override
        public BlockPosition relative(EnumDirection var0, int var1) {
            return super.relative(var0, var1).immutable();
        }

        @Override
        public BlockPosition relative(EnumDirection.EnumAxis var0, int var1) {
            return super.relative(var0, var1).immutable();
        }

        @Override
        public BlockPosition rotate(EnumBlockRotation var0) {
            return super.rotate(var0).immutable();
        }

        public MutableBlockPosition set(int var0, int var1, int var2) {
            this.setX(var0);
            this.setY(var1);
            this.setZ(var2);
            return this;
        }

        public MutableBlockPosition set(double var0, double var2, double var4) {
            return this.set(MathHelper.floor(var0), MathHelper.floor(var2), MathHelper.floor(var4));
        }

        public MutableBlockPosition set(BaseBlockPosition var0) {
            return this.set(var0.getX(), var0.getY(), var0.getZ());
        }

        public MutableBlockPosition set(long var0) {
            return this.set(MutableBlockPosition.getX(var0), MutableBlockPosition.getY(var0), MutableBlockPosition.getZ(var0));
        }

        public MutableBlockPosition set(EnumAxisCycle var0, int var1, int var2, int var3) {
            return this.set(var0.cycle(var1, var2, var3, EnumDirection.EnumAxis.X), var0.cycle(var1, var2, var3, EnumDirection.EnumAxis.Y), var0.cycle(var1, var2, var3, EnumDirection.EnumAxis.Z));
        }

        public MutableBlockPosition setWithOffset(BaseBlockPosition var0, EnumDirection var1) {
            return this.set(var0.getX() + var1.getStepX(), var0.getY() + var1.getStepY(), var0.getZ() + var1.getStepZ());
        }

        public MutableBlockPosition setWithOffset(BaseBlockPosition var0, int var1, int var2, int var3) {
            return this.set(var0.getX() + var1, var0.getY() + var2, var0.getZ() + var3);
        }

        public MutableBlockPosition setWithOffset(BaseBlockPosition var0, BaseBlockPosition var1) {
            return this.set(var0.getX() + var1.getX(), var0.getY() + var1.getY(), var0.getZ() + var1.getZ());
        }

        public MutableBlockPosition move(EnumDirection var0) {
            return this.move(var0, 1);
        }

        public MutableBlockPosition move(EnumDirection var0, int var1) {
            return this.set(this.getX() + var0.getStepX() * var1, this.getY() + var0.getStepY() * var1, this.getZ() + var0.getStepZ() * var1);
        }

        public MutableBlockPosition move(int var0, int var1, int var2) {
            return this.set(this.getX() + var0, this.getY() + var1, this.getZ() + var2);
        }

        public MutableBlockPosition move(BaseBlockPosition var0) {
            return this.set(this.getX() + var0.getX(), this.getY() + var0.getY(), this.getZ() + var0.getZ());
        }

        public MutableBlockPosition clamp(EnumDirection.EnumAxis var0, int var1, int var2) {
            switch (var0) {
                case X: {
                    return this.set(MathHelper.clamp(this.getX(), var1, var2), this.getY(), this.getZ());
                }
                case Y: {
                    return this.set(this.getX(), MathHelper.clamp(this.getY(), var1, var2), this.getZ());
                }
                case Z: {
                    return this.set(this.getX(), this.getY(), MathHelper.clamp(this.getZ(), var1, var2));
                }
            }
            throw new IllegalStateException("Unable to clamp axis " + String.valueOf(var0));
        }

        @Override
        public MutableBlockPosition setX(int var0) {
            super.setX(var0);
            return this;
        }

        @Override
        public MutableBlockPosition setY(int var0) {
            super.setY(var0);
            return this;
        }

        @Override
        public MutableBlockPosition setZ(int var0) {
            super.setZ(var0);
            return this;
        }

        @Override
        public BlockPosition immutable() {
            return new BlockPosition(this);
        }

        @Override
        public /* synthetic */ BaseBlockPosition cross(BaseBlockPosition baseBlockPosition) {
            return super.cross(baseBlockPosition);
        }

        @Override
        public /* synthetic */ BaseBlockPosition relative(EnumDirection.EnumAxis enumAxis, int n2) {
            return this.relative(enumAxis, n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition relative(EnumDirection enumDirection, int n2) {
            return this.relative(enumDirection, n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition relative(EnumDirection enumDirection) {
            return super.relative(enumDirection);
        }

        @Override
        public /* synthetic */ BaseBlockPosition east(int n2) {
            return super.east(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition east() {
            return super.east();
        }

        @Override
        public /* synthetic */ BaseBlockPosition west(int n2) {
            return super.west(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition west() {
            return super.west();
        }

        @Override
        public /* synthetic */ BaseBlockPosition south(int n2) {
            return super.south(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition south() {
            return super.south();
        }

        @Override
        public /* synthetic */ BaseBlockPosition north(int n2) {
            return super.north(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition north() {
            return super.north();
        }

        @Override
        public /* synthetic */ BaseBlockPosition below(int n2) {
            return super.below(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition below() {
            return super.below();
        }

        @Override
        public /* synthetic */ BaseBlockPosition above(int n2) {
            return super.above(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition above() {
            return super.above();
        }

        @Override
        public /* synthetic */ BaseBlockPosition multiply(int n2) {
            return this.multiply(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition subtract(BaseBlockPosition baseBlockPosition) {
            return super.subtract(baseBlockPosition);
        }

        @Override
        public /* synthetic */ BaseBlockPosition offset(BaseBlockPosition baseBlockPosition) {
            return super.offset(baseBlockPosition);
        }

        @Override
        public /* synthetic */ BaseBlockPosition offset(int n2, int n3, int n4) {
            return this.offset(n2, n3, n4);
        }

        @Override
        public /* synthetic */ BaseBlockPosition setZ(int n2) {
            return this.setZ(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition setY(int n2) {
            return this.setY(n2);
        }

        @Override
        public /* synthetic */ BaseBlockPosition setX(int n2) {
            return this.setX(n2);
        }
    }
}

