/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArgumentPredicateItemStack {
    private static final Dynamic2CommandExceptionType ERROR_STACK_TOO_BIG = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("arguments.item.overstacked", var0, var1));
    private final Holder<Item> item;
    private final DataComponentMap components;

    public ArgumentPredicateItemStack(Holder<Item> var0, DataComponentMap var1) {
        this.item = var0;
        this.components = var1;
    }

    public Item getItem() {
        return this.item.value();
    }

    public ItemStack createItemStack(int var0, boolean var1) throws CommandSyntaxException {
        ItemStack var2 = new ItemStack(this.item, var0);
        var2.applyComponents(this.components);
        if (var1 && var0 > var2.getMaxStackSize()) {
            throw ERROR_STACK_TOO_BIG.create((Object)this.getItemName(), (Object)var2.getMaxStackSize());
        }
        return var2;
    }

    public String serialize(HolderLookup.a var0) {
        StringBuilder var1 = new StringBuilder(this.getItemName());
        String var2 = this.serializeComponents(var0);
        if (!var2.isEmpty()) {
            var1.append('[');
            var1.append(var2);
            var1.append(']');
        }
        return var1.toString();
    }

    private String serializeComponents(HolderLookup.a var0) {
        RegistryOps<NBTBase> var12 = var0.createSerializationContext(DynamicOpsNBT.INSTANCE);
        return this.components.stream().flatMap(var1 -> {
            DataComponentType var2 = var1.type();
            MinecraftKey var3 = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(var2);
            Optional var4 = var1.encodeValue(var12).result();
            if (var3 == null || var4.isEmpty()) {
                return Stream.empty();
            }
            return Stream.of(var3.toString() + "=" + String.valueOf(var4.get()));
        }).collect(Collectors.joining(String.valueOf(',')));
    }

    private String getItemName() {
        return this.item.unwrapKey().map(ResourceKey::location).orElseGet(() -> "unknown[" + String.valueOf(this.item) + "]").toString();
    }
}

