/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.item.ComponentPredicateParser;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArgumentItemPredicate
implements ArgumentType<d> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stick", "minecraft:stick", "#stick", "#stick{foo:'bar'}");
    static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.item.id.invalid", var0));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("arguments.item.tag.unknown", var0));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("arguments.item.component.unknown", var0));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("arguments.item.component.malformed", var0, var1));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_PREDICATE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("arguments.item.predicate.unknown", var0));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_PREDICATE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("arguments.item.predicate.malformed", var0, var1));
    private static final MinecraftKey COUNT_ID = new MinecraftKey("count");
    static final Map<MinecraftKey, a> PSEUDO_COMPONENTS = Stream.of(new a(COUNT_ID, var0 -> true, (Decoder<? extends Predicate<ItemStack>>)CriterionConditionValue.IntegerRange.CODEC.map(var0 -> var1 -> var0.matches(var1.getCount())))).collect(Collectors.toUnmodifiableMap(a::id, var0 -> var0));
    static final Map<MinecraftKey, c> PSEUDO_PREDICATES = Stream.of(new c(COUNT_ID, (Decoder<? extends Predicate<ItemStack>>)CriterionConditionValue.IntegerRange.CODEC.map(var0 -> var1 -> var0.matches(var1.getCount())))).collect(Collectors.toUnmodifiableMap(c::id, var0 -> var0));
    private final Grammar<List<Predicate<ItemStack>>> grammarWithContext;

    public ArgumentItemPredicate(CommandBuildContext var0) {
        b var1 = new b(var0);
        this.grammarWithContext = ComponentPredicateParser.createGrammar(var1);
    }

    public static ArgumentItemPredicate itemPredicate(CommandBuildContext var0) {
        return new ArgumentItemPredicate(var0);
    }

    public d parse(StringReader var0) throws CommandSyntaxException {
        return SystemUtils.allOf(this.grammarWithContext.parseForCommands(var0))::test;
    }

    public static d getItemPredicate(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (d)var0.getArgument(var1, d.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return this.grammarWithContext.parseForSuggestions(var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static class b
    implements ComponentPredicateParser.b<Predicate<ItemStack>, a, c> {
        private final HolderLookup.b<Item> items;
        private final HolderLookup.b<DataComponentType<?>> components;
        private final HolderLookup.b<ItemSubPredicate.a<?>> predicates;
        private final RegistryOps<NBTBase> registryOps;

        b(HolderLookup.a var0) {
            this.items = var0.lookupOrThrow(Registries.ITEM);
            this.components = var0.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
            this.predicates = var0.lookupOrThrow(Registries.ITEM_SUB_PREDICATE_TYPE);
            this.registryOps = var0.createSerializationContext(DynamicOpsNBT.INSTANCE);
        }

        @Override
        public Predicate<ItemStack> forElementType(ImmutableStringReader var0, MinecraftKey var12) throws CommandSyntaxException {
            Holder.c<Item> var2 = this.items.get(ResourceKey.create(Registries.ITEM, var12)).orElseThrow(() -> ERROR_UNKNOWN_ITEM.createWithContext(var0, (Object)var12));
            return var1 -> var1.is(var2);
        }

        @Override
        public Predicate<ItemStack> forTagType(ImmutableStringReader var0, MinecraftKey var12) throws CommandSyntaxException {
            HolderSet var2 = this.items.get(TagKey.create(Registries.ITEM, var12)).orElseThrow(() -> ERROR_UNKNOWN_TAG.createWithContext(var0, (Object)var12));
            return var1 -> var1.is(var2);
        }

        @Override
        public a lookupComponentType(ImmutableStringReader var0, MinecraftKey var1) throws CommandSyntaxException {
            a var2 = PSEUDO_COMPONENTS.get(var1);
            if (var2 != null) {
                return var2;
            }
            DataComponentType var3 = this.components.get(ResourceKey.create(Registries.DATA_COMPONENT_TYPE, var1)).map(Holder::value).orElseThrow(() -> ERROR_UNKNOWN_COMPONENT.createWithContext(var0, (Object)var1));
            return a.create(var0, var1, var3);
        }

        @Override
        public Predicate<ItemStack> createComponentTest(ImmutableStringReader var0, a var1, NBTBase var2) throws CommandSyntaxException {
            return var1.decode(var0, this.registryOps, var2);
        }

        @Override
        public Predicate<ItemStack> createComponentTest(ImmutableStringReader var0, a var1) {
            return var1.presenceChecker;
        }

        @Override
        public c lookupPredicateType(ImmutableStringReader var0, MinecraftKey var1) throws CommandSyntaxException {
            c var2 = PSEUDO_PREDICATES.get(var1);
            if (var2 != null) {
                return var2;
            }
            return this.predicates.get(ResourceKey.create(Registries.ITEM_SUB_PREDICATE_TYPE, var1)).map(c::new).orElseThrow(() -> ERROR_UNKNOWN_PREDICATE.createWithContext(var0, (Object)var1));
        }

        @Override
        public Predicate<ItemStack> createPredicateTest(ImmutableStringReader var0, c var1, NBTBase var2) throws CommandSyntaxException {
            return var1.decode(var0, this.registryOps, var2);
        }

        @Override
        public Stream<MinecraftKey> listElementTypes() {
            return this.items.listElementIds().map(ResourceKey::location);
        }

        @Override
        public Stream<MinecraftKey> listTagTypes() {
            return this.items.listTagIds().map(TagKey::location);
        }

        @Override
        public Stream<MinecraftKey> listComponentTypes() {
            return Stream.concat(PSEUDO_COMPONENTS.keySet().stream(), this.components.listElements().filter(var0 -> !((DataComponentType)var0.value()).isTransient()).map(var0 -> var0.key().location()));
        }

        @Override
        public Stream<MinecraftKey> listPredicateTypes() {
            return Stream.concat(PSEUDO_PREDICATES.keySet().stream(), this.predicates.listElementIds().map(ResourceKey::location));
        }

        @Override
        public Predicate<ItemStack> negate(Predicate<ItemStack> var0) {
            return var0.negate();
        }

        @Override
        public Predicate<ItemStack> anyOf(List<Predicate<ItemStack>> var0) {
            return SystemUtils.anyOf(var0);
        }

        @Override
        public /* synthetic */ Object anyOf(List list) {
            return this.anyOf(list);
        }

        @Override
        public /* synthetic */ Object createPredicateTest(ImmutableStringReader immutableStringReader, Object object, NBTBase nBTBase) throws CommandSyntaxException {
            return this.createPredicateTest(immutableStringReader, (c)object, nBTBase);
        }

        @Override
        public /* synthetic */ Object lookupPredicateType(ImmutableStringReader immutableStringReader, MinecraftKey minecraftKey) throws CommandSyntaxException {
            return this.lookupPredicateType(immutableStringReader, minecraftKey);
        }

        @Override
        public /* synthetic */ Object lookupComponentType(ImmutableStringReader immutableStringReader, MinecraftKey minecraftKey) throws CommandSyntaxException {
            return this.lookupComponentType(immutableStringReader, minecraftKey);
        }

        @Override
        public /* synthetic */ Object forTagType(ImmutableStringReader immutableStringReader, MinecraftKey minecraftKey) throws CommandSyntaxException {
            return this.forTagType(immutableStringReader, minecraftKey);
        }

        @Override
        public /* synthetic */ Object forElementType(ImmutableStringReader immutableStringReader, MinecraftKey minecraftKey) throws CommandSyntaxException {
            return this.forElementType(immutableStringReader, minecraftKey);
        }
    }

    public static interface d
    extends Predicate<ItemStack> {
    }

    static final class a
    extends Record {
        private final MinecraftKey id;
        final Predicate<ItemStack> presenceChecker;
        private final Decoder<? extends Predicate<ItemStack>> valueChecker;

        a(MinecraftKey var0, Predicate<ItemStack> var1, Decoder<? extends Predicate<ItemStack>> var2) {
            this.id = var0;
            this.presenceChecker = var1;
            this.valueChecker = var2;
        }

        public static <T> a create(ImmutableStringReader var0, MinecraftKey var12, DataComponentType<T> var2) throws CommandSyntaxException {
            Codec<T> var3 = var2.codec();
            if (var3 == null) {
                throw ERROR_UNKNOWN_COMPONENT.createWithContext(var0, (Object)var12);
            }
            return new a(var12, var1 -> var1.has(var2), (Decoder<? extends Predicate<ItemStack>>)var3.map(var1 -> var2 -> {
                Object var3 = var2.get(var2);
                return Objects.equals(var1, var3);
            }));
        }

        public Predicate<ItemStack> decode(ImmutableStringReader var0, RegistryOps<NBTBase> var12, NBTBase var2) throws CommandSyntaxException {
            DataResult var3 = this.valueChecker.parse(var12, (Object)var2);
            return (Predicate)var3.getOrThrow(var1 -> ERROR_MALFORMED_COMPONENT.createWithContext(var0, (Object)this.id.toString(), var1));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id;presenceChecker;valueChecker", "id", "presenceChecker", "valueChecker"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id;presenceChecker;valueChecker", "id", "presenceChecker", "valueChecker"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id;presenceChecker;valueChecker", "id", "presenceChecker", "valueChecker"}, this, var0);
        }

        public MinecraftKey id() {
            return this.id;
        }

        public Predicate<ItemStack> presenceChecker() {
            return this.presenceChecker;
        }

        public Decoder<? extends Predicate<ItemStack>> valueChecker() {
            return this.valueChecker;
        }
    }

    record c(MinecraftKey id, Decoder<? extends Predicate<ItemStack>> type) {
        public c(Holder.c<ItemSubPredicate.a<?>> var02) {
            this(var02.key().location(), (Decoder<? extends Predicate<ItemStack>>)var02.value().codec().map(var0 -> var0::matches));
        }

        public Predicate<ItemStack> decode(ImmutableStringReader var0, RegistryOps<NBTBase> var12, NBTBase var2) throws CommandSyntaxException {
            DataResult var3 = this.type.parse(var12, (Object)var2);
            return (Predicate)var3.getOrThrow(var1 -> ERROR_MALFORMED_PREDICATE.createWithContext(var0, (Object)this.id.toString(), var1));
        }
    }
}

