/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.phys.Vec3D;

public record LootItemConditionLocationCheck(Optional<CriterionConditionLocation> predicate, BlockPosition offset) implements LootItemCondition
{
    private static final MapCodec<BlockPosition> OFFSET_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.INT.optionalFieldOf("offsetX", (Object)0).forGetter(BaseBlockPosition::getX), (App)Codec.INT.optionalFieldOf("offsetY", (Object)0).forGetter(BaseBlockPosition::getY), (App)Codec.INT.optionalFieldOf("offsetZ", (Object)0).forGetter(BaseBlockPosition::getZ)).apply((Applicative)var0, BlockPosition::new));
    public static final MapCodec<LootItemConditionLocationCheck> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CriterionConditionLocation.CODEC.optionalFieldOf("predicate").forGetter(LootItemConditionLocationCheck::predicate), (App)OFFSET_CODEC.forGetter(LootItemConditionLocationCheck::offset)).apply((Applicative)var0, LootItemConditionLocationCheck::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.LOCATION_CHECK;
    }

    @Override
    public boolean test(LootTableInfo var0) {
        Vec3D var1 = var0.getParamOrNull(LootContextParameters.ORIGIN);
        return var1 != null && (this.predicate.isEmpty() || this.predicate.get().matches(var0.getLevel(), var1.x() + (double)this.offset.getX(), var1.y() + (double)this.offset.getY(), var1.z() + (double)this.offset.getZ()));
    }

    public static LootItemCondition.a checkLocation(CriterionConditionLocation.a var0) {
        return () -> new LootItemConditionLocationCheck(Optional.of(var0.build()), BlockPosition.ZERO);
    }

    public static LootItemCondition.a checkLocation(CriterionConditionLocation.a var0, BlockPosition var1) {
        return () -> new LootItemConditionLocationCheck(Optional.of(var0.build()), var1);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }
}

