/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.parameters;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class LootContextParameterSets {
    private static final BiMap<MinecraftKey, LootContextParameterSet> REGISTRY = HashBiMap.create();
    public static final Codec<LootContextParameterSet> CODEC = MinecraftKey.CODEC.comapFlatMap(var0 -> Optional.ofNullable((LootContextParameterSet)REGISTRY.get(var0)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No parameter set exists with id: '" + String.valueOf(var0) + "'")), arg_0 -> REGISTRY.inverse().get(arg_0));
    public static final LootContextParameterSet EMPTY = LootContextParameterSets.register("empty", var0 -> {});
    public static final LootContextParameterSet CHEST = LootContextParameterSets.register("chest", var0 -> var0.required(LootContextParameters.ORIGIN).optional(LootContextParameters.THIS_ENTITY));
    public static final LootContextParameterSet COMMAND = LootContextParameterSets.register("command", var0 -> var0.required(LootContextParameters.ORIGIN).optional(LootContextParameters.THIS_ENTITY));
    public static final LootContextParameterSet SELECTOR = LootContextParameterSets.register("selector", var0 -> var0.required(LootContextParameters.ORIGIN).required(LootContextParameters.THIS_ENTITY));
    public static final LootContextParameterSet FISHING = LootContextParameterSets.register("fishing", var0 -> var0.required(LootContextParameters.ORIGIN).required(LootContextParameters.TOOL).optional(LootContextParameters.THIS_ENTITY));
    public static final LootContextParameterSet ENTITY = LootContextParameterSets.register("entity", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ORIGIN).required(LootContextParameters.DAMAGE_SOURCE).optional(LootContextParameters.KILLER_ENTITY).optional(LootContextParameters.DIRECT_KILLER_ENTITY).optional(LootContextParameters.LAST_DAMAGE_PLAYER));
    public static final LootContextParameterSet EQUIPMENT = LootContextParameterSets.register("equipment", var0 -> var0.required(LootContextParameters.ORIGIN).required(LootContextParameters.THIS_ENTITY));
    public static final LootContextParameterSet ARCHAEOLOGY = LootContextParameterSets.register("archaeology", var0 -> var0.required(LootContextParameters.ORIGIN).optional(LootContextParameters.THIS_ENTITY));
    public static final LootContextParameterSet GIFT = LootContextParameterSets.register("gift", var0 -> var0.required(LootContextParameters.ORIGIN).required(LootContextParameters.THIS_ENTITY));
    public static final LootContextParameterSet PIGLIN_BARTER = LootContextParameterSets.register("barter", var0 -> var0.required(LootContextParameters.THIS_ENTITY));
    public static final LootContextParameterSet VAULT = LootContextParameterSets.register("vault", var0 -> var0.required(LootContextParameters.ORIGIN).optional(LootContextParameters.THIS_ENTITY));
    public static final LootContextParameterSet ADVANCEMENT_REWARD = LootContextParameterSets.register("advancement_reward", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ORIGIN));
    public static final LootContextParameterSet ADVANCEMENT_ENTITY = LootContextParameterSets.register("advancement_entity", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ORIGIN));
    public static final LootContextParameterSet ADVANCEMENT_LOCATION = LootContextParameterSets.register("advancement_location", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ORIGIN).required(LootContextParameters.TOOL).required(LootContextParameters.BLOCK_STATE));
    public static final LootContextParameterSet BLOCK_USE = LootContextParameterSets.register("block_use", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.ORIGIN).required(LootContextParameters.BLOCK_STATE));
    public static final LootContextParameterSet ALL_PARAMS = LootContextParameterSets.register("generic", var0 -> var0.required(LootContextParameters.THIS_ENTITY).required(LootContextParameters.LAST_DAMAGE_PLAYER).required(LootContextParameters.DAMAGE_SOURCE).required(LootContextParameters.KILLER_ENTITY).required(LootContextParameters.DIRECT_KILLER_ENTITY).required(LootContextParameters.ORIGIN).required(LootContextParameters.BLOCK_STATE).required(LootContextParameters.BLOCK_ENTITY).required(LootContextParameters.TOOL).required(LootContextParameters.EXPLOSION_RADIUS));
    public static final LootContextParameterSet BLOCK = LootContextParameterSets.register("block", var0 -> var0.required(LootContextParameters.BLOCK_STATE).required(LootContextParameters.ORIGIN).required(LootContextParameters.TOOL).optional(LootContextParameters.THIS_ENTITY).optional(LootContextParameters.BLOCK_ENTITY).optional(LootContextParameters.EXPLOSION_RADIUS));
    public static final LootContextParameterSet SHEARING = LootContextParameterSets.register("shearing", var0 -> var0.required(LootContextParameters.ORIGIN).optional(LootContextParameters.THIS_ENTITY));

    private static LootContextParameterSet register(String var0, Consumer<LootContextParameterSet.Builder> var1) {
        LootContextParameterSet.Builder var2 = new LootContextParameterSet.Builder();
        var1.accept(var2);
        LootContextParameterSet var3 = var2.build();
        MinecraftKey var4 = new MinecraftKey(var0);
        LootContextParameterSet var5 = (LootContextParameterSet)REGISTRY.put((Object)var4, (Object)var3);
        if (var5 != null) {
            throw new IllegalStateException("Loot table parameter set " + String.valueOf(var4) + " is already registered");
        }
        return var3;
    }
}

