/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.parameters;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootItemUser;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;

public class LootContextParameterSet {
    private final Set<LootContextParameter<?>> required;
    private final Set<LootContextParameter<?>> all;

    LootContextParameterSet(Set<LootContextParameter<?>> var0, Set<LootContextParameter<?>> var1) {
        this.required = ImmutableSet.copyOf(var0);
        this.all = ImmutableSet.copyOf((Collection)Sets.union(var0, var1));
    }

    public boolean isAllowed(LootContextParameter<?> var0) {
        return this.all.contains(var0);
    }

    public Set<LootContextParameter<?>> getRequired() {
        return this.required;
    }

    public Set<LootContextParameter<?>> getAllowed() {
        return this.all;
    }

    public String toString() {
        return "[" + Joiner.on((String)", ").join(this.all.stream().map(var0 -> (this.required.contains(var0) ? "!" : "") + String.valueOf(var0.getName())).iterator()) + "]";
    }

    public void validateUser(LootCollector var0, LootItemUser var1) {
        Set<LootContextParameter<?>> var2 = var1.getReferencedContextParams();
        Sets.SetView var3 = Sets.difference(var2, this.all);
        if (!var3.isEmpty()) {
            var0.reportProblem("Parameters " + String.valueOf(var3) + " are not provided in this context");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<LootContextParameter<?>> required = Sets.newIdentityHashSet();
        private final Set<LootContextParameter<?>> optional = Sets.newIdentityHashSet();

        public Builder required(LootContextParameter<?> var0) {
            if (this.optional.contains(var0)) {
                throw new IllegalArgumentException("Parameter " + String.valueOf(var0.getName()) + " is already optional");
            }
            this.required.add(var0);
            return this;
        }

        public Builder optional(LootContextParameter<?> var0) {
            if (this.required.contains(var0)) {
                throw new IllegalArgumentException("Parameter " + String.valueOf(var0.getName()) + " is already required");
            }
            this.optional.add(var0);
            return this;
        }

        public LootContextParameterSet build() {
            return new LootContextParameterSet(this.required, this.optional);
        }
    }
}

