/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.FilteredFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionReference;
import net.minecraft.world.level.storage.loot.functions.LootEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.LootEnchantLevel;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionEnchant;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplorationMap;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionFillPlayerHead;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionLimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetAttribute;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetContents;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetDamage;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetLore;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetStewEffect;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSmelt;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.ModifyContainerContents;
import net.minecraft.world.level.storage.loot.functions.SequenceFunction;
import net.minecraft.world.level.storage.loot.functions.SetBannerPatternFunction;
import net.minecraft.world.level.storage.loot.functions.SetBookCoverFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.SetCustomModelDataFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetFireworkExplosionFunction;
import net.minecraft.world.level.storage.loot.functions.SetFireworksFunction;
import net.minecraft.world.level.storage.loot.functions.SetInstrumentFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetOminousBottleAmplifierFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SetWritableBookPagesFunction;
import net.minecraft.world.level.storage.loot.functions.SetWrittenBookPagesFunction;
import net.minecraft.world.level.storage.loot.functions.ToggleTooltips;

public class LootItemFunctions {
    public static final BiFunction<ItemStack, LootTableInfo, ItemStack> IDENTITY = (var0, var1) -> var0;
    public static final Codec<LootItemFunction> TYPED_CODEC = BuiltInRegistries.LOOT_FUNCTION_TYPE.byNameCodec().dispatch("function", LootItemFunction::getType, LootItemFunctionType::codec);
    public static final Codec<LootItemFunction> ROOT_CODEC = Codec.lazyInitialized(() -> Codec.withAlternative(TYPED_CODEC, SequenceFunction.INLINE_CODEC));
    public static final Codec<Holder<LootItemFunction>> CODEC = RegistryFileCodec.create(Registries.ITEM_MODIFIER, ROOT_CODEC);
    public static final LootItemFunctionType<LootItemFunctionSetCount> SET_COUNT = LootItemFunctions.register("set_count", LootItemFunctionSetCount.CODEC);
    public static final LootItemFunctionType<SetItemFunction> SET_ITEM = LootItemFunctions.register("set_item", SetItemFunction.CODEC);
    public static final LootItemFunctionType<LootEnchantLevel> ENCHANT_WITH_LEVELS = LootItemFunctions.register("enchant_with_levels", LootEnchantLevel.CODEC);
    public static final LootItemFunctionType<LootItemFunctionEnchant> ENCHANT_RANDOMLY = LootItemFunctions.register("enchant_randomly", LootItemFunctionEnchant.CODEC);
    public static final LootItemFunctionType<SetEnchantmentsFunction> SET_ENCHANTMENTS = LootItemFunctions.register("set_enchantments", SetEnchantmentsFunction.CODEC);
    public static final LootItemFunctionType<SetCustomDataFunction> SET_CUSTOM_DATA = LootItemFunctions.register("set_custom_data", SetCustomDataFunction.CODEC);
    public static final LootItemFunctionType<SetComponentsFunction> SET_COMPONENTS = LootItemFunctions.register("set_components", SetComponentsFunction.CODEC);
    public static final LootItemFunctionType<LootItemFunctionSmelt> FURNACE_SMELT = LootItemFunctions.register("furnace_smelt", LootItemFunctionSmelt.CODEC);
    public static final LootItemFunctionType<LootEnchantFunction> LOOTING_ENCHANT = LootItemFunctions.register("looting_enchant", LootEnchantFunction.CODEC);
    public static final LootItemFunctionType<LootItemFunctionSetDamage> SET_DAMAGE = LootItemFunctions.register("set_damage", LootItemFunctionSetDamage.CODEC);
    public static final LootItemFunctionType<LootItemFunctionSetAttribute> SET_ATTRIBUTES = LootItemFunctions.register("set_attributes", LootItemFunctionSetAttribute.CODEC);
    public static final LootItemFunctionType<LootItemFunctionSetName> SET_NAME = LootItemFunctions.register("set_name", LootItemFunctionSetName.CODEC);
    public static final LootItemFunctionType<LootItemFunctionExplorationMap> EXPLORATION_MAP = LootItemFunctions.register("exploration_map", LootItemFunctionExplorationMap.CODEC);
    public static final LootItemFunctionType<LootItemFunctionSetStewEffect> SET_STEW_EFFECT = LootItemFunctions.register("set_stew_effect", LootItemFunctionSetStewEffect.CODEC);
    public static final LootItemFunctionType<LootItemFunctionCopyName> COPY_NAME = LootItemFunctions.register("copy_name", LootItemFunctionCopyName.CODEC);
    public static final LootItemFunctionType<LootItemFunctionSetContents> SET_CONTENTS = LootItemFunctions.register("set_contents", LootItemFunctionSetContents.CODEC);
    public static final LootItemFunctionType<ModifyContainerContents> MODIFY_CONTENTS = LootItemFunctions.register("modify_contents", ModifyContainerContents.CODEC);
    public static final LootItemFunctionType<FilteredFunction> FILTERED = LootItemFunctions.register("filtered", FilteredFunction.CODEC);
    public static final LootItemFunctionType<LootItemFunctionLimitCount> LIMIT_COUNT = LootItemFunctions.register("limit_count", LootItemFunctionLimitCount.CODEC);
    public static final LootItemFunctionType<LootItemFunctionApplyBonus> APPLY_BONUS = LootItemFunctions.register("apply_bonus", LootItemFunctionApplyBonus.CODEC);
    public static final LootItemFunctionType<LootItemFunctionSetTable> SET_LOOT_TABLE = LootItemFunctions.register("set_loot_table", LootItemFunctionSetTable.CODEC);
    public static final LootItemFunctionType<LootItemFunctionExplosionDecay> EXPLOSION_DECAY = LootItemFunctions.register("explosion_decay", LootItemFunctionExplosionDecay.CODEC);
    public static final LootItemFunctionType<LootItemFunctionSetLore> SET_LORE = LootItemFunctions.register("set_lore", LootItemFunctionSetLore.CODEC);
    public static final LootItemFunctionType<LootItemFunctionFillPlayerHead> FILL_PLAYER_HEAD = LootItemFunctions.register("fill_player_head", LootItemFunctionFillPlayerHead.CODEC);
    public static final LootItemFunctionType<CopyCustomDataFunction> COPY_CUSTOM_DATA = LootItemFunctions.register("copy_custom_data", CopyCustomDataFunction.CODEC);
    public static final LootItemFunctionType<LootItemFunctionCopyState> COPY_STATE = LootItemFunctions.register("copy_state", LootItemFunctionCopyState.CODEC);
    public static final LootItemFunctionType<SetBannerPatternFunction> SET_BANNER_PATTERN = LootItemFunctions.register("set_banner_pattern", SetBannerPatternFunction.CODEC);
    public static final LootItemFunctionType<SetPotionFunction> SET_POTION = LootItemFunctions.register("set_potion", SetPotionFunction.CODEC);
    public static final LootItemFunctionType<SetInstrumentFunction> SET_INSTRUMENT = LootItemFunctions.register("set_instrument", SetInstrumentFunction.CODEC);
    public static final LootItemFunctionType<FunctionReference> REFERENCE = LootItemFunctions.register("reference", FunctionReference.CODEC);
    public static final LootItemFunctionType<SequenceFunction> SEQUENCE = LootItemFunctions.register("sequence", SequenceFunction.CODEC);
    public static final LootItemFunctionType<CopyComponentsFunction> COPY_COMPONENTS = LootItemFunctions.register("copy_components", CopyComponentsFunction.CODEC);
    public static final LootItemFunctionType<SetFireworksFunction> SET_FIREWORKS = LootItemFunctions.register("set_fireworks", SetFireworksFunction.CODEC);
    public static final LootItemFunctionType<SetFireworkExplosionFunction> SET_FIREWORK_EXPLOSION = LootItemFunctions.register("set_firework_explosion", SetFireworkExplosionFunction.CODEC);
    public static final LootItemFunctionType<SetBookCoverFunction> SET_BOOK_COVER = LootItemFunctions.register("set_book_cover", SetBookCoverFunction.CODEC);
    public static final LootItemFunctionType<SetWrittenBookPagesFunction> SET_WRITTEN_BOOK_PAGES = LootItemFunctions.register("set_written_book_pages", SetWrittenBookPagesFunction.CODEC);
    public static final LootItemFunctionType<SetWritableBookPagesFunction> SET_WRITABLE_BOOK_PAGES = LootItemFunctions.register("set_writable_book_pages", SetWritableBookPagesFunction.CODEC);
    public static final LootItemFunctionType<ToggleTooltips> TOGGLE_TOOLTIPS = LootItemFunctions.register("toggle_tooltips", ToggleTooltips.CODEC);
    public static final LootItemFunctionType<SetOminousBottleAmplifierFunction> SET_OMINOUS_BOTTLE_AMPLIFIER = LootItemFunctions.register("set_ominous_bottle_amplifier", SetOminousBottleAmplifierFunction.CODEC);
    public static final LootItemFunctionType<SetCustomModelDataFunction> SET_CUSTOM_MODEL_DATA = LootItemFunctions.register("set_custom_model_data", SetCustomModelDataFunction.CODEC);

    private static <T extends LootItemFunction> LootItemFunctionType<T> register(String var0, MapCodec<T> var1) {
        return IRegistry.register(BuiltInRegistries.LOOT_FUNCTION_TYPE, new MinecraftKey(var0), new LootItemFunctionType<T>(var1));
    }

    public static BiFunction<ItemStack, LootTableInfo, ItemStack> compose(List<? extends BiFunction<ItemStack, LootTableInfo, ItemStack>> var0) {
        List<? extends BiFunction<ItemStack, LootTableInfo, ItemStack>> var12 = List.copyOf(var0);
        return switch (var12.size()) {
            case 0 -> IDENTITY;
            case 1 -> var12.get(0);
            case 2 -> {
                BiFunction<ItemStack, LootTableInfo, ItemStack> var2 = var12.get(0);
                BiFunction<ItemStack, LootTableInfo, ItemStack> var3 = var12.get(1);
                yield (var2, var3) -> (ItemStack)var3.apply((ItemStack)var2.apply((ItemStack)var2, (LootTableInfo)var3), (LootTableInfo)var3);
            }
            default -> (var1, var2) -> {
                for (BiFunction var4 : var12) {
                    var1 = (ItemStack)var4.apply(var1, var2);
                }
                return var1;
            };
        };
    }
}

