/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionEnchant
extends LootItemFunctionConditional {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<HolderSet<Enchantment>> ENCHANTMENT_SET_CODEC = BuiltInRegistries.ENCHANTMENT.holderByNameCodec().listOf().xmap(HolderSet::direct, var0 -> var0.stream().toList());
    public static final MapCodec<LootItemFunctionEnchant> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionEnchant.commonFields(var02).and((App)ENCHANTMENT_SET_CODEC.optionalFieldOf("enchantments").forGetter(var0 -> var0.enchantments)).apply((Applicative)var02, LootItemFunctionEnchant::new));
    private final Optional<HolderSet<Enchantment>> enchantments;

    LootItemFunctionEnchant(List<LootItemCondition> var0, Optional<HolderSet<Enchantment>> var1) {
        super(var0);
        this.enchantments = var1;
    }

    public LootItemFunctionType<LootItemFunctionEnchant> getType() {
        return LootItemFunctions.ENCHANT_RANDOMLY;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var12) {
        RandomSource var2 = var12.getRandom();
        Optional var3 = this.enchantments.flatMap(var1 -> var1.getRandomElement(var2)).or(() -> {
            boolean var3 = var0.is(Items.BOOK);
            List<Holder.c> var4 = BuiltInRegistries.ENCHANTMENT.holders().filter(var1 -> ((Enchantment)var1.value()).isEnabled(var12.getLevel().enabledFeatures())).filter(var0 -> ((Enchantment)var0.value()).isDiscoverable()).filter(var2 -> var3 || ((Enchantment)var2.value()).canEnchant(var0)).toList();
            return SystemUtils.getRandomSafe(var4, var2);
        });
        if (var3.isEmpty()) {
            LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)var0);
            return var0;
        }
        return LootItemFunctionEnchant.enchantItem(var0, (Enchantment)((Holder)var3.get()).value(), var2);
    }

    private static ItemStack enchantItem(ItemStack var0, Enchantment var1, RandomSource var2) {
        int var3 = MathHelper.nextInt(var2, var1.getMinLevel(), var1.getMaxLevel());
        if (var0.is(Items.BOOK)) {
            var0 = new ItemStack(Items.ENCHANTED_BOOK);
        }
        var0.enchant(var1, var3);
        return var0;
    }

    public static a randomEnchantment() {
        return new a();
    }

    public static LootItemFunctionConditional.a<?> randomApplicableEnchantment() {
        return LootItemFunctionEnchant.simpleBuilder(var0 -> new LootItemFunctionEnchant((List<LootItemCondition>)var0, Optional.empty()));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final List<Holder<Enchantment>> enchantments = new ArrayList<Holder<Enchantment>>();

        @Override
        protected a getThis() {
            return this;
        }

        public a withEnchantment(Enchantment var0) {
            this.enchantments.add(var0.builtInRegistryHolder());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionEnchant(this.getConditions(), this.enchantments.isEmpty() ? Optional.empty() : Optional.of(HolderSet.direct(this.enchantments)));
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

