/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.INamable;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionCopyName
extends LootItemFunctionConditional {
    public static final MapCodec<LootItemFunctionCopyName> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionCopyName.commonFields(var02).and((App)Source.CODEC.fieldOf("source").forGetter(var0 -> var0.source)).apply((Applicative)var02, LootItemFunctionCopyName::new));
    private final Source source;

    private LootItemFunctionCopyName(List<LootItemCondition> var0, Source var1) {
        super(var0);
        this.source = var1;
    }

    public LootItemFunctionType<LootItemFunctionCopyName> getType() {
        return LootItemFunctions.COPY_NAME;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(this.source.param);
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        Object var2 = var1.getParamOrNull(this.source.param);
        if (var2 instanceof INamableTileEntity) {
            INamableTileEntity var3 = (INamableTileEntity)var2;
            var0.set(DataComponents.CUSTOM_NAME, var3.getCustomName());
        }
        return var0;
    }

    public static LootItemFunctionConditional.a<?> copyName(Source var0) {
        return LootItemFunctionCopyName.simpleBuilder(var1 -> new LootItemFunctionCopyName((List<LootItemCondition>)var1, var0));
    }

    public static final class Source
    extends Enum<Source>
    implements INamable {
        public static final /* enum */ Source THIS = new Source("this", LootContextParameters.THIS_ENTITY);
        public static final /* enum */ Source KILLER = new Source("killer", LootContextParameters.KILLER_ENTITY);
        public static final /* enum */ Source KILLER_PLAYER = new Source("killer_player", LootContextParameters.LAST_DAMAGE_PLAYER);
        public static final /* enum */ Source BLOCK_ENTITY = new Source("block_entity", LootContextParameters.BLOCK_ENTITY);
        public static final Codec<Source> CODEC;
        private final String name;
        final LootContextParameter<?> param;
        private static final /* synthetic */ Source[] h;

        public static Source[] values() {
            return (Source[])h.clone();
        }

        public static Source valueOf(String var0) {
            return Enum.valueOf(Source.class, var0);
        }

        private Source(String var2, LootContextParameter var3) {
            this.name = var2;
            this.param = var3;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Source[] a() {
            return new Source[]{THIS, KILLER, KILLER_PLAYER, BLOCK_ENTITY};
        }

        static {
            h = Source.a();
            CODEC = INamable.fromEnum(Source::values);
        }
    }
}

