/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootEnchantFunction
extends LootItemFunctionConditional {
    public static final int NO_LIMIT = 0;
    public static final MapCodec<LootEnchantFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootEnchantFunction.commonFields(var02).and(var02.group((App)NumberProviders.CODEC.fieldOf("count").forGetter(var0 -> var0.value), (App)Codec.INT.optionalFieldOf("limit", (Object)0).forGetter(var0 -> var0.limit))).apply((Applicative)var02, LootEnchantFunction::new));
    private final NumberProvider value;
    private final int limit;

    LootEnchantFunction(List<LootItemCondition> var0, NumberProvider var1, int var2) {
        super(var0);
        this.value = var1;
        this.limit = var2;
    }

    public LootItemFunctionType<LootEnchantFunction> getType() {
        return LootItemFunctions.LOOTING_ENCHANT;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return Sets.union((Set)ImmutableSet.of(LootContextParameters.KILLER_ENTITY), this.value.getReferencedContextParams());
    }

    private boolean hasLimit() {
        return this.limit > 0;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        Entity var2 = var1.getParamOrNull(LootContextParameters.KILLER_ENTITY);
        if (var2 instanceof EntityLiving) {
            int var3 = EnchantmentManager.getMobLooting((EntityLiving)var2);
            if (var3 == 0) {
                return var0;
            }
            float var4 = (float)var3 * this.value.getFloat(var1);
            var0.grow(Math.round(var4));
            if (this.hasLimit()) {
                var0.limitSize(this.limit);
            }
        }
        return var0;
    }

    public static a lootingMultiplier(NumberProvider var0) {
        return new a(var0);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final NumberProvider count;
        private int limit = 0;

        public a(NumberProvider var0) {
            this.count = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        public a setLimit(int var0) {
            this.limit = var0;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootEnchantFunction(this.getConditions(), this.count, this.limit);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

