/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;

public class LootParams {
    private final WorldServer level;
    private final Map<LootContextParameter<?>, Object> params;
    private final Map<MinecraftKey, b> dynamicDrops;
    private final float luck;

    public LootParams(WorldServer var0, Map<LootContextParameter<?>, Object> var1, Map<MinecraftKey, b> var2, float var3) {
        this.level = var0;
        this.params = var1;
        this.dynamicDrops = var2;
        this.luck = var3;
    }

    public WorldServer getLevel() {
        return this.level;
    }

    public boolean hasParam(LootContextParameter<?> var0) {
        return this.params.containsKey(var0);
    }

    public <T> T getParameter(LootContextParameter<T> var0) {
        Object var1 = this.params.get(var0);
        if (var1 == null) {
            throw new NoSuchElementException(var0.getName().toString());
        }
        return (T)var1;
    }

    @Nullable
    public <T> T getOptionalParameter(LootContextParameter<T> var0) {
        return (T)this.params.get(var0);
    }

    @Nullable
    public <T> T getParamOrNull(LootContextParameter<T> var0) {
        return (T)this.params.get(var0);
    }

    public void addDynamicDrops(MinecraftKey var0, Consumer<ItemStack> var1) {
        b var2 = this.dynamicDrops.get(var0);
        if (var2 != null) {
            var2.add(var1);
        }
    }

    public float getLuck() {
        return this.luck;
    }

    @FunctionalInterface
    public static interface b {
        public void add(Consumer<ItemStack> var1);
    }

    public static class a {
        private final WorldServer level;
        private final Map<LootContextParameter<?>, Object> params = Maps.newIdentityHashMap();
        private final Map<MinecraftKey, b> dynamicDrops = Maps.newHashMap();
        private float luck;

        public a(WorldServer var0) {
            this.level = var0;
        }

        public WorldServer getLevel() {
            return this.level;
        }

        public <T> a withParameter(LootContextParameter<T> var0, T var1) {
            this.params.put(var0, var1);
            return this;
        }

        public <T> a withOptionalParameter(LootContextParameter<T> var0, @Nullable T var1) {
            if (var1 == null) {
                this.params.remove(var0);
            } else {
                this.params.put(var0, var1);
            }
            return this;
        }

        public <T> T getParameter(LootContextParameter<T> var0) {
            Object var1 = this.params.get(var0);
            if (var1 == null) {
                throw new NoSuchElementException(var0.getName().toString());
            }
            return (T)var1;
        }

        @Nullable
        public <T> T getOptionalParameter(LootContextParameter<T> var0) {
            return (T)this.params.get(var0);
        }

        public a withDynamicDrop(MinecraftKey var0, b var1) {
            b var2 = this.dynamicDrops.put(var0, var1);
            if (var2 != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + String.valueOf(this.dynamicDrops) + "'");
            }
            return this;
        }

        public a withLuck(float var0) {
            this.luck = var0;
            return this;
        }

        public LootParams create(LootContextParameterSet var0) {
            Sets.SetView var1 = Sets.difference(this.params.keySet(), var0.getAllowed());
            if (!var1.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + String.valueOf(var1));
            }
            Sets.SetView var2 = Sets.difference(var0.getRequired(), this.params.keySet());
            if (!var2.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + String.valueOf(var2));
            }
            return new LootParams(this.level, this.params, this.dynamicDrops, this.luck);
        }
    }
}

