/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WorldGenFeatureDefinedStructurePoolList
extends WorldGenFeatureDefinedStructurePoolStructure {
    public static final MapCodec<WorldGenFeatureDefinedStructurePoolList> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)WorldGenFeatureDefinedStructurePoolStructure.CODEC.listOf().fieldOf("elements").forGetter(var0 -> var0.elements), WorldGenFeatureDefinedStructurePoolList.projectionCodec()).apply((Applicative)var02, WorldGenFeatureDefinedStructurePoolList::new));
    private final List<WorldGenFeatureDefinedStructurePoolStructure> elements;

    public WorldGenFeatureDefinedStructurePoolList(List<WorldGenFeatureDefinedStructurePoolStructure> var0, WorldGenFeatureDefinedStructurePoolTemplate.Matching var1) {
        super(var1);
        if (var0.isEmpty()) {
            throw new IllegalArgumentException("Elements are empty");
        }
        this.elements = var0;
        this.setProjectionOnEachElement(var1);
    }

    @Override
    public BaseBlockPosition getSize(StructureTemplateManager var0, EnumBlockRotation var1) {
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;
        for (WorldGenFeatureDefinedStructurePoolStructure var6 : this.elements) {
            BaseBlockPosition var7 = var6.getSize(var0, var1);
            var2 = Math.max(var2, var7.getX());
            var3 = Math.max(var3, var7.getY());
            var4 = Math.max(var4, var7.getZ());
        }
        return new BaseBlockPosition(var2, var3, var4);
    }

    @Override
    public List<DefinedStructure.BlockInfo> getShuffledJigsawBlocks(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, RandomSource var3) {
        return this.elements.get(0).getShuffledJigsawBlocks(var0, var1, var2, var3);
    }

    @Override
    public StructureBoundingBox getBoundingBox(StructureTemplateManager var02, BlockPosition var1, EnumBlockRotation var2) {
        Stream<StructureBoundingBox> var32 = this.elements.stream().filter(var0 -> var0 != WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE).map(var3 -> var3.getBoundingBox(var02, var1, var2));
        return StructureBoundingBox.encapsulatingBoxes(var32::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox for ListPoolElement"));
    }

    @Override
    public boolean place(StructureTemplateManager var0, GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, BlockPosition var4, BlockPosition var5, EnumBlockRotation var6, StructureBoundingBox var7, RandomSource var8, boolean var9) {
        for (WorldGenFeatureDefinedStructurePoolStructure var11 : this.elements) {
            if (var11.place(var0, var1, var2, var3, var4, var5, var6, var7, var8, var9)) continue;
            return false;
        }
        return true;
    }

    @Override
    public WorldGenFeatureDefinedStructurePools<?> getType() {
        return WorldGenFeatureDefinedStructurePools.LIST;
    }

    @Override
    public WorldGenFeatureDefinedStructurePoolStructure setProjection(WorldGenFeatureDefinedStructurePoolTemplate.Matching var0) {
        super.setProjection(var0);
        this.setProjectionOnEachElement(var0);
        return this;
    }

    public String toString() {
        return "List[" + this.elements.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    private void setProjectionOnEachElement(WorldGenFeatureDefinedStructurePoolTemplate.Matching var0) {
        this.elements.forEach(var1 -> var1.setProjection(var0));
    }
}

