/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.SystemUtils;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;

public class Beardifier
implements DensityFunctions.c {
    public static final int BEARD_KERNEL_RADIUS = 12;
    private static final int BEARD_KERNEL_SIZE = 24;
    private static final float[] BEARD_KERNEL = SystemUtils.make(new float[13824], var0 -> {
        for (int var1 = 0; var1 < 24; ++var1) {
            for (int var2 = 0; var2 < 24; ++var2) {
                for (int var3 = 0; var3 < 24; ++var3) {
                    var0[var1 * 24 * 24 + var2 * 24 + var3] = (float)Beardifier.computeBeardContribution(var2 - 12, var3 - 12, var1 - 12);
                }
            }
        }
    });
    private final ObjectListIterator<a> pieceIterator;
    private final ObjectListIterator<WorldGenFeatureDefinedStructureJigsawJunction> junctionIterator;

    public static Beardifier forStructuresInChunk(StructureManager var02, ChunkCoordIntPair var1) {
        int var2 = var1.getMinBlockX();
        int var3 = var1.getMinBlockZ();
        ObjectArrayList var4 = new ObjectArrayList(10);
        ObjectArrayList var5 = new ObjectArrayList(32);
        var02.startsForStructure(var1, var0 -> var0.terrainAdaptation() != TerrainAdjustment.NONE).forEach(arg_0 -> Beardifier.a(var1, (ObjectList)var4, var2, var3, (ObjectList)var5, arg_0));
        return new Beardifier((ObjectListIterator<a>)var4.iterator(), (ObjectListIterator<WorldGenFeatureDefinedStructureJigsawJunction>)var5.iterator());
    }

    @VisibleForTesting
    public Beardifier(ObjectListIterator<a> var0, ObjectListIterator<WorldGenFeatureDefinedStructureJigsawJunction> var1) {
        this.pieceIterator = var0;
        this.junctionIterator = var1;
    }

    @Override
    public double compute(DensityFunction.b var0) {
        int var9;
        int var8;
        Object var6;
        int var1 = var0.blockX();
        int var2 = var0.blockY();
        int var3 = var0.blockZ();
        double var4 = 0.0;
        while (this.pieceIterator.hasNext()) {
            var6 = (a)this.pieceIterator.next();
            StructureBoundingBox var7 = ((a)var6).box();
            var8 = ((a)var6).groundLevelDelta();
            var9 = Math.max(0, Math.max(var7.minX() - var1, var1 - var7.maxX()));
            int var10 = Math.max(0, Math.max(var7.minZ() - var3, var3 - var7.maxZ()));
            int var11 = var7.minY() + var8;
            int var12 = var2 - var11;
            int var13 = switch (((a)var6).terrainAdjustment()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN -> var12;
                case TerrainAdjustment.BEARD_BOX -> Math.max(0, Math.max(var11 - var2, var2 - var7.maxY()));
                case TerrainAdjustment.ENCAPSULATE -> Math.max(0, Math.max(var7.minY() - var2, var2 - var7.maxY()));
            };
            var4 += (switch (((a)var6).terrainAdjustment()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.NONE -> 0.0;
                case TerrainAdjustment.BURY -> Beardifier.getBuryContribution(var9, (double)var13 / 2.0, var10);
                case TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> Beardifier.getBeardContribution(var9, var13, var10, var12) * 0.8;
                case TerrainAdjustment.ENCAPSULATE -> Beardifier.getBuryContribution((double)var9 / 2.0, (double)var13 / 2.0, (double)var10 / 2.0) * 0.8;
            });
        }
        this.pieceIterator.back(Integer.MAX_VALUE);
        while (this.junctionIterator.hasNext()) {
            var6 = (WorldGenFeatureDefinedStructureJigsawJunction)this.junctionIterator.next();
            int var7 = var1 - ((WorldGenFeatureDefinedStructureJigsawJunction)var6).getSourceX();
            var8 = var2 - ((WorldGenFeatureDefinedStructureJigsawJunction)var6).getSourceGroundY();
            var9 = var3 - ((WorldGenFeatureDefinedStructureJigsawJunction)var6).getSourceZ();
            var4 += Beardifier.getBeardContribution(var7, var8, var9, var8) * 0.4;
        }
        this.junctionIterator.back(Integer.MAX_VALUE);
        return var4;
    }

    @Override
    public double minValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double maxValue() {
        return Double.POSITIVE_INFINITY;
    }

    private static double getBuryContribution(double var0, double var2, double var4) {
        double var6 = MathHelper.length(var0, var2, var4);
        return MathHelper.clampedMap(var6, 0.0, 6.0, 1.0, 0.0);
    }

    private static double getBeardContribution(int var0, int var1, int var2, int var3) {
        int var4 = var0 + 12;
        int var5 = var1 + 12;
        int var6 = var2 + 12;
        if (!(Beardifier.isInKernelRange(var4) && Beardifier.isInKernelRange(var5) && Beardifier.isInKernelRange(var6))) {
            return 0.0;
        }
        double var7 = (double)var3 + 0.5;
        double var9 = MathHelper.lengthSquared(var0, var7, var2);
        double var11 = -var7 * MathHelper.fastInvSqrt(var9 / 2.0) / 2.0;
        return var11 * (double)BEARD_KERNEL[var6 * 24 * 24 + var4 * 24 + var5];
    }

    private static boolean isInKernelRange(int var0) {
        return var0 >= 0 && var0 < 24;
    }

    private static double computeBeardContribution(int var0, int var1, int var2) {
        return Beardifier.computeBeardContribution(var0, (double)var1 + 0.5, var2);
    }

    private static double computeBeardContribution(int var0, double var1, int var3) {
        double var4 = MathHelper.lengthSquared(var0, var1, var3);
        double var6 = Math.pow(Math.E, -var4 / 16.0);
        return var6;
    }

    private static /* synthetic */ void a(ChunkCoordIntPair var0, ObjectList var1, int var2, int var3, ObjectList var4, StructureStart var5) {
        TerrainAdjustment var6 = var5.getStructure().terrainAdaptation();
        for (StructurePiece var8 : var5.getPieces()) {
            if (!var8.isCloseToChunk(var0, 12)) continue;
            if (var8 instanceof WorldGenFeaturePillagerOutpostPoolPiece) {
                WorldGenFeaturePillagerOutpostPoolPiece var9 = (WorldGenFeaturePillagerOutpostPoolPiece)var8;
                WorldGenFeatureDefinedStructurePoolTemplate.Matching var10 = var9.getElement().getProjection();
                if (var10 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID) {
                    var1.add((Object)new a(var9.getBoundingBox(), var6, var9.getGroundLevelDelta()));
                }
                for (WorldGenFeatureDefinedStructureJigsawJunction var12 : var9.getJunctions()) {
                    int var13 = var12.getSourceX();
                    int var14 = var12.getSourceZ();
                    if (var13 <= var2 - 12 || var14 <= var3 - 12 || var13 >= var2 + 15 + 12 || var14 >= var3 + 15 + 12) continue;
                    var4.add((Object)var12);
                }
                continue;
            }
            var1.add((Object)new a(var8.getBoundingBox(), var6, 0));
        }
    }

    @VisibleForTesting
    public record a(StructureBoundingBox box, TerrainAdjustment terrainAdjustment, int groundLevelDelta) {
    }
}

