/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3D;

public class BlockPositionSource
implements PositionSource {
    public static final MapCodec<BlockPositionSource> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BlockPosition.CODEC.fieldOf("pos").forGetter(var0 -> var0.pos)).apply((Applicative)var02, BlockPositionSource::new));
    public static final StreamCodec<ByteBuf, BlockPositionSource> STREAM_CODEC = StreamCodec.composite(BlockPosition.STREAM_CODEC, var0 -> var0.pos, BlockPositionSource::new);
    private final BlockPosition pos;

    public BlockPositionSource(BlockPosition var0) {
        this.pos = var0;
    }

    @Override
    public Optional<Vec3D> getPosition(World var0) {
        return Optional.of(Vec3D.atCenterOf(this.pos));
    }

    public PositionSourceType<BlockPositionSource> getType() {
        return PositionSourceType.BLOCK;
    }

    public static class a
    implements PositionSourceType<BlockPositionSource> {
        @Override
        public MapCodec<BlockPositionSource> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<ByteBuf, BlockPositionSource> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

