/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatusTasks;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.ToFullChunk;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.HeightMap;

public class ChunkStatus {
    public static final int MAX_STRUCTURE_DISTANCE = 8;
    private static final EnumSet<HeightMap.Type> PRE_FEATURES = EnumSet.of(HeightMap.Type.OCEAN_FLOOR_WG, HeightMap.Type.WORLD_SURFACE_WG);
    public static final EnumSet<HeightMap.Type> POST_FEATURES = EnumSet.of(HeightMap.Type.OCEAN_FLOOR, HeightMap.Type.WORLD_SURFACE, HeightMap.Type.MOTION_BLOCKING, HeightMap.Type.MOTION_BLOCKING_NO_LEAVES);
    public static final ChunkStatus EMPTY = ChunkStatus.register("empty", null, -1, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateEmpty, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus STRUCTURE_STARTS = ChunkStatus.register("structure_starts", EMPTY, 0, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateStructureStarts, ChunkStatusTasks::loadStructureStarts);
    public static final ChunkStatus STRUCTURE_REFERENCES = ChunkStatus.register("structure_references", STRUCTURE_STARTS, 8, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateStructureReferences, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus BIOMES = ChunkStatus.register("biomes", STRUCTURE_REFERENCES, 8, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateBiomes, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus NOISE = ChunkStatus.register("noise", BIOMES, 8, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateNoise, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus SURFACE = ChunkStatus.register("surface", NOISE, 8, false, PRE_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateSurface, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus CARVERS = ChunkStatus.register("carvers", SURFACE, 8, false, POST_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateCarvers, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus FEATURES = ChunkStatus.register("features", CARVERS, 8, false, POST_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateFeatures, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus INITIALIZE_LIGHT = ChunkStatus.register("initialize_light", FEATURES, 0, false, POST_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateInitializeLight, ChunkStatusTasks::loadInitializeLight);
    public static final ChunkStatus LIGHT = ChunkStatus.register("light", INITIALIZE_LIGHT, 1, true, POST_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateLight, ChunkStatusTasks::loadLight);
    public static final ChunkStatus SPAWN = ChunkStatus.register("spawn", LIGHT, 1, false, POST_FEATURES, ChunkType.PROTOCHUNK, ChunkStatusTasks::generateSpawn, ChunkStatusTasks::loadPassThrough);
    public static final ChunkStatus FULL = ChunkStatus.register("full", SPAWN, 0, false, POST_FEATURES, ChunkType.LEVELCHUNK, ChunkStatusTasks::generateFull, ChunkStatusTasks::loadFull);
    private static final List<ChunkStatus> STATUS_BY_RANGE = ImmutableList.of((Object)FULL, (Object)INITIALIZE_LIGHT, (Object)CARVERS, (Object)BIOMES, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object)STRUCTURE_STARTS, (Object[])new ChunkStatus[0]);
    private static final IntList RANGE_BY_STATUS = (IntList)SystemUtils.make(new IntArrayList(ChunkStatus.getStatusList().size()), var0 -> {
        int var1 = 0;
        for (int var2 = ChunkStatus.getStatusList().size() - 1; var2 >= 0; --var2) {
            while (var1 + 1 < STATUS_BY_RANGE.size() && var2 <= STATUS_BY_RANGE.get(var1 + 1).getIndex()) {
                ++var1;
            }
            var0.add(0, var1);
        }
    });
    private final int index;
    private final ChunkStatus parent;
    private final a generationTask;
    private final b loadingTask;
    private final int range;
    private final boolean hasLoadDependencies;
    private final ChunkType chunkType;
    private final EnumSet<HeightMap.Type> heightmapsAfter;

    private static ChunkStatus register(String var0, @Nullable ChunkStatus var1, int var2, boolean var3, EnumSet<HeightMap.Type> var4, ChunkType var5, a var6, b var7) {
        return IRegistry.register(BuiltInRegistries.CHUNK_STATUS, var0, new ChunkStatus(var1, var2, var3, var4, var5, var6, var7));
    }

    public static List<ChunkStatus> getStatusList() {
        ChunkStatus var1;
        ArrayList var0 = Lists.newArrayList();
        for (var1 = FULL; var1.getParent() != var1; var1 = var1.getParent()) {
            var0.add(var1);
        }
        var0.add(var1);
        Collections.reverse(var0);
        return var0;
    }

    public static ChunkStatus getStatusAroundFullChunk(int var0) {
        if (var0 >= STATUS_BY_RANGE.size()) {
            return EMPTY;
        }
        if (var0 < 0) {
            return FULL;
        }
        return STATUS_BY_RANGE.get(var0);
    }

    public static int maxDistance() {
        return STATUS_BY_RANGE.size();
    }

    public static int getDistance(ChunkStatus var0) {
        return RANGE_BY_STATUS.getInt(var0.getIndex());
    }

    ChunkStatus(@Nullable ChunkStatus var0, int var1, boolean var2, EnumSet<HeightMap.Type> var3, ChunkType var4, a var5, b var6) {
        this.parent = var0 == null ? this : var0;
        this.generationTask = var5;
        this.loadingTask = var6;
        this.range = var1;
        this.hasLoadDependencies = var2;
        this.chunkType = var4;
        this.heightmapsAfter = var3;
        this.index = var0 == null ? 0 : var0.getIndex() + 1;
    }

    public int getIndex() {
        return this.index;
    }

    public ChunkStatus getParent() {
        return this.parent;
    }

    public CompletableFuture<IChunkAccess> generate(WorldGenContext var0, Executor var12, ToFullChunk var2, List<IChunkAccess> var3) {
        IChunkAccess var4 = var3.get(var3.size() / 2);
        ProfiledDuration var5 = JvmProfiler.INSTANCE.onChunkGenerate(var4.getPos(), var0.level().dimension(), this.toString());
        return this.generationTask.doWork(var0, this, var12, var2, var3, var4).thenApply(var1 -> {
            ProtoChunk var2;
            if (var1 instanceof ProtoChunk && !(var2 = (ProtoChunk)var1).getStatus().isOrAfter(this)) {
                var2.setStatus(this);
            }
            if (var5 != null) {
                var5.finish();
            }
            return var1;
        });
    }

    public CompletableFuture<IChunkAccess> load(WorldGenContext var0, ToFullChunk var1, IChunkAccess var2) {
        return this.loadingTask.doWork(var0, this, var1, var2);
    }

    public int getRange() {
        return this.range;
    }

    public boolean hasLoadDependencies() {
        return this.hasLoadDependencies;
    }

    public ChunkType getChunkType() {
        return this.chunkType;
    }

    public static ChunkStatus byName(String var0) {
        return BuiltInRegistries.CHUNK_STATUS.get(MinecraftKey.tryParse(var0));
    }

    public EnumSet<HeightMap.Type> heightmapsAfter() {
        return this.heightmapsAfter;
    }

    public boolean isOrAfter(ChunkStatus var0) {
        return this.getIndex() >= var0.getIndex();
    }

    public String toString() {
        return BuiltInRegistries.CHUNK_STATUS.getKey(this).toString();
    }

    @FunctionalInterface
    protected static interface a {
        public CompletableFuture<IChunkAccess> doWork(WorldGenContext var1, ChunkStatus var2, Executor var3, ToFullChunk var4, List<IChunkAccess> var5, IChunkAccess var6);
    }

    @FunctionalInterface
    protected static interface b {
        public CompletableFuture<IChunkAccess> doWork(WorldGenContext var1, ChunkStatus var2, ToFullChunk var3, IChunkAccess var4);
    }
}

