/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;

public class TileEntityJigsaw
extends TileEntity {
    public static final String TARGET = "target";
    public static final String POOL = "pool";
    public static final String JOINT = "joint";
    public static final String PLACEMENT_PRIORITY = "placement_priority";
    public static final String SELECTION_PRIORITY = "selection_priority";
    public static final String NAME = "name";
    public static final String FINAL_STATE = "final_state";
    private MinecraftKey name = new MinecraftKey("empty");
    private MinecraftKey target = new MinecraftKey("empty");
    private ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> pool = ResourceKey.create(Registries.TEMPLATE_POOL, new MinecraftKey("empty"));
    private JointType joint = JointType.ROLLABLE;
    private String finalState = "minecraft:air";
    private int placementPriority;
    private int selectionPriority;

    public TileEntityJigsaw(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.JIGSAW, var0, var1);
    }

    public MinecraftKey getName() {
        return this.name;
    }

    public MinecraftKey getTarget() {
        return this.target;
    }

    public ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> getPool() {
        return this.pool;
    }

    public String getFinalState() {
        return this.finalState;
    }

    public JointType getJoint() {
        return this.joint;
    }

    public int getPlacementPriority() {
        return this.placementPriority;
    }

    public int getSelectionPriority() {
        return this.selectionPriority;
    }

    public void setName(MinecraftKey var0) {
        this.name = var0;
    }

    public void setTarget(MinecraftKey var0) {
        this.target = var0;
    }

    public void setPool(ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var0) {
        this.pool = var0;
    }

    public void setFinalState(String var0) {
        this.finalState = var0;
    }

    public void setJoint(JointType var0) {
        this.joint = var0;
    }

    public void setPlacementPriority(int var0) {
        this.placementPriority = var0;
    }

    public void setSelectionPriority(int var0) {
        this.selectionPriority = var0;
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        var0.putString(NAME, this.name.toString());
        var0.putString(TARGET, this.target.toString());
        var0.putString(POOL, this.pool.location().toString());
        var0.putString(FINAL_STATE, this.finalState);
        var0.putString(JOINT, this.joint.getSerializedName());
        var0.putInt(PLACEMENT_PRIORITY, this.placementPriority);
        var0.putInt(SELECTION_PRIORITY, this.selectionPriority);
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        this.name = new MinecraftKey(var0.getString(NAME));
        this.target = new MinecraftKey(var0.getString(TARGET));
        this.pool = ResourceKey.create(Registries.TEMPLATE_POOL, new MinecraftKey(var0.getString(POOL)));
        this.finalState = var0.getString(FINAL_STATE);
        this.joint = JointType.byName(var0.getString(JOINT)).orElseGet(() -> BlockJigsaw.getFrontFacing(this.getBlockState()).getAxis().isHorizontal() ? JointType.ALIGNED : JointType.ROLLABLE);
        this.placementPriority = var0.getInt(PLACEMENT_PRIORITY);
        this.selectionPriority = var0.getInt(SELECTION_PRIORITY);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    public void generate(WorldServer var0, int var1, boolean var2) {
        BlockPosition var3 = this.getBlockPos().relative(this.getBlockState().getValue(BlockJigsaw.ORIENTATION).front());
        IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var4 = var0.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL);
        Holder.c<WorldGenFeatureDefinedStructurePoolTemplate> var5 = var4.getHolderOrThrow(this.pool);
        WorldGenFeatureDefinedStructureJigsawPlacement.generateJigsaw(var0, var5, this.target, var1, var3, var2);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public static final class JointType
    extends Enum<JointType>
    implements INamable {
        public static final /* enum */ JointType ROLLABLE = new JointType("rollable");
        public static final /* enum */ JointType ALIGNED = new JointType("aligned");
        private final String name;
        private static final /* synthetic */ JointType[] d;

        public static JointType[] values() {
            return (JointType[])d.clone();
        }

        public static JointType valueOf(String var0) {
            return Enum.valueOf(JointType.class, var0);
        }

        private JointType(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static Optional<JointType> byName(String var0) {
            return Arrays.stream(JointType.values()).filter(var1 -> var1.getSerializedName().equals(var0)).findFirst();
        }

        public IChatBaseComponent getTranslatedName() {
            return IChatBaseComponent.translatable("jigsaw_block.joint." + this.name);
        }

        private static /* synthetic */ JointType[] b() {
            return new JointType[]{ROLLABLE, ALIGNED};
        }

        static {
            d = JointType.b();
        }
    }
}

