/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeCraftingHolder,
AutoRecipeOutput {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    protected NonNullList<ItemStack> items = NonNullList.withSize(3, ItemStack.EMPTY);
    public int litTime;
    int litDuration;
    public int cookingProgress;
    public int cookingTotalTime;
    @Nullable
    private static volatile Map<Item, Integer> fuelCache;
    protected final IContainerProperties dataAccess = new IContainerProperties(){

        @Override
        public int get(int var0) {
            switch (var0) {
                case 0: {
                    return TileEntityFurnace.this.litTime;
                }
                case 1: {
                    return TileEntityFurnace.this.litDuration;
                }
                case 2: {
                    return TileEntityFurnace.this.cookingProgress;
                }
                case 3: {
                    return TileEntityFurnace.this.cookingTotalTime;
                }
            }
            return 0;
        }

        @Override
        public void set(int var0, int var1) {
            switch (var0) {
                case 0: {
                    TileEntityFurnace.this.litTime = var1;
                    break;
                }
                case 1: {
                    TileEntityFurnace.this.litDuration = var1;
                    break;
                }
                case 2: {
                    TileEntityFurnace.this.cookingProgress = var1;
                    break;
                }
                case 3: {
                    TileEntityFurnace.this.cookingTotalTime = var1;
                    break;
                }
            }
        }

        @Override
        public int getCount() {
            return 4;
        }
    };
    public final Object2IntOpenHashMap<MinecraftKey> recipesUsed = new Object2IntOpenHashMap();
    private final CraftingManager.a<IInventory, ? extends RecipeCooking> quickCheck;

    protected TileEntityFurnace(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2, Recipes<? extends RecipeCooking> var3) {
        super(var0, var1, var2);
        this.quickCheck = CraftingManager.createCheck(var3);
    }

    public static void invalidateCache() {
        fuelCache = null;
    }

    public static Map<Item, Integer> getFuel() {
        Map<Item, Integer> var0 = fuelCache;
        if (var0 != null) {
            return var0;
        }
        LinkedHashMap var1 = Maps.newLinkedHashMap();
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.LAVA_BUCKET, 20000);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.COAL_BLOCK, 16000);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.BLAZE_ROD, 2400);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.COAL, 1600);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.CHARCOAL, 1600);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.LOGS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.BAMBOO_BLOCKS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.PLANKS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.BAMBOO_MOSAIC, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.WOODEN_STAIRS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.BAMBOO_MOSAIC_STAIRS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.WOODEN_SLABS, 150);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.BAMBOO_MOSAIC_SLAB, 150);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.WOODEN_TRAPDOORS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.WOODEN_PRESSURE_PLATES, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.WOODEN_FENCES, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.FENCE_GATES, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.NOTE_BLOCK, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.BOOKSHELF, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.CHISELED_BOOKSHELF, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.LECTERN, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.JUKEBOX, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.CHEST, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.TRAPPED_CHEST, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.CRAFTING_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.DAYLIGHT_DETECTOR, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.BANNERS, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.BOW, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.FISHING_ROD, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.LADDER, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.SIGNS, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.HANGING_SIGNS, 800);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.WOODEN_SHOVEL, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.WOODEN_SWORD, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.WOODEN_HOE, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.WOODEN_AXE, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.WOODEN_PICKAXE, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.WOODEN_DOORS, 200);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.BOATS, 1200);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.WOOL, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.WOODEN_BUTTONS, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.STICK, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.SAPLINGS, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.BOWL, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var1, TagsItem.WOOL_CARPETS, 67);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.DRIED_KELP_BLOCK, 4001);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Items.CROSSBOW, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.BAMBOO, 50);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.DEAD_BUSH, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.SCAFFOLDING, 50);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.LOOM, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.BARREL, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.CARTOGRAPHY_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.FLETCHING_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.SMITHING_TABLE, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.COMPOSTER, 300);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.AZALEA, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.FLOWERING_AZALEA, 100);
        TileEntityFurnace.add((Map<Item, Integer>)var1, Blocks.MANGROVE_ROOTS, 300);
        fuelCache = var1;
        return var1;
    }

    private static boolean isNeverAFurnaceFuel(Item var0) {
        return var0.builtInRegistryHolder().is(TagsItem.NON_FLAMMABLE_WOOD);
    }

    private static void add(Map<Item, Integer> var0, TagKey<Item> var1, int var2) {
        for (Holder<Item> var4 : BuiltInRegistries.ITEM.getTagOrEmpty(var1)) {
            if (TileEntityFurnace.isNeverAFurnaceFuel(var4.value())) continue;
            var0.put(var4.value(), var2);
        }
    }

    private static void add(Map<Item, Integer> var0, IMaterial var1, int var2) {
        Item var3 = var1.asItem();
        if (TileEntityFurnace.isNeverAFurnaceFuel(var3)) {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                throw SystemUtils.pauseInIde(new IllegalStateException("A developer tried to explicitly make fire resistant item " + var3.getName(null).getString() + " a furnace fuel. That will not work!"));
            }
            return;
        }
        var0.put(var3, var2);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    protected void loadAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.loadAdditional(var0, var1);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        ContainerUtil.loadAllItems(var0, this.items, var1);
        this.litTime = var0.getShort("BurnTime");
        this.cookingProgress = var0.getShort("CookTime");
        this.cookingTotalTime = var0.getShort("CookTimeTotal");
        this.litDuration = this.getBurnDuration(this.items.get(1));
        NBTTagCompound var2 = var0.getCompound("RecipesUsed");
        for (String var4 : var2.getAllKeys()) {
            this.recipesUsed.put((Object)new MinecraftKey(var4), var2.getInt(var4));
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var12) {
        super.saveAdditional(var0, var12);
        var0.putShort("BurnTime", (short)this.litTime);
        var0.putShort("CookTime", (short)this.cookingProgress);
        var0.putShort("CookTimeTotal", (short)this.cookingTotalTime);
        ContainerUtil.saveAllItems(var0, this.items, var12);
        NBTTagCompound var22 = new NBTTagCompound();
        this.recipesUsed.forEach((var1, var2) -> var22.putInt(var1.toString(), (int)var2));
        var0.put("RecipesUsed", var22);
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, TileEntityFurnace var3) {
        boolean var8;
        boolean var4 = var3.isLit();
        boolean var5 = false;
        if (var3.isLit()) {
            --var3.litTime;
        }
        ItemStack var6 = var3.items.get(1);
        boolean var7 = !var3.items.get(0).isEmpty();
        boolean bl = var8 = !var6.isEmpty();
        if (var3.isLit() || var8 && var7) {
            RecipeHolder var9 = var7 ? (RecipeHolder)var3.quickCheck.getRecipeFor(var3, var0).orElse(null) : null;
            int var10 = var3.getMaxStackSize();
            if (!var3.isLit() && TileEntityFurnace.canBurn(var0.registryAccess(), var9, var3.items, var10)) {
                var3.litDuration = var3.litTime = var3.getBurnDuration(var6);
                if (var3.isLit()) {
                    var5 = true;
                    if (var8) {
                        Item var11 = var6.getItem();
                        var6.shrink(1);
                        if (var6.isEmpty()) {
                            Item var12 = var11.getCraftingRemainingItem();
                            var3.items.set(1, var12 == null ? ItemStack.EMPTY : new ItemStack(var12));
                        }
                    }
                }
            }
            if (var3.isLit() && TileEntityFurnace.canBurn(var0.registryAccess(), var9, var3.items, var10)) {
                ++var3.cookingProgress;
                if (var3.cookingProgress == var3.cookingTotalTime) {
                    var3.cookingProgress = 0;
                    var3.cookingTotalTime = TileEntityFurnace.getTotalCookTime(var0, var3);
                    if (TileEntityFurnace.burn(var0.registryAccess(), var9, var3.items, var10)) {
                        var3.setRecipeUsed(var9);
                    }
                    var5 = true;
                }
            } else {
                var3.cookingProgress = 0;
            }
        } else if (!var3.isLit() && var3.cookingProgress > 0) {
            var3.cookingProgress = MathHelper.clamp(var3.cookingProgress - 2, 0, var3.cookingTotalTime);
        }
        if (var4 != var3.isLit()) {
            var5 = true;
            var2 = (IBlockData)var2.setValue(BlockFurnace.LIT, var3.isLit());
            var0.setBlock(var1, var2, 3);
        }
        if (var5) {
            TileEntityFurnace.setChanged(var0, var1, var2);
        }
    }

    private static boolean canBurn(IRegistryCustom var0, @Nullable RecipeHolder<?> var1, NonNullList<ItemStack> var2, int var3) {
        if (var2.get(0).isEmpty() || var1 == null) {
            return false;
        }
        ItemStack var4 = var1.value().getResultItem(var0);
        if (var4.isEmpty()) {
            return false;
        }
        ItemStack var5 = var2.get(2);
        if (var5.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents(var5, var4)) {
            return false;
        }
        if (var5.getCount() < var3 && var5.getCount() < var5.getMaxStackSize()) {
            return true;
        }
        return var5.getCount() < var4.getMaxStackSize();
    }

    private static boolean burn(IRegistryCustom var0, @Nullable RecipeHolder<?> var1, NonNullList<ItemStack> var2, int var3) {
        if (var1 == null || !TileEntityFurnace.canBurn(var0, var1, var2, var3)) {
            return false;
        }
        ItemStack var4 = var2.get(0);
        ItemStack var5 = var1.value().getResultItem(var0);
        ItemStack var6 = var2.get(2);
        if (var6.isEmpty()) {
            var2.set(2, var5.copy());
        } else if (ItemStack.isSameItemSameComponents(var6, var5)) {
            var6.grow(1);
        }
        if (var4.is(Blocks.WET_SPONGE.asItem()) && !var2.get(1).isEmpty() && var2.get(1).is(Items.BUCKET)) {
            var2.set(1, new ItemStack(Items.WATER_BUCKET));
        }
        var4.shrink(1);
        return true;
    }

    protected int getBurnDuration(ItemStack var0) {
        if (var0.isEmpty()) {
            return 0;
        }
        Item var1 = var0.getItem();
        return TileEntityFurnace.getFuel().getOrDefault(var1, 0);
    }

    private static int getTotalCookTime(World var02, TileEntityFurnace var1) {
        return var1.quickCheck.getRecipeFor(var1, var02).map(var0 -> ((RecipeCooking)var0.value()).getCookingTime()).orElse(200);
    }

    public static boolean isFuel(ItemStack var0) {
        return TileEntityFurnace.getFuel().containsKey(var0.getItem());
    }

    @Override
    public int[] getSlotsForFace(EnumDirection var0) {
        if (var0 == EnumDirection.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if (var0 == EnumDirection.UP) {
            return SLOTS_FOR_UP;
        }
        return SLOTS_FOR_SIDES;
    }

    @Override
    public boolean canPlaceItemThroughFace(int var0, ItemStack var1, @Nullable EnumDirection var2) {
        return this.canPlaceItem(var0, var1);
    }

    @Override
    public boolean canTakeItemThroughFace(int var0, ItemStack var1, EnumDirection var2) {
        if (var2 == EnumDirection.DOWN && var0 == 1) {
            return var1.is(Items.WATER_BUCKET) || var1.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> var0) {
        this.items = var0;
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        ItemStack var2 = this.items.get(var0);
        boolean var3 = !var1.isEmpty() && ItemStack.isSameItemSameComponents(var2, var1);
        this.items.set(var0, var1);
        var1.limitSize(this.getMaxStackSize(var1));
        if (var0 == 0 && !var3) {
            this.cookingTotalTime = TileEntityFurnace.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean canPlaceItem(int var0, ItemStack var1) {
        if (var0 == 2) {
            return false;
        }
        if (var0 == 1) {
            ItemStack var2 = this.items.get(1);
            return TileEntityFurnace.isFuel(var1) || var1.is(Items.BUCKET) && !var2.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public void setRecipeUsed(@Nullable RecipeHolder<?> var0) {
        if (var0 != null) {
            MinecraftKey var1 = var0.id();
            this.recipesUsed.addTo((Object)var1, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void awardUsedRecipes(EntityHuman var0, List<ItemStack> var1) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer var0) {
        List<RecipeHolder<?>> var1 = this.getRecipesToAwardAndPopExperience(var0.serverLevel(), var0.position());
        var0.awardRecipes(var1);
        for (RecipeHolder<?> var3 : var1) {
            if (var3 == null) continue;
            var0.triggerRecipeCrafted(var3, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(WorldServer var0, Vec3D var1) {
        ArrayList var2 = Lists.newArrayList();
        for (Object2IntMap.Entry var42 : this.recipesUsed.object2IntEntrySet()) {
            var0.getRecipeManager().byKey((MinecraftKey)var42.getKey()).ifPresent(var4 -> {
                var2.add(var4);
                TileEntityFurnace.createExperience(var0, var1, var42.getIntValue(), ((RecipeCooking)var4.value()).getExperience());
            });
        }
        return var2;
    }

    private static void createExperience(WorldServer var0, Vec3D var1, int var2, float var3) {
        int var4 = MathHelper.floor((float)var2 * var3);
        float var5 = MathHelper.frac((float)var2 * var3);
        if (var5 != 0.0f && Math.random() < (double)var5) {
            ++var4;
        }
        EntityExperienceOrb.award(var0, var1, var4);
    }

    @Override
    public void fillStackedContents(AutoRecipeStackManager var0) {
        for (ItemStack var2 : this.items) {
            var0.accountStack(var2);
        }
    }
}

