/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockBanner;
import net.minecraft.world.level.block.BlockBannerAbstract;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class TileEntityBanner
extends TileEntity
implements INamableTileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_PATTERNS = 6;
    private static final String TAG_PATTERNS = "patterns";
    @Nullable
    private IChatBaseComponent name;
    public EnumColor baseColor;
    private BannerPatternLayers patterns = BannerPatternLayers.EMPTY;

    public TileEntityBanner(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.BANNER, var0, var1);
        this.baseColor = ((BlockBannerAbstract)var1.getBlock()).getColor();
    }

    public TileEntityBanner(BlockPosition var0, IBlockData var1, EnumColor var2) {
        this(var0, var1);
        this.baseColor = var2;
    }

    public void fromItem(ItemStack var0, EnumColor var1) {
        this.baseColor = var1;
        this.applyComponentsFromItemStack(var0);
    }

    @Override
    public IChatBaseComponent getName() {
        if (this.name != null) {
            return this.name;
        }
        return IChatBaseComponent.translatable("block.minecraft.banner");
    }

    @Override
    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.name;
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var1) {
        super.saveAdditional(var0, var1);
        if (!this.patterns.equals(BannerPatternLayers.EMPTY)) {
            var0.put(TAG_PATTERNS, (NBTBase)BannerPatternLayers.CODEC.encodeStart(var1.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)this.patterns).getOrThrow());
        }
        if (this.name != null) {
            var0.putString("CustomName", IChatBaseComponent.ChatSerializer.toJson(this.name, var1));
        }
    }

    @Override
    protected void loadAdditional(NBTTagCompound var02, HolderLookup.a var1) {
        super.loadAdditional(var02, var1);
        if (var02.contains("CustomName", 8)) {
            this.name = IChatBaseComponent.ChatSerializer.fromJson(var02.getString("CustomName"), var1);
        }
        if (var02.contains(TAG_PATTERNS)) {
            BannerPatternLayers.CODEC.parse(var1.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var02.get(TAG_PATTERNS)).resultOrPartial(var0 -> LOGGER.error("Failed to parse banner patterns: '{}'", var0)).ifPresent(var0 -> {
                this.patterns = var0;
            });
        }
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveWithoutMetadata(var0);
    }

    public BannerPatternLayers getPatterns() {
        return this.patterns;
    }

    public ItemStack getItem() {
        ItemStack var0 = new ItemStack(BlockBanner.byColor(this.baseColor));
        var0.applyComponents(this.collectComponents());
        return var0;
    }

    public EnumColor getBaseColor() {
        return this.baseColor;
    }

    @Override
    protected void applyImplicitComponents(TileEntity.b var0) {
        super.applyImplicitComponents(var0);
        this.patterns = var0.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY);
        this.name = var0.get(DataComponents.CUSTOM_NAME);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.BANNER_PATTERNS, this.patterns);
        var0.set(DataComponents.CUSTOM_NAME, this.name);
    }

    @Override
    public void removeComponentsFromTag(NBTTagCompound var0) {
        var0.remove(TAG_PATTERNS);
        var0.remove("CustomName");
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

