/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.slf4j.Logger;

public class SculkSensorBlockEntity
extends TileEntity
implements GameEventListener.b<VibrationSystem.b>,
VibrationSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private VibrationSystem.a vibrationData;
    private final VibrationSystem.b vibrationListener;
    private final VibrationSystem.d vibrationUser = this.createVibrationUser();
    public int lastVibrationFrequency;

    protected SculkSensorBlockEntity(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        super(var0, var1, var2);
        this.vibrationData = new VibrationSystem.a();
        this.vibrationListener = new VibrationSystem.b(this);
    }

    public SculkSensorBlockEntity(BlockPosition var0, IBlockData var1) {
        this(TileEntityTypes.SCULK_SENSOR, var0, var1);
    }

    public VibrationSystem.d createVibrationUser() {
        return new a(this.getBlockPos());
    }

    @Override
    protected void loadAdditional(NBTTagCompound var02, HolderLookup.a var1) {
        super.loadAdditional(var02, var1);
        this.lastVibrationFrequency = var02.getInt("last_vibration_frequency");
        if (var02.contains("listener", 10)) {
            VibrationSystem.a.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.getCompound("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var0 -> {
                this.vibrationData = var0;
            });
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0, HolderLookup.a var12) {
        super.saveAdditional(var0, var12);
        var0.putInt("last_vibration_frequency", this.lastVibrationFrequency);
        VibrationSystem.a.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("listener", (NBTBase)var1));
    }

    @Override
    public VibrationSystem.a getVibrationData() {
        return this.vibrationData;
    }

    @Override
    public VibrationSystem.d getVibrationUser() {
        return this.vibrationUser;
    }

    public int getLastVibrationFrequency() {
        return this.lastVibrationFrequency;
    }

    public void setLastVibrationFrequency(int var0) {
        this.lastVibrationFrequency = var0;
    }

    @Override
    public VibrationSystem.b getListener() {
        return this.vibrationListener;
    }

    @Override
    public /* synthetic */ GameEventListener getListener() {
        return this.getListener();
    }

    protected class a
    implements VibrationSystem.d {
        public static final int LISTENER_RANGE = 8;
        protected final BlockPosition blockPos;
        private final PositionSource positionSource;

        public a(BlockPosition var1) {
            this.blockPos = var1;
            this.positionSource = new BlockPositionSource(var1);
        }

        @Override
        public int getListenerRadius() {
            return 8;
        }

        @Override
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        @Override
        public boolean canTriggerAvoidVibration() {
            return true;
        }

        @Override
        public boolean canReceiveVibration(WorldServer var0, BlockPosition var1, Holder<GameEvent> var2, @Nullable GameEvent.a var3) {
            if (var1.equals(this.blockPos) && (var2.is(GameEvent.BLOCK_DESTROY) || var2.is(GameEvent.BLOCK_PLACE))) {
                return false;
            }
            return SculkSensorBlock.canActivate(SculkSensorBlockEntity.this.getBlockState());
        }

        @Override
        public void onReceiveVibration(WorldServer var0, BlockPosition var1, Holder<GameEvent> var2, @Nullable Entity var3, @Nullable Entity var4, float var5) {
            IBlockData var6 = SculkSensorBlockEntity.this.getBlockState();
            if (SculkSensorBlock.canActivate(var6)) {
                SculkSensorBlockEntity.this.setLastVibrationFrequency(VibrationSystem.getGameEventFrequency(var2));
                int var7 = VibrationSystem.getRedstoneStrengthForDistance(var5, this.getListenerRadius());
                Block block = var6.getBlock();
                if (block instanceof SculkSensorBlock) {
                    SculkSensorBlock var8 = (SculkSensorBlock)block;
                    var8.activate(var3, var0, this.blockPos, var6, var7, SculkSensorBlockEntity.this.getLastVibrationFrequency());
                }
            }
        }

        @Override
        public void onDataChanged() {
            SculkSensorBlockEntity.this.setChanged();
        }

        @Override
        public boolean requiresAdjacentChunksToBeTicking() {
            return true;
        }
    }
}

