/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class SeagrassBlock
extends BlockPlant
implements IBlockFragilePlantElement,
IFluidContainer {
    public static final MapCodec<SeagrassBlock> CODEC = SeagrassBlock.simpleCodec(SeagrassBlock::new);
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 12.0, 14.0);

    public MapCodec<SeagrassBlock> codec() {
        return CODEC;
    }

    protected SeagrassBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.isFaceSturdy(var1, var2, EnumDirection.UP) && !var0.is(Blocks.MAGMA_BLOCK);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        if (var1.is(TagsFluid.WATER) && var1.getAmount() == 8) {
            return super.getStateForPlacement(var0);
        }
        return null;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        IBlockData var6 = super.updateShape(var0, var1, var2, var3, var4, var5);
        if (!var6.isAir()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return var6;
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        return FluidTypes.WATER.getSource(false);
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        IBlockData var4 = Blocks.TALL_SEAGRASS.defaultBlockState();
        IBlockData var5 = (IBlockData)var4.setValue(TallSeagrassBlock.HALF, BlockPropertyDoubleBlockHalf.UPPER);
        BlockPosition var6 = var2.above();
        if (var0.getBlockState(var6).is(Blocks.WATER)) {
            var0.setBlock(var2, var4, 2);
            var0.setBlock(var6, var5, 2);
        }
    }

    @Override
    public boolean canPlaceLiquid(@Nullable EntityHuman var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, FluidType var4) {
        return false;
    }

    @Override
    public boolean placeLiquid(GeneratorAccess var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        return false;
    }
}

