/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;

public class BuddingAmethystBlock
extends AmethystBlock {
    public static final MapCodec<BuddingAmethystBlock> CODEC = BuddingAmethystBlock.simpleCodec(BuddingAmethystBlock::new);
    public static final int GROWTH_CHANCE = 5;
    private static final EnumDirection[] DIRECTIONS = EnumDirection.values();

    public MapCodec<BuddingAmethystBlock> codec() {
        return CODEC;
    }

    public BuddingAmethystBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var3.nextInt(5) != 0) {
            return;
        }
        EnumDirection var4 = DIRECTIONS[var3.nextInt(DIRECTIONS.length)];
        BlockPosition var5 = var2.relative(var4);
        IBlockData var6 = var1.getBlockState(var5);
        Block var7 = null;
        if (BuddingAmethystBlock.canClusterGrowAtState(var6)) {
            var7 = Blocks.SMALL_AMETHYST_BUD;
        } else if (var6.is(Blocks.SMALL_AMETHYST_BUD) && var6.getValue(AmethystClusterBlock.FACING) == var4) {
            var7 = Blocks.MEDIUM_AMETHYST_BUD;
        } else if (var6.is(Blocks.MEDIUM_AMETHYST_BUD) && var6.getValue(AmethystClusterBlock.FACING) == var4) {
            var7 = Blocks.LARGE_AMETHYST_BUD;
        } else if (var6.is(Blocks.LARGE_AMETHYST_BUD) && var6.getValue(AmethystClusterBlock.FACING) == var4) {
            var7 = Blocks.AMETHYST_CLUSTER;
        }
        if (var7 != null) {
            IBlockData var8 = (IBlockData)((IBlockData)var7.defaultBlockState().setValue(AmethystClusterBlock.FACING, var4)).setValue(AmethystClusterBlock.WATERLOGGED, var6.getFluidState().getType() == FluidTypes.WATER);
            var1.setBlockAndUpdate(var5, var8);
        }
    }

    public static boolean canClusterGrowAtState(IBlockData var0) {
        return var0.isAir() || var0.is(Blocks.WATER) && var0.getFluidState().getAmount() == 8;
    }
}

