/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBubbleColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockMagma
extends Block {
    public static final MapCodec<BlockMagma> CODEC = BlockMagma.simpleCodec(BlockMagma::new);
    private static final int BUBBLE_COLUMN_CHECK_DELAY = 20;

    public MapCodec<BlockMagma> codec() {
        return CODEC;
    }

    public BlockMagma(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public void stepOn(World var0, BlockPosition var1, IBlockData var2, Entity var3) {
        if (!var3.isSteppingCarefully() && var3 instanceof EntityLiving && !EnchantmentManager.hasFrostWalker((EntityLiving)var3)) {
            var3.hurt(var0.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(var0, var1, var2, var3);
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        BlockBubbleColumn.updateColumn(var1, var2.above(), var0);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.UP && var2.is(Blocks.WATER)) {
            var3.scheduleTick(var4, this, 20);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        var1.scheduleTick(var2, this, 20);
    }
}

