/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockEnderPortal
extends BlockTileEntity {
    public static final MapCodec<BlockEnderPortal> CODEC = BlockEnderPortal.simpleCodec(BlockEnderPortal::new);
    protected static final VoxelShape SHAPE = Block.box(0.0, 6.0, 0.0, 16.0, 12.0, 16.0);

    public MapCodec<BlockEnderPortal> codec() {
        return CODEC;
    }

    protected BlockEnderPortal(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityEnderPortal(var0, var1);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (var1 instanceof WorldServer && var3.canChangeDimensions() && VoxelShapes.joinIsNotEmpty(VoxelShapes.create(var3.getBoundingBox().move(-var2.getX(), -var2.getY(), -var2.getZ())), var0.getShape(var1, var2), OperatorBoolean.AND)) {
            ResourceKey<World> var4 = var1.dimension() == World.END ? World.OVERWORLD : World.END;
            WorldServer var5 = ((WorldServer)var1).getServer().getLevel(var4);
            if (var5 == null) {
                return;
            }
            var3.changeDimension(var5);
        }
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        double var4 = (double)var2.getX() + var3.nextDouble();
        double var6 = (double)var2.getY() + 0.8;
        double var8 = (double)var2.getZ() + var3.nextDouble();
        var1.addParticle(Particles.SMOKE, var4, var6, var8, 0.0, 0.0, 0.0);
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return ItemStack.EMPTY;
    }

    @Override
    protected boolean canBeReplaced(IBlockData var0, FluidType var1) {
        return false;
    }
}

