/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public abstract class AbstractCandleBlock
extends Block {
    public static final int LIGHT_PER_CANDLE = 3;
    public static final BlockStateBoolean LIT = BlockProperties.LIT;

    protected abstract MapCodec<? extends AbstractCandleBlock> codec();

    protected AbstractCandleBlock(BlockBase.Info var0) {
        super(var0);
    }

    protected abstract Iterable<Vec3D> getParticleOffsets(IBlockData var1);

    public static boolean isLit(IBlockData var0) {
        return var0.hasProperty(LIT) && (var0.is(TagsBlock.CANDLES) || var0.is(TagsBlock.CANDLE_CAKES)) && var0.getValue(LIT) != false;
    }

    @Override
    protected void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        if (!var0.isClientSide && var3.isOnFire() && this.canBeLit(var1)) {
            AbstractCandleBlock.setLit(var0, var1, var2.getBlockPos(), true);
        }
    }

    protected boolean canBeLit(IBlockData var0) {
        return var0.getValue(LIT) == false;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var32) {
        if (!var0.getValue(LIT).booleanValue()) {
            return;
        }
        this.getParticleOffsets(var0).forEach(var3 -> AbstractCandleBlock.addParticlesAndSound(var1, var3.add(var2.getX(), var2.getY(), var2.getZ()), var32));
    }

    private static void addParticlesAndSound(World var0, Vec3D var1, RandomSource var2) {
        float var3 = var2.nextFloat();
        if (var3 < 0.3f) {
            var0.addParticle(Particles.SMOKE, var1.x, var1.y, var1.z, 0.0, 0.0, 0.0);
            if (var3 < 0.17f) {
                var0.playLocalSound(var1.x + 0.5, var1.y + 0.5, var1.z + 0.5, SoundEffects.CANDLE_AMBIENT, SoundCategory.BLOCKS, 1.0f + var2.nextFloat(), var2.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        var0.addParticle(Particles.SMALL_FLAME, var1.x, var1.y, var1.z, 0.0, 0.0, 0.0);
    }

    public static void extinguish(@Nullable EntityHuman var0, IBlockData var1, GeneratorAccess var22, BlockPosition var3) {
        AbstractCandleBlock.setLit(var22, var1, var3, false);
        if (var1.getBlock() instanceof AbstractCandleBlock) {
            ((AbstractCandleBlock)var1.getBlock()).getParticleOffsets(var1).forEach(var2 -> var22.addParticle(Particles.SMOKE, (double)var3.getX() + var2.x(), (double)var3.getY() + var2.y(), (double)var3.getZ() + var2.z(), 0.0, 0.1f, 0.0));
        }
        var22.playSound(null, var3, SoundEffects.CANDLE_EXTINGUISH, SoundCategory.BLOCKS, 1.0f, 1.0f);
        var22.gameEvent((Entity)var0, GameEvent.BLOCK_CHANGE, var3);
    }

    private static void setLit(GeneratorAccess var0, IBlockData var1, BlockPosition var2, boolean var3) {
        var0.setBlock(var2, (IBlockData)var1.setValue(LIT, var3), 11);
    }

    @Override
    protected void onExplosionHit(IBlockData var0, World var1, BlockPosition var2, Explosion var3, BiConsumer<ItemStack, BlockPosition> var4) {
        if (var3.getBlockInteraction() == Explosion.Effect.TRIGGER_BLOCK && !var1.isClientSide() && var0.getValue(LIT).booleanValue()) {
            AbstractCandleBlock.extinguish(null, var0, var1, var2);
        }
        super.onExplosionHit(var0, var1, var2, var3, var4);
    }
}

