/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public interface Spawner {
    public void setEntityId(EntityTypes<?> var1, RandomSource var2);

    public static void appendHoverText(ItemStack var0, List<IChatBaseComponent> var1, String var2) {
        IChatBaseComponent var3 = Spawner.getSpawnEntityDisplayName(var0, var2);
        if (var3 != null) {
            var1.add(var3);
        } else {
            var1.add(CommonComponents.EMPTY);
            var1.add(IChatBaseComponent.translatable("block.minecraft.spawner.desc1").withStyle(EnumChatFormat.GRAY));
            var1.add(CommonComponents.space().append(IChatBaseComponent.translatable("block.minecraft.spawner.desc2").withStyle(EnumChatFormat.BLUE)));
        }
    }

    @Nullable
    public static IChatBaseComponent getSpawnEntityDisplayName(ItemStack var02, String var1) {
        NBTTagCompound var2 = var02.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY).getUnsafe();
        MinecraftKey var3 = Spawner.getEntityKey(var2, var1);
        if (var3 != null) {
            return BuiltInRegistries.ENTITY_TYPE.getOptional(var3).map(var0 -> IChatBaseComponent.translatable(var0.getDescriptionId()).withStyle(EnumChatFormat.GRAY)).orElse(null);
        }
        return null;
    }

    @Nullable
    private static MinecraftKey getEntityKey(NBTTagCompound var0, String var1) {
        if (var0.contains(var1, 10)) {
            String var2 = var0.getCompound(var1).getCompound("entity").getString("id");
            return MinecraftKey.tryParse(var2);
        }
        return null;
    }
}

