/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom2;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.BreachEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentManager {
    private static final float SWIFT_SNEAK_EXTRA_FACTOR = 0.15f;

    public static int getItemEnchantmentLevel(Enchantment var0, ItemStack var1) {
        ItemEnchantments var2 = var1.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        return var2.getLevel(var0);
    }

    public static ItemEnchantments updateEnchantments(ItemStack var0, Consumer<ItemEnchantments.a> var1) {
        DataComponentType<ItemEnchantments> var2 = EnchantmentManager.getComponentType(var0);
        ItemEnchantments var3 = var0.get(var2);
        if (var3 == null) {
            return ItemEnchantments.EMPTY;
        }
        ItemEnchantments.a var4 = new ItemEnchantments.a(var3);
        var1.accept(var4);
        ItemEnchantments var5 = var4.toImmutable();
        var0.set(var2, var5);
        return var5;
    }

    public static boolean canStoreEnchantments(ItemStack var0) {
        return var0.has(EnchantmentManager.getComponentType(var0));
    }

    public static void setEnchantments(ItemStack var0, ItemEnchantments var1) {
        var0.set(EnchantmentManager.getComponentType(var0), var1);
    }

    public static ItemEnchantments getEnchantmentsForCrafting(ItemStack var0) {
        return var0.getOrDefault(EnchantmentManager.getComponentType(var0), ItemEnchantments.EMPTY);
    }

    private static DataComponentType<ItemEnchantments> getComponentType(ItemStack var0) {
        return var0.is(Items.ENCHANTED_BOOK) ? DataComponents.STORED_ENCHANTMENTS : DataComponents.ENCHANTMENTS;
    }

    public static boolean hasAnyEnchantments(ItemStack var0) {
        return !var0.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty() || !var0.getOrDefault(DataComponents.STORED_ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public static float getSweepingDamageRatio(int var0) {
        return 1.0f - 1.0f / (float)(var0 + 1);
    }

    private static void runIterationOnItem(a var0, ItemStack var1) {
        ItemEnchantments var2 = var1.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry<Holder<Enchantment>> var4 : var2.entrySet()) {
            var0.accept((Enchantment)((Holder)var4.getKey()).value(), var4.getIntValue());
        }
    }

    private static void runIterationOnInventory(a var0, Iterable<ItemStack> var1) {
        for (ItemStack var3 : var1) {
            EnchantmentManager.runIterationOnItem(var0, var3);
        }
    }

    public static int getDamageProtection(Iterable<ItemStack> var0, DamageSource var1) {
        MutableInt var22 = new MutableInt();
        EnchantmentManager.runIterationOnInventory((var2, var3) -> var22.add(var2.getDamageProtection(var3, var1)), var0);
        return var22.intValue();
    }

    public static float getDamageBonus(ItemStack var0, @Nullable EntityTypes<?> var1) {
        MutableFloat var22 = new MutableFloat();
        EnchantmentManager.runIterationOnItem((var2, var3) -> var22.add(var2.getDamageBonus(var3, var1)), var0);
        return var22.floatValue();
    }

    public static float getSweepingDamageRatio(EntityLiving var0) {
        int var1 = EnchantmentManager.getEnchantmentLevel(Enchantments.SWEEPING_EDGE, var0);
        if (var1 > 0) {
            return EnchantmentManager.getSweepingDamageRatio(var1);
        }
        return 0.0f;
    }

    public static float calculateArmorBreach(@Nullable Entity var0, float var1) {
        EntityLiving var2;
        int var3;
        if (var0 instanceof EntityLiving && (var3 = EnchantmentManager.getEnchantmentLevel(Enchantments.BREACH, var2 = (EntityLiving)var0)) > 0) {
            return BreachEnchantment.calculateArmorBreach(var3, var1);
        }
        return var1;
    }

    public static void doPostHurtEffects(EntityLiving var0, Entity var1) {
        a var22 = (var2, var3) -> var2.doPostHurt(var0, var1, var3);
        if (var0 != null) {
            EnchantmentManager.runIterationOnInventory(var22, var0.getAllSlots());
        }
        if (var1 instanceof EntityHuman) {
            EnchantmentManager.runIterationOnItem(var22, var0.getMainHandItem());
        }
    }

    public static void doPostDamageEffects(EntityLiving var0, Entity var1) {
        a var22 = (var2, var3) -> var2.doPostAttack(var0, var1, var3);
        if (var0 != null) {
            EnchantmentManager.runIterationOnInventory(var22, var0.getAllSlots());
        }
        if (var0 instanceof EntityHuman) {
            EnchantmentManager.runIterationOnItem(var22, var0.getMainHandItem());
        }
    }

    public static void doPostItemStackHurtEffects(EntityLiving var0, Entity var1, ItemEnchantments var2) {
        for (Object2IntMap.Entry<Holder<Enchantment>> var4 : var2.entrySet()) {
            ((Enchantment)((Holder)var4.getKey()).value()).doPostItemStackHurt(var0, var1, var4.getIntValue());
        }
    }

    public static int getEnchantmentLevel(Enchantment var0, EntityLiving var1) {
        Collection<ItemStack> var2 = var0.getSlotItems(var1).values();
        if (var2 == null) {
            return 0;
        }
        int var3 = 0;
        for (ItemStack var5 : var2) {
            int var6 = EnchantmentManager.getItemEnchantmentLevel(var0, var5);
            if (var6 <= var3) continue;
            var3 = var6;
        }
        return var3;
    }

    public static float getSneakingSpeedBonus(EntityLiving var0) {
        return (float)EnchantmentManager.getEnchantmentLevel(Enchantments.SWIFT_SNEAK, var0) * 0.15f;
    }

    public static int getKnockbackBonus(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.KNOCKBACK, var0);
    }

    public static int getFireAspect(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.FIRE_ASPECT, var0);
    }

    public static int getRespiration(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.RESPIRATION, var0);
    }

    public static int getDepthStrider(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.DEPTH_STRIDER, var0);
    }

    public static int getBlockEfficiency(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.EFFICIENCY, var0);
    }

    public static int getFishingLuckBonus(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.LUCK_OF_THE_SEA, var0);
    }

    public static int getFishingSpeedBonus(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.LURE, var0);
    }

    public static int getMobLooting(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.LOOTING, var0);
    }

    public static boolean hasAquaAffinity(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.AQUA_AFFINITY, var0) > 0;
    }

    public static boolean hasFrostWalker(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.FROST_WALKER, var0) > 0;
    }

    public static boolean hasSoulSpeed(EntityLiving var0) {
        return EnchantmentManager.getEnchantmentLevel(Enchantments.SOUL_SPEED, var0) > 0;
    }

    public static boolean hasBindingCurse(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.BINDING_CURSE, var0) > 0;
    }

    public static boolean hasVanishingCurse(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.VANISHING_CURSE, var0) > 0;
    }

    public static boolean hasSilkTouch(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.SILK_TOUCH, var0) > 0;
    }

    public static int getLoyalty(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.LOYALTY, var0);
    }

    public static int getRiptide(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.RIPTIDE, var0);
    }

    public static boolean hasChanneling(ItemStack var0) {
        return EnchantmentManager.getItemEnchantmentLevel(Enchantments.CHANNELING, var0) > 0;
    }

    @Nullable
    public static Map.Entry<EnumItemSlot, ItemStack> getRandomItemWith(Enchantment var02, EntityLiving var1) {
        return EnchantmentManager.getRandomItemWith(var02, var1, var0 -> true);
    }

    @Nullable
    public static Map.Entry<EnumItemSlot, ItemStack> getRandomItemWith(Enchantment var0, EntityLiving var1, Predicate<ItemStack> var2) {
        Map<EnumItemSlot, ItemStack> var3 = var0.getSlotItems(var1);
        if (var3.isEmpty()) {
            return null;
        }
        ArrayList var4 = Lists.newArrayList();
        for (Map.Entry<EnumItemSlot, ItemStack> var6 : var3.entrySet()) {
            ItemStack var7 = var6.getValue();
            if (var7.isEmpty() || EnchantmentManager.getItemEnchantmentLevel(var0, var7) <= 0 || !var2.test(var7)) continue;
            var4.add(var6);
        }
        return var4.isEmpty() ? null : (Map.Entry)var4.get(var1.getRandom().nextInt(var4.size()));
    }

    public static int getEnchantmentCost(RandomSource var0, int var1, int var2, ItemStack var3) {
        Item var4 = var3.getItem();
        int var5 = var4.getEnchantmentValue();
        if (var5 <= 0) {
            return 0;
        }
        if (var2 > 15) {
            var2 = 15;
        }
        int var6 = var0.nextInt(8) + 1 + (var2 >> 1) + var0.nextInt(var2 + 1);
        if (var1 == 0) {
            return Math.max(var6 / 3, 1);
        }
        if (var1 == 1) {
            return var6 * 2 / 3 + 1;
        }
        return Math.max(var6, var2 * 2);
    }

    public static ItemStack enchantItem(FeatureFlagSet var0, RandomSource var1, ItemStack var2, int var3, boolean var4) {
        List<WeightedRandomEnchant> var5 = EnchantmentManager.selectEnchantment(var0, var1, var2, var3, var4);
        if (var2.is(Items.BOOK)) {
            var2 = new ItemStack(Items.ENCHANTED_BOOK);
        }
        for (WeightedRandomEnchant var7 : var5) {
            var2.enchant(var7.enchantment, var7.level);
        }
        return var2;
    }

    public static List<WeightedRandomEnchant> selectEnchantment(FeatureFlagSet var0, RandomSource var1, ItemStack var2, int var3, boolean var4) {
        ArrayList var5 = Lists.newArrayList();
        Item var6 = var2.getItem();
        int var7 = var6.getEnchantmentValue();
        if (var7 <= 0) {
            return var5;
        }
        var3 += 1 + var1.nextInt(var7 / 4 + 1) + var1.nextInt(var7 / 4 + 1);
        float var8 = (var1.nextFloat() + var1.nextFloat() - 1.0f) * 0.15f;
        List<WeightedRandomEnchant> var9 = EnchantmentManager.getAvailableEnchantmentResults(var0, var3 = MathHelper.clamp(Math.round((float)var3 + (float)var3 * var8), 1, Integer.MAX_VALUE), var2, var4);
        if (!var9.isEmpty()) {
            WeightedRandom2.getRandomItem(var1, var9).ifPresent(var5::add);
            while (var1.nextInt(50) <= var3) {
                if (!var5.isEmpty()) {
                    EnchantmentManager.filterCompatibleEnchantments(var9, (WeightedRandomEnchant)SystemUtils.lastOf(var5));
                }
                if (var9.isEmpty()) break;
                WeightedRandom2.getRandomItem(var1, var9).ifPresent(var5::add);
                var3 /= 2;
            }
        }
        return var5;
    }

    public static void filterCompatibleEnchantments(List<WeightedRandomEnchant> var0, WeightedRandomEnchant var1) {
        Iterator<WeightedRandomEnchant> var2 = var0.iterator();
        while (var2.hasNext()) {
            if (var1.enchantment.isCompatibleWith(var2.next().enchantment)) continue;
            var2.remove();
        }
    }

    public static boolean isEnchantmentCompatible(Collection<Holder<Enchantment>> var0, Enchantment var1) {
        for (Holder<Enchantment> var3 : var0) {
            if (var3.value().isCompatibleWith(var1)) continue;
            return false;
        }
        return true;
    }

    public static List<WeightedRandomEnchant> getAvailableEnchantmentResults(FeatureFlagSet var0, int var1, ItemStack var2, boolean var3) {
        ArrayList var4 = Lists.newArrayList();
        boolean var5 = var2.is(Items.BOOK);
        block0: for (Enchantment var7 : BuiltInRegistries.ENCHANTMENT) {
            if (!var7.isEnabled(var0) || var7.isTreasureOnly() && !var3 || !var7.isDiscoverable() || !var5 && (!var7.canEnchant(var2) || !var7.isPrimaryItem(var2))) continue;
            for (int var8 = var7.getMaxLevel(); var8 > var7.getMinLevel() - 1; --var8) {
                if (var1 < var7.getMinCost(var8) || var1 > var7.getMaxCost(var8)) continue;
                var4.add(new WeightedRandomEnchant(var7, var8));
                continue block0;
            }
        }
        return var4;
    }

    @FunctionalInterface
    static interface a {
        public void accept(Enchantment var1, int var2);
    }
}

