/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Enchantment
implements FeatureElement {
    private final b definition;
    @Nullable
    protected String descriptionId;
    private final Holder.c<Enchantment> builtInRegistryHolder = BuiltInRegistries.ENCHANTMENT.createIntrusiveHolder(this);

    public static a constantCost(int var0) {
        return new a(var0, 0);
    }

    public static a dynamicCost(int var0, int var1) {
        return new a(var0, var1);
    }

    public static b definition(TagKey<Item> var0, TagKey<Item> var1, int var2, int var3, a var4, a var5, int var6, EnumItemSlot ... var7) {
        return new b(var0, Optional.of(var1), var2, var3, var4, var5, var6, FeatureFlags.DEFAULT_FLAGS, var7);
    }

    public static b definition(TagKey<Item> var0, int var1, int var2, a var3, a var4, int var5, EnumItemSlot ... var6) {
        return new b(var0, Optional.empty(), var1, var2, var3, var4, var5, FeatureFlags.DEFAULT_FLAGS, var6);
    }

    public static b definition(TagKey<Item> var0, int var1, int var2, a var3, a var4, int var5, FeatureFlagSet var6, EnumItemSlot ... var7) {
        return new b(var0, Optional.empty(), var1, var2, var3, var4, var5, var6, var7);
    }

    @Nullable
    public static Enchantment byId(int var0) {
        return (Enchantment)BuiltInRegistries.ENCHANTMENT.byId(var0);
    }

    public Enchantment(b var0) {
        this.definition = var0;
    }

    public Map<EnumItemSlot, ItemStack> getSlotItems(EntityLiving var0) {
        EnumMap var1 = Maps.newEnumMap(EnumItemSlot.class);
        for (EnumItemSlot var5 : this.definition.slots()) {
            ItemStack var6 = var0.getItemBySlot(var5);
            if (var6.isEmpty()) continue;
            var1.put(var5, var6);
        }
        return var1;
    }

    public final TagKey<Item> getSupportedItems() {
        return this.definition.supportedItems();
    }

    public final boolean isPrimaryItem(ItemStack var0) {
        return this.definition.primaryItems.isEmpty() || var0.is(this.definition.primaryItems.get());
    }

    public final int getWeight() {
        return this.definition.weight();
    }

    public final int getAnvilCost() {
        return this.definition.anvilCost();
    }

    public final int getMinLevel() {
        return 1;
    }

    public final int getMaxLevel() {
        return this.definition.maxLevel();
    }

    public final int getMinCost(int var0) {
        return this.definition.minCost().calculate(var0);
    }

    public final int getMaxCost(int var0) {
        return this.definition.maxCost().calculate(var0);
    }

    public int getDamageProtection(int var0, DamageSource var1) {
        return 0;
    }

    public float getDamageBonus(int var0, @Nullable EntityTypes<?> var1) {
        return 0.0f;
    }

    public final boolean isCompatibleWith(Enchantment var0) {
        return this.checkCompatibility(var0) && var0.checkCompatibility(this);
    }

    protected boolean checkCompatibility(Enchantment var0) {
        return this != var0;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = SystemUtils.makeDescriptionId("enchantment", BuiltInRegistries.ENCHANTMENT.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public IChatBaseComponent getFullname(int var0) {
        IChatMutableComponent var1 = IChatBaseComponent.translatable(this.getDescriptionId());
        if (this.isCurse()) {
            var1.withStyle(EnumChatFormat.RED);
        } else {
            var1.withStyle(EnumChatFormat.GRAY);
        }
        if (var0 != 1 || this.getMaxLevel() != 1) {
            var1.append(CommonComponents.SPACE).append(IChatBaseComponent.translatable("enchantment.level." + var0));
        }
        return var1;
    }

    public boolean canEnchant(ItemStack var0) {
        return var0.getItem().builtInRegistryHolder().is(this.definition.supportedItems());
    }

    public void doPostAttack(EntityLiving var0, Entity var1, int var2) {
    }

    public void doPostHurt(EntityLiving var0, Entity var1, int var2) {
    }

    public void doPostItemStackHurt(EntityLiving var0, Entity var1, int var2) {
    }

    public boolean isTreasureOnly() {
        return false;
    }

    public boolean isCurse() {
        return false;
    }

    public boolean isTradeable() {
        return true;
    }

    public boolean isDiscoverable() {
        return true;
    }

    @Deprecated
    public Holder.c<Enchantment> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.definition.requiredFeatures();
    }

    public record a(int base, int perLevel) {
        public int calculate(int var0) {
            return this.base + this.perLevel * (var0 - 1);
        }
    }

    public static final class b
    extends Record {
        private final TagKey<Item> supportedItems;
        final Optional<TagKey<Item>> primaryItems;
        private final int weight;
        private final int maxLevel;
        private final a minCost;
        private final a maxCost;
        private final int anvilCost;
        private final FeatureFlagSet requiredFeatures;
        private final EnumItemSlot[] slots;

        public b(TagKey<Item> var0, Optional<TagKey<Item>> var1, int var2, int var3, a var4, a var5, int var6, FeatureFlagSet var7, EnumItemSlot[] var8) {
            this.supportedItems = var0;
            this.primaryItems = var1;
            this.weight = var2;
            this.maxLevel = var3;
            this.minCost = var4;
            this.maxCost = var5;
            this.anvilCost = var6;
            this.requiredFeatures = var7;
            this.slots = var8;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;requiredFeatures;slots", "supportedItems", "primaryItems", "weight", "maxLevel", "minCost", "maxCost", "anvilCost", "requiredFeatures", "slots"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;requiredFeatures;slots", "supportedItems", "primaryItems", "weight", "maxLevel", "minCost", "maxCost", "anvilCost", "requiredFeatures", "slots"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;requiredFeatures;slots", "supportedItems", "primaryItems", "weight", "maxLevel", "minCost", "maxCost", "anvilCost", "requiredFeatures", "slots"}, this, var0);
        }

        public TagKey<Item> supportedItems() {
            return this.supportedItems;
        }

        public Optional<TagKey<Item>> primaryItems() {
            return this.primaryItems;
        }

        public int weight() {
            return this.weight;
        }

        public int maxLevel() {
            return this.maxLevel;
        }

        public a minCost() {
            return this.minCost;
        }

        public a maxCost() {
            return this.maxCost;
        }

        public int anvilCost() {
            return this.anvilCost;
        }

        public FeatureFlagSet requiredFeatures() {
            return this.requiredFeatures;
        }

        public EnumItemSlot[] slots() {
            return this.slots;
        }
    }
}

