/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.World;

public class SmithingTransformRecipe
implements SmithingRecipe {
    final RecipeItemStack template;
    final RecipeItemStack base;
    final RecipeItemStack addition;
    final ItemStack result;

    public SmithingTransformRecipe(RecipeItemStack var0, RecipeItemStack var1, RecipeItemStack var2, ItemStack var3) {
        this.template = var0;
        this.base = var1;
        this.addition = var2;
        this.result = var3;
    }

    @Override
    public boolean matches(IInventory var0, World var1) {
        return this.template.test(var0.getItem(0)) && this.base.test(var0.getItem(1)) && this.addition.test(var0.getItem(2));
    }

    @Override
    public ItemStack assemble(IInventory var0, HolderLookup.a var1) {
        ItemStack var2 = var0.getItem(1).transmuteCopy(this.result.getItem(), this.result.getCount());
        var2.applyComponents(this.result.getComponentsPatch());
        return var2;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.a var0) {
        return this.result;
    }

    @Override
    public boolean isTemplateIngredient(ItemStack var0) {
        return this.template.test(var0);
    }

    @Override
    public boolean isBaseIngredient(ItemStack var0) {
        return this.base.test(var0);
    }

    @Override
    public boolean isAdditionIngredient(ItemStack var0) {
        return this.addition.test(var0);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING_TRANSFORM;
    }

    @Override
    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(RecipeItemStack::isEmpty);
    }

    public static class a
    implements RecipeSerializer<SmithingTransformRecipe> {
        private static final MapCodec<SmithingTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)RecipeItemStack.CODEC.fieldOf("template").forGetter(var0 -> var0.template), (App)RecipeItemStack.CODEC.fieldOf("base").forGetter(var0 -> var0.base), (App)RecipeItemStack.CODEC.fieldOf("addition").forGetter(var0 -> var0.addition), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(var0 -> var0.result)).apply((Applicative)var02, SmithingTransformRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> STREAM_CODEC = StreamCodec.of(a::toNetwork, a::fromNetwork);

        @Override
        public MapCodec<SmithingTransformRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTransformRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SmithingTransformRecipe fromNetwork(RegistryFriendlyByteBuf var0) {
            RecipeItemStack var1 = (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(var0);
            RecipeItemStack var2 = (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(var0);
            RecipeItemStack var3 = (RecipeItemStack)RecipeItemStack.CONTENTS_STREAM_CODEC.decode(var0);
            ItemStack var4 = (ItemStack)ItemStack.STREAM_CODEC.decode(var0);
            return new SmithingTransformRecipe(var1, var2, var3, var4);
        }

        private static void toNetwork(RegistryFriendlyByteBuf var0, SmithingTransformRecipe var1) {
            RecipeItemStack.CONTENTS_STREAM_CODEC.encode(var0, var1.template);
            RecipeItemStack.CONTENTS_STREAM_CODEC.encode(var0, var1.base);
            RecipeItemStack.CONTENTS_STREAM_CODEC.encode(var0, var1.addition);
            ItemStack.STREAM_CODEC.encode(var0, var1.result);
        }
    }
}

