/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.World;

public class RecipeRepair
extends IRecipeComplex {
    public RecipeRepair(CraftingBookCategory var0) {
        super(var0);
    }

    @Nullable
    private Pair<ItemStack, ItemStack> getItemsToCombine(InventoryCrafting var0) {
        ItemStack var1 = null;
        ItemStack var2 = null;
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            ItemStack var4 = var0.getItem(var3);
            if (var4.isEmpty()) continue;
            if (var1 == null) {
                var1 = var4;
                continue;
            }
            if (var2 == null) {
                var2 = var4;
                continue;
            }
            return null;
        }
        if (var1 != null && var2 != null && RecipeRepair.canCombine(var1, var2)) {
            return Pair.of((Object)var1, var2);
        }
        return null;
    }

    private static boolean canCombine(ItemStack var0, ItemStack var1) {
        return var1.is(var0.getItem()) && var0.getCount() == 1 && var1.getCount() == 1 && var0.has(DataComponents.MAX_DAMAGE) && var1.has(DataComponents.MAX_DAMAGE) && var0.has(DataComponents.DAMAGE) && var1.has(DataComponents.DAMAGE);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        return this.getItemsToCombine(var0) != null;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0, HolderLookup.a var1) {
        Pair<ItemStack, ItemStack> var2 = this.getItemsToCombine(var0);
        if (var2 == null) {
            return ItemStack.EMPTY;
        }
        ItemStack var3 = (ItemStack)var2.getFirst();
        ItemStack var4 = (ItemStack)var2.getSecond();
        int var5 = Math.max(var3.getMaxDamage(), var4.getMaxDamage());
        int var6 = var3.getMaxDamage() - var3.getDamageValue();
        int var7 = var4.getMaxDamage() - var4.getDamageValue();
        int var8 = var6 + var7 + var5 * 5 / 100;
        ItemStack var9 = new ItemStack(var3.getItem());
        var9.set(DataComponents.MAX_DAMAGE, var5);
        var9.setDamageValue(Math.max(var5 - var8, 0));
        ItemEnchantments var10 = EnchantmentManager.getEnchantmentsForCrafting(var3);
        ItemEnchantments var11 = EnchantmentManager.getEnchantmentsForCrafting(var4);
        EnchantmentManager.updateEnchantments(var9, var32 -> var1.lookupOrThrow(Registries.ENCHANTMENT).listElements().map(Holder::value).filter(Enchantment::isCurse).forEach(var3 -> {
            int var4 = Math.max(var10.getLevel((Enchantment)var3), var11.getLevel((Enchantment)var3));
            if (var4 > 0) {
                var32.upgrade((Enchantment)var3, var4);
            }
        }));
        return var9;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.REPAIR_ITEM;
    }
}

