/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.armortrim;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.TooltipProvider;

public class ArmorTrim
implements TooltipProvider {
    public static final Codec<ArmorTrim> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)TrimMaterial.CODEC.fieldOf("material").forGetter(ArmorTrim::material), (App)TrimPattern.CODEC.fieldOf("pattern").forGetter(ArmorTrim::pattern), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(var0 -> var0.showInTooltip)).apply((Applicative)var02, ArmorTrim::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ArmorTrim> STREAM_CODEC = StreamCodec.composite(TrimMaterial.STREAM_CODEC, ArmorTrim::material, TrimPattern.STREAM_CODEC, ArmorTrim::pattern, ByteBufCodecs.BOOL, var0 -> var0.showInTooltip, ArmorTrim::new);
    private static final IChatBaseComponent UPGRADE_TITLE = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", new MinecraftKey("smithing_template.upgrade"))).withStyle(EnumChatFormat.GRAY);
    private final Holder<TrimMaterial> material;
    private final Holder<TrimPattern> pattern;
    public final boolean showInTooltip;
    private final Function<Holder<ArmorMaterial>, MinecraftKey> innerTexture;
    private final Function<Holder<ArmorMaterial>, MinecraftKey> outerTexture;

    private ArmorTrim(Holder<TrimMaterial> var0, Holder<TrimPattern> var1, boolean var2, Function<Holder<ArmorMaterial>, MinecraftKey> var3, Function<Holder<ArmorMaterial>, MinecraftKey> var4) {
        this.material = var0;
        this.pattern = var1;
        this.showInTooltip = var2;
        this.innerTexture = var3;
        this.outerTexture = var4;
    }

    public ArmorTrim(Holder<TrimMaterial> var0, Holder<TrimPattern> var1, boolean var22) {
        this.material = var0;
        this.pattern = var1;
        this.innerTexture = SystemUtils.memoize(var2 -> {
            MinecraftKey var3 = ((TrimPattern)var1.value()).assetId();
            String var4 = ArmorTrim.getColorPaletteSuffix(var0, var2);
            return var3.withPath(var1 -> "trims/models/armor/" + var1 + "_leggings_" + var4);
        });
        this.outerTexture = SystemUtils.memoize(var2 -> {
            MinecraftKey var3 = ((TrimPattern)var1.value()).assetId();
            String var4 = ArmorTrim.getColorPaletteSuffix(var0, var2);
            return var3.withPath(var1 -> "trims/models/armor/" + var1 + "_" + var4);
        });
        this.showInTooltip = var22;
    }

    public ArmorTrim(Holder<TrimMaterial> var0, Holder<TrimPattern> var1) {
        this(var0, var1, true);
    }

    private static String getColorPaletteSuffix(Holder<TrimMaterial> var0, Holder<ArmorMaterial> var1) {
        Map<Holder<ArmorMaterial>, String> var2 = var0.value().overrideArmorMaterials();
        String var3 = var2.get(var1);
        if (var3 != null) {
            return var3;
        }
        return var0.value().assetName();
    }

    public boolean hasPatternAndMaterial(Holder<TrimPattern> var0, Holder<TrimMaterial> var1) {
        return var0.equals(this.pattern) && var1.equals(this.material);
    }

    public Holder<TrimPattern> pattern() {
        return this.pattern;
    }

    public Holder<TrimMaterial> material() {
        return this.material;
    }

    public MinecraftKey innerTexture(Holder<ArmorMaterial> var0) {
        return this.innerTexture.apply(var0);
    }

    public MinecraftKey outerTexture(Holder<ArmorMaterial> var0) {
        return this.outerTexture.apply(var0);
    }

    public boolean equals(Object var0) {
        if (var0 instanceof ArmorTrim) {
            ArmorTrim var1 = (ArmorTrim)var0;
            return this.showInTooltip == var1.showInTooltip && this.pattern.equals(var1.pattern) && this.material.equals(var1.material);
        }
        return false;
    }

    public int hashCode() {
        int var0 = this.material.hashCode();
        var0 = 31 * var0 + this.pattern.hashCode();
        var0 = 31 * var0 + (this.showInTooltip ? 1 : 0);
        return var0;
    }

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2) {
        if (!this.showInTooltip) {
            return;
        }
        var1.accept(UPGRADE_TITLE);
        var1.accept(CommonComponents.space().append(this.pattern.value().copyWithStyle(this.material)));
        var1.accept(CommonComponents.space().append(this.material.value().description()));
    }

    public ArmorTrim withTooltip(boolean var0) {
        return new ArmorTrim(this.material, this.pattern, var0, this.innerTexture, this.outerTexture);
    }
}

