/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.phys.Vec3D;

public class WindChargeItem
extends Item
implements ProjectileItem {
    private static final int COOLDOWN = 10;

    public WindChargeItem(Item.Info var0) {
        super(var0);
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        Object var3;
        if (!var0.isClientSide()) {
            var3 = var1.getEyePosition().add(var1.getForward().scale(0.8f));
            if (!var0.getBlockState(BlockPosition.containing((IPosition)var3)).canBeReplaced()) {
                var3 = var1.getEyePosition().add(var1.getForward().scale(0.05f));
            }
            WindCharge var4 = new WindCharge(var1, var0, ((Vec3D)var3).x(), ((Vec3D)var3).y(), ((Vec3D)var3).z());
            var4.shootFromRotation(var1, var1.getXRot(), var1.getYRot(), 0.0f, 1.5f, 1.0f);
            var0.addFreshEntity(var4);
        }
        var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), SoundEffects.WIND_CHARGE_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
        var3 = var1.getItemInHand(var2);
        var1.getCooldowns().addCooldown(this, 10);
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        ((ItemStack)var3).consume(1, var1);
        return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
    }

    @Override
    public IProjectile asProjectile(World var0, IPosition var1, ItemStack var2, EnumDirection var3) {
        RandomSource var4 = var0.getRandom();
        double var5 = var4.triangle(var3.getStepX(), 0.11485000000000001);
        double var7 = var4.triangle(var3.getStepY(), 0.11485000000000001);
        double var9 = var4.triangle(var3.getStepZ(), 0.11485000000000001);
        return new WindCharge(var0, var1.x(), var1.y(), var1.z(), var5, var7, var9);
    }

    @Override
    public void shoot(IProjectile var0, double var1, double var3, double var5, float var7, float var8) {
    }

    @Override
    public ProjectileItem.a createDispenseConfig() {
        return ProjectileItem.a.builder().positionFunction((var0, var1) -> BlockDispenser.getDispensePosition(var0, 1.0, Vec3D.ZERO)).uncertainty(6.6666665f).power(1.0f).build();
    }
}

