/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class ItemTrident
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float SHOOT_POWER = 2.5f;

    public ItemTrident(Item.Info var0) {
        super(var0);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(GenericAttributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Tool modifier", 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(GenericAttributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Tool modifier", -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        return !var3.isCreative();
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.SPEAR;
    }

    @Override
    public int getUseDuration(ItemStack var0) {
        return 72000;
    }

    @Override
    public void releaseUsing(ItemStack var0, World var1, EntityLiving var2, int var3) {
        if (!(var2 instanceof EntityHuman)) {
            return;
        }
        EntityHuman var4 = (EntityHuman)var2;
        int var5 = this.getUseDuration(var0) - var3;
        if (var5 < 10) {
            return;
        }
        int var6 = EnchantmentManager.getRiptide(var0);
        if (var6 > 0 && !var4.isInWaterOrRain()) {
            return;
        }
        if (!var1.isClientSide) {
            var0.hurtAndBreak(1, var4, EntityLiving.getSlotForHand(var2.getUsedItemHand()));
            if (var6 == 0) {
                EntityThrownTrident var7 = new EntityThrownTrident(var1, var4, var0);
                var7.shootFromRotation(var4, var4.getXRot(), var4.getYRot(), 0.0f, 2.5f + (float)var6 * 0.5f, 1.0f);
                if (var4.hasInfiniteMaterials()) {
                    var7.pickup = EntityArrow.PickupStatus.CREATIVE_ONLY;
                }
                var1.addFreshEntity(var7);
                var1.playSound(null, var7, SoundEffects.TRIDENT_THROW, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (!var4.hasInfiniteMaterials()) {
                    var4.getInventory().removeItem(var0);
                }
            }
        }
        var4.awardStat(StatisticList.ITEM_USED.get(this));
        if (var6 > 0) {
            float var7 = var4.getYRot();
            float var8 = var4.getXRot();
            float var9 = -MathHelper.sin(var7 * ((float)Math.PI / 180)) * MathHelper.cos(var8 * ((float)Math.PI / 180));
            float var10 = -MathHelper.sin(var8 * ((float)Math.PI / 180));
            float var11 = MathHelper.cos(var7 * ((float)Math.PI / 180)) * MathHelper.cos(var8 * ((float)Math.PI / 180));
            float var12 = MathHelper.sqrt(var9 * var9 + var10 * var10 + var11 * var11);
            float var13 = 3.0f * ((1.0f + (float)var6) / 4.0f);
            var4.push(var9 *= var13 / var12, var10 *= var13 / var12, var11 *= var13 / var12);
            var4.startAutoSpinAttack(20);
            if (var4.onGround()) {
                float var14 = 1.1999999f;
                var4.move(EnumMoveType.SELF, new Vec3D(0.0, 1.1999999284744263, 0.0));
            }
            SoundEffect var14 = var6 >= 3 ? SoundEffects.TRIDENT_RIPTIDE_3 : (var6 == 2 ? SoundEffects.TRIDENT_RIPTIDE_2 : SoundEffects.TRIDENT_RIPTIDE_1);
            var1.playSound(null, var4, var14, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (var3.getDamageValue() >= var3.getMaxDamage() - 1) {
            return InteractionResultWrapper.fail(var3);
        }
        if (EnchantmentManager.getRiptide(var3) > 0 && !var1.isInWaterOrRain()) {
            return InteractionResultWrapper.fail(var3);
        }
        var1.startUsingItem(var2);
        return InteractionResultWrapper.consume(var3);
    }

    @Override
    public boolean hurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
        var0.hurtAndBreak(1, var2, EnumItemSlot.MAINHAND);
        return true;
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    @Override
    public IProjectile asProjectile(World var0, IPosition var1, ItemStack var2, EnumDirection var3) {
        EntityThrownTrident var4 = new EntityThrownTrident(var0, var1.x(), var1.y(), var1.z(), var2.copyWithCount(1));
        var4.pickup = EntityArrow.PickupStatus.ALLOWED;
        return var4;
    }
}

