/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public class ItemMilkBucket
extends Item {
    private static final int DRINK_DURATION = 32;

    public ItemMilkBucket(Item.Info var0) {
        super(var0);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        if (var2 instanceof EntityPlayer) {
            EntityPlayer var3 = (EntityPlayer)var2;
            CriterionTriggers.CONSUME_ITEM.trigger(var3, var0);
            var3.awardStat(StatisticList.ITEM_USED.get(this));
        }
        var0.consume(1, var2);
        if (!var1.isClientSide) {
            var2.removeAllEffects();
        }
        if (var0.isEmpty()) {
            return new ItemStack(Items.BUCKET);
        }
        return var0;
    }

    @Override
    public int getUseDuration(ItemStack var0) {
        return 32;
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.DRINK;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        return ItemLiquidUtil.startUsingInstantly(var0, var1, var2);
    }
}

