/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;

public class ItemLeash
extends Item {
    public ItemLeash(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        if (var3.is(TagsBlock.FENCES)) {
            EntityHuman var4 = var0.getPlayer();
            if (!var1.isClientSide && var4 != null) {
                ItemLeash.bindPlayerMobs(var4, var1, var2);
            }
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public static EnumInteractionResult bindPlayerMobs(EntityHuman var0, World var12, BlockPosition var2) {
        EntityLeash var3 = null;
        double var4 = 7.0;
        int var6 = var2.getX();
        int var7 = var2.getY();
        int var8 = var2.getZ();
        AxisAlignedBB var9 = new AxisAlignedBB((double)var6 - 7.0, (double)var7 - 7.0, (double)var8 - 7.0, (double)var6 + 7.0, (double)var7 + 7.0, (double)var8 + 7.0);
        List<EntityInsentient> var10 = var12.getEntitiesOfClass(EntityInsentient.class, var9, var1 -> var1.getLeashHolder() == var0);
        for (EntityInsentient var122 : var10) {
            if (var3 == null) {
                var3 = EntityLeash.getOrCreateKnot(var12, var2);
                var3.playPlacementSound();
            }
            var122.setLeashedTo(var3, true);
        }
        if (!var10.isEmpty()) {
            var12.gameEvent(GameEvent.BLOCK_ATTACH, var2, GameEvent.a.of(var0));
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }
}

