/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemAxe
extends ItemTool {
    protected static final Map<Block, Block> STRIPPABLES = new ImmutableMap.Builder().put((Object)Blocks.OAK_WOOD, (Object)Blocks.STRIPPED_OAK_WOOD).put((Object)Blocks.OAK_LOG, (Object)Blocks.STRIPPED_OAK_LOG).put((Object)Blocks.DARK_OAK_WOOD, (Object)Blocks.STRIPPED_DARK_OAK_WOOD).put((Object)Blocks.DARK_OAK_LOG, (Object)Blocks.STRIPPED_DARK_OAK_LOG).put((Object)Blocks.ACACIA_WOOD, (Object)Blocks.STRIPPED_ACACIA_WOOD).put((Object)Blocks.ACACIA_LOG, (Object)Blocks.STRIPPED_ACACIA_LOG).put((Object)Blocks.CHERRY_WOOD, (Object)Blocks.STRIPPED_CHERRY_WOOD).put((Object)Blocks.CHERRY_LOG, (Object)Blocks.STRIPPED_CHERRY_LOG).put((Object)Blocks.BIRCH_WOOD, (Object)Blocks.STRIPPED_BIRCH_WOOD).put((Object)Blocks.BIRCH_LOG, (Object)Blocks.STRIPPED_BIRCH_LOG).put((Object)Blocks.JUNGLE_WOOD, (Object)Blocks.STRIPPED_JUNGLE_WOOD).put((Object)Blocks.JUNGLE_LOG, (Object)Blocks.STRIPPED_JUNGLE_LOG).put((Object)Blocks.SPRUCE_WOOD, (Object)Blocks.STRIPPED_SPRUCE_WOOD).put((Object)Blocks.SPRUCE_LOG, (Object)Blocks.STRIPPED_SPRUCE_LOG).put((Object)Blocks.WARPED_STEM, (Object)Blocks.STRIPPED_WARPED_STEM).put((Object)Blocks.WARPED_HYPHAE, (Object)Blocks.STRIPPED_WARPED_HYPHAE).put((Object)Blocks.CRIMSON_STEM, (Object)Blocks.STRIPPED_CRIMSON_STEM).put((Object)Blocks.CRIMSON_HYPHAE, (Object)Blocks.STRIPPED_CRIMSON_HYPHAE).put((Object)Blocks.MANGROVE_WOOD, (Object)Blocks.STRIPPED_MANGROVE_WOOD).put((Object)Blocks.MANGROVE_LOG, (Object)Blocks.STRIPPED_MANGROVE_LOG).put((Object)Blocks.BAMBOO_BLOCK, (Object)Blocks.STRIPPED_BAMBOO_BLOCK).build();

    public ItemAxe(ToolMaterial var0, Item.Info var1) {
        super(var0, TagsBlock.MINEABLE_WITH_AXE, var1);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        EntityHuman var3;
        BlockPosition var2;
        World var1 = var0.getLevel();
        Optional<IBlockData> var4 = this.evaluateNewBlockState(var1, var2 = var0.getClickedPos(), var3 = var0.getPlayer(), var1.getBlockState(var2));
        if (var4.isEmpty()) {
            return EnumInteractionResult.PASS;
        }
        ItemStack var5 = var0.getItemInHand();
        if (var3 instanceof EntityPlayer) {
            CriterionTriggers.ITEM_USED_ON_BLOCK.trigger((EntityPlayer)var3, var2, var5);
        }
        var1.setBlock(var2, var4.get(), 11);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var3, var4.get()));
        if (var3 != null) {
            var5.hurtAndBreak(1, var3, EntityLiving.getSlotForHand(var0.getHand()));
        }
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    private Optional<IBlockData> evaluateNewBlockState(World var0, BlockPosition var12, @Nullable EntityHuman var2, IBlockData var3) {
        Optional<IBlockData> var4 = this.getStripped(var3);
        if (var4.isPresent()) {
            var0.playSound(var2, var12, SoundEffects.AXE_STRIP, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return var4;
        }
        Optional<IBlockData> var5 = WeatheringCopper.getPrevious(var3);
        if (var5.isPresent()) {
            var0.playSound(var2, var12, SoundEffects.AXE_SCRAPE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var0.levelEvent(var2, 3005, var12, 0);
            return var5;
        }
        Optional<IBlockData> var6 = Optional.ofNullable((Block)HoneycombItem.WAX_OFF_BY_BLOCK.get().get((Object)var3.getBlock())).map(var1 -> var1.withPropertiesOf(var3));
        if (var6.isPresent()) {
            var0.playSound(var2, var12, SoundEffects.AXE_WAX_OFF, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var0.levelEvent(var2, 3004, var12, 0);
            return var6;
        }
        return Optional.empty();
    }

    private Optional<IBlockData> getStripped(IBlockData var0) {
        return Optional.ofNullable(STRIPPABLES.get(var0.getBlock())).map(var1 -> (IBlockData)var1.defaultBlockState().setValue(BlockRotatable.AXIS, var0.getValue(BlockRotatable.AXIS)));
    }
}

